# Microsoft.AspNetCore.HttpLogging

``` diff
 namespace Microsoft.AspNetCore.HttpLogging {
+    public sealed class W3CLoggerOptions {
+        public W3CLoggerOptions();
+        public string FileName { get; set; }
+        public int? FileSizeLimit { get; set; }
+        public TimeSpan FlushInterval { get; set; }
+        public string LogDirectory { get; set; }
+        public W3CLoggingFields LoggingFields { get; set; }
+        public int? RetainedFileCountLimit { get; set; }
+    }
+    public enum W3CLoggingFields : long {
+        All = (long)131071,
+        ClientIpAddress = (long)4,
+        ConnectionInfoFields = (long)100,
+        Cookie = (long)32768,
+        Date = (long)1,
+        Host = (long)8192,
+        Method = (long)128,
+        None = (long)0,
+        ProtocolStatus = (long)1024,
+        ProtocolVersion = (long)4096,
+        Referer = (long)65536,
+        Request = (long)95104,
+        RequestHeaders = (long)90112,
+        ServerIpAddress = (long)32,
+        ServerName = (long)16,
+        ServerPort = (long)64,
+        Time = (long)2,
+        TimeTaken = (long)2048,
+        UriQuery = (long)512,
+        UriStem = (long)256,
+        UserAgent = (long)16384,
+        UserName = (long)8,
+    }
 }
```

