# System.Windows.Automation

``` diff
 namespace System.Windows.Automation {
+    public sealed class ActiveTextPositionChangedEventArgs : AutomationEventArgs {
+        public ActiveTextPositionChangedEventArgs(ITextRangeProvider textRangeProvider);
+        public ITextRangeProvider TextRange { get; }
+    }
     public sealed class AutomationElement {
+        public static readonly AutomationEvent ActiveTextPositionChangedEvent;
+        public static readonly AutomationEvent NotificationEvent;
+        public static readonly AutomationProperty HeadingLevelProperty;
+        public static readonly AutomationProperty IsDialogProperty;
     }
     public static class AutomationElementIdentifiers {
+        public static readonly AutomationEvent ActiveTextPositionChangedEvent;
+        public static readonly AutomationEvent NotificationEvent;
+        public static readonly AutomationProperty HeadingLevelProperty;
+        public static readonly AutomationProperty IsDialogProperty;
     }
+    public enum AutomationHeadingLevel {
+        Level1 = 1,
+        Level2 = 2,
+        Level3 = 3,
+        Level4 = 4,
+        Level5 = 5,
+        Level6 = 6,
+        Level7 = 7,
+        Level8 = 8,
+        Level9 = 9,
+        None = 0,
+    }
+    public enum AutomationNotificationKind {
+        ActionAborted = 3,
+        ActionCompleted = 2,
+        ItemAdded = 0,
+        ItemRemoved = 1,
+        Other = 4,
+    }
+    public enum AutomationNotificationProcessing {
+        All = 2,
+        CurrentThenMostRecent = 4,
+        ImportantAll = 0,
+        ImportantMostRecent = 1,
+        MostRecent = 3,
+    }
     public static class AutomationProperties {
+        public static readonly DependencyProperty HeadingLevelProperty;
+        public static readonly DependencyProperty IsDialogProperty;
+        public static AutomationHeadingLevel GetHeadingLevel(DependencyObject element);
+        public static bool GetIsDialog(DependencyObject element);
+        public static void SetHeadingLevel(DependencyObject element, AutomationHeadingLevel value);
+        public static void SetIsDialog(DependencyObject element, bool value);
     }
+    public sealed class NotificationEventArgs : AutomationEventArgs {
+        public NotificationEventArgs(AutomationNotificationKind notificationKind, AutomationNotificationProcessing notificationProcessing, string displayString, string activityId);
+        public string ActivityId { get; }
+        public string DisplayString { get; }
+        public AutomationNotificationKind NotificationKind { get; }
+        public AutomationNotificationProcessing NotificationProcessing { get; }
+    }
 }
```

