# .NET 7.0.0 Preview 6  - July 12, 2022

The .NET 7.0.0 Preview 6 and .NET SDK 7.0.100-preview.6.22352.1 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7 Preview 6

.NET 7 is the next major release of .NET following .NET 6.0. You can see some of the new features available with .NET 7 Preview 6 at [dotnet/core #7454](https://github.com/dotnet/core/issues/7454).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 6.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.100-preview.6.22352.1
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.3 latest preview](https://visualstudio.microsoft.com) to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7597](https://github.com/dotnet/core/issues/7597) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/7.0/preview/7.0.0-preview.6.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.6-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.6-sha.txt

[linux-install]: https://github.com/dotnet/core/blob/main/release-notes/7.0/install-linux.md
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-7-preview-6/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-preview-6
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7-preview6
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview6+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview6+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview6+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview6+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md


[//]: # ( Runtime 7.0.0-preview.6.22324.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2de54648-2403-45d2-ade4-97b839c4bd3d/22f95ef1972d370e9957f8d0b7310ffc/dotnet-runtime-7.0.0-preview.6.22324.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31bcf5ed-d9dc-4682-89af-99ba3382bc8d/5b5d810460212aa931dab3a6cdedb040/dotnet-runtime-7.0.0-preview.6.22324.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/92cd5c29-98c3-4aea-a533-3c1b73971903/0a153f1d987a4e331600e5db3d647edf/dotnet-runtime-7.0.0-preview.6.22324.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5023b934-6fb9-46cb-82dc-0690ae337108/1180f5c6da6b7e74f57cc56c2c4e905c/dotnet-runtime-7.0.0-preview.6.22324.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d20b7d00-af09-463c-b16f-3ef80602858a/38ef6459710989ea373686bbbe7aba7f/dotnet-runtime-7.0.0-preview.6.22324.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b235cc0f-1827-47f6-b3e9-f8ff9e2cc638/83a0c9c6e956f54bf6ad2fa4adbae5b1/dotnet-runtime-7.0.0-preview.6.22324.4-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fa1604fb-a6df-48da-b2fb-8ab72462f0b7/bfb8d8248238855cc97ac7e1650b3b39/dotnet-runtime-7.0.0-preview.6.22324.4-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4ecf88e0-d9e8-43eb-a719-b5c1beff046e/be2555036dccaeca2842b0e7760d61d6/dotnet-runtime-7.0.0-preview.6.22324.4-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/daa4040d-22af-4cc2-bbcd-ddfded0ab23f/fb6fe137309f9e8634d38b6d930aac16/dotnet-runtime-7.0.0-preview.6.22324.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd9eb4fd-eb78-4aef-97dc-223c9d72ea26/4457d1b7f2fa1e1153820d1b6f5dddbc/dotnet-runtime-7.0.0-preview.6.22324.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e17700c4-8bce-4260-bba4-4c546ba9f1f0/3000f529a2651fca121cee926a1ce809/dotnet-runtime-7.0.0-preview.6.22324.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/c838ff6c-76b6-44e3-89f4-69de512951db/c214c71d62d18a6d7fdd0ae5be51ffab/dotnet-runtime-7.0.0-preview.6.22324.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b6099655-b293-4d05-b124-f84db6d2f53a/da1c99b2b12f32253f16c81bc35c817c/dotnet-runtime-7.0.0-preview.6.22324.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/68c502dc-d254-4a42-9ca0-656b4d0b5646/03b0eafe9c3a67ed1afc032c73f083e0/dotnet-runtime-7.0.0-preview.6.22324.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8ba36868-d5c8-446b-a8c6-d592d6145ef8/ffee2c785f61ab50aee079869e33a72b/dotnet-runtime-7.0.0-preview.6.22324.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/52abd706-e2db-470b-b30d-d8aaf21fcdd9/a7adc77eb5674082174e56dcce5ddf8c/dotnet-runtime-7.0.0-preview.6.22324.4-win-x86.zip

[//]: # ( WindowsDesktop 7.0.0-preview.6.22351.3)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/63691f69-679f-4707-9d58-746d72796085/62ff78a95784791608ae6ac3b78c2ca6/windowsdesktop-runtime-7.0.0-preview.6.22351.3-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/95a00bd4-4ea7-4232-bbd0-ad84727010c0/79ae7494ef2590914352ddbabc19706a/windowsdesktop-runtime-7.0.0-preview.6.22351.3-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b3040c29-ccd5-42d7-830d-96830bca2852/c4ceb4c413c188ebef369e84e16445f6/windowsdesktop-runtime-7.0.0-preview.6.22351.3-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/db2b9f91-57f5-47f2-bbe1-616b4f4e7226/68d7549b89e1b31d1ded133c9b6dd5e4/windowsdesktop-runtime-7.0.0-preview.6.22351.3-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1fad11b9-b285-4e64-86c7-c6abad79ad3c/d1f09a58443685bd6ed430a80ad1454e/windowsdesktop-runtime-7.0.0-preview.6.22351.3-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/02d5a9f6-1441-41ca-9951-dc235b2384e4/b0a6f22f192e9d0c057cd99bcb064d34/windowsdesktop-runtime-7.0.0-preview.6.22351.3-win-x86.zip

[//]: # ( ASP 7.0.0-preview.6.22330.3)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f7da68a-6a27-4c05-8da5-f3d22d3c07ab/8610ef55b1ab45d0da9ae5d2c6d6e431/aspnetcore-runtime-7.0.0-preview.6.22330.3-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a027c7f2-01c7-4c7b-b2bf-ebdd33fa4f6b/7ae2e710aef6a9e109cd6f491c5eb6f1/aspnetcore-runtime-7.0.0-preview.6.22330.3-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/62ea006c-fab0-4a1c-8bb0-9175b40ef2c0/a6e54ed6913e8bc4f4b11f08b11bc2a6/aspnetcore-runtime-7.0.0-preview.6.22330.3-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78cfe42d-5bc9-496f-b739-71816c554c7b/b2d55d704a8216beedb856a5cf2e6694/aspnetcore-runtime-7.0.0-preview.6.22330.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/738342e2-2431-4c9d-a20e-29bac0428c99/28f5f035124a72bb979eeac4e696d2b2/aspnetcore-runtime-7.0.0-preview.6.22330.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36278471-be55-4637-94d8-ead9a528c2f0/88208d9ca97c99007b04b59cb6a3facb/aspnetcore-runtime-7.0.0-preview.6.22330.3-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb2138b8-db47-4ea1-a3f8-48b5ea7f711d/c972c6fef6565bbe78aba5b339d3033a/aspnetcore-runtime-7.0.0-preview.6.22330.3-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c7308da-3b72-4abd-8ee8-80793166bd5b/0be54db8f84be48cd7e9a2c22530d398/aspnetcore-runtime-7.0.0-preview.6.22330.3-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/439d76b4-b133-47be-b64a-4e91dc54912f/2db82e5c9b7f192d89123dd47296908e/aspnetcore-runtime-7.0.0-preview.6.22330.3-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e6a012cc-8f5b-4109-a3c7-6dd28b80661d/3a175aa3cef07e94cf5c1af80ea451f8/aspnetcore-runtime-7.0.0-preview.6.22330.3-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f5179b1d-3fb4-4ce1-95ff-712a6b7e1711/ec7169efeccb83101e7035f2d1c9c35a/aspnetcore-runtime-7.0.0-preview.6.22330.3-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/106da696-265f-40f7-bf6f-24c8b4a8e946/74100d4daa5861d812c36b3961261262/aspnetcore-runtime-7.0.0-preview.6.22330.3-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7875995a-f793-4a93-8631-d4e6a9d0b176/740c9d3c4b5a75216f26ac4d22091644/aspnetcore-runtime-7.0.0-preview.6.22330.3-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/83afb5b9-061d-47a3-993e-6c29d8573edc/65a33b4abc96252ecfefcbcb49aad3e2/dotnet-hosting-7.0.0-preview.6.22330.3-win.exe

[//]: # ( SDK 7.0.100-preview.6.22352.1)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/773b1f10-9128-4436-927c-b320c8d0d5ee/d1176d51cd9009ab34d719323d9c7b15/dotnet-sdk-7.0.100-preview.6.22352.1-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27b08d18-c7cc-4f83-9343-0d16dec83709/afa9f6f1896ebdcc2b19bafe3cbd7d6c/dotnet-sdk-7.0.100-preview.6.22352.1-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31b2448b-ecee-4ded-8e68-3ef41998100d/22794b9ea30fd9a5d8baeb2ac460c6f3/dotnet-sdk-7.0.100-preview.6.22352.1-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dfd75345-12d5-4a29-9c55-acbb3ee80ba3/c69da9541cf3b0350d1f17842677772e/dotnet-sdk-7.0.100-preview.6.22352.1-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9604b192-5b0b-4a80-bd01-003f5e9abefd/d5ec7effa972dcaf30800b105fe154f7/dotnet-sdk-7.0.100-preview.6.22352.1-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9762c43b-6de2-44aa-928d-61bec028a330/ba4d124e5384ae5c5a4599afbc41b1bf/dotnet-sdk-7.0.100-preview.6.22352.1-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ccf21c3d-0dfe-4765-a152-ab94c46e10f1/d098dd0759b6c1194913707a4a134107/dotnet-sdk-7.0.100-preview.6.22352.1-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/202fe3a0-4c4d-4bd0-bf0c-164c700c6e47/77a3a7cb1d94674db2152b9c1655711c/dotnet-sdk-7.0.100-preview.6.22352.1-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fc8101ee-2814-44a2-8851-4422ee2c135a/a819b175ab87c85f900648e38c3bb435/dotnet-sdk-7.0.100-preview.6.22352.1-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9c70049-5fd3-4a11-945d-332572b2d09a/83e98d612504f66066f6752cc9d7ae44/dotnet-sdk-7.0.100-preview.6.22352.1-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/103b0617-d7bb-488d-8110-10384512ad60/984854fd698c6ab50de2606e6e839e1e/dotnet-sdk-7.0.100-preview.6.22352.1-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/573b98fc-3fe7-4391-bbb5-1c27b7f37c0c/52b8096ec3cef43daa4f178533b19af5/dotnet-sdk-7.0.100-preview.6.22352.1-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/95bf42d6-cf29-4c83-80a9-c6d3b8ac16bb/d404c6fc1ca7650a524dd73c5a0ba21d/dotnet-sdk-7.0.100-preview.6.22352.1-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7c4e5883-6139-4093-a1cf-5f0c6fabce89/60a342b67d120328c41fe6c7ff13890b/dotnet-sdk-7.0.100-preview.6.22352.1-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/96edc251-bf96-48f9-8297-e080279c1f88/902813a5b5cc041e881eb557410cc6e3/dotnet-sdk-7.0.100-preview.6.22352.1-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d94e21af-fa23-4d11-bda3-2a416ecba410/4492f8c8a24dca864454fee95f5ca8f8/dotnet-sdk-7.0.100-preview.6.22352.1-win-x86.zip
