# Microsoft.AspNetCore.Routing

``` diff
 namespace Microsoft.AspNetCore.Routing {
+    public sealed class GroupRouteBuilder : IEndpointConventionBuilder, IEndpointRouteBuilder {
+        public RoutePattern GroupPrefix { get; }
+        ICollection<EndpointDataSource> IEndpointRouteBuilder.DataSources { get; }
+        IServiceProvider IEndpointRouteBuilder.ServiceProvider { get; }
+        void IEndpointConventionBuilder.Add(Action<EndpointBuilder> convention);
+        IApplicationBuilder IEndpointRouteBuilder.CreateApplicationBuilder();
+    }
     public static class LinkGeneratorEndpointNameAddressExtensions {
+        public static string? GetPathByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, RouteValueDictionary? values = null, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        public static string? GetPathByName(this LinkGenerator generator, string endpointName, RouteValueDictionary? values = null, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        public static string? GetUriByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, RouteValueDictionary? values = null, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        public static string? GetUriByName(this LinkGenerator generator, string endpointName, RouteValueDictionary values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
     public static class LinkGeneratorRouteValuesAddressExtensions {
+        public static string GetPathByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, RouteValueDictionary values = null, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string GetPathByRouteValues(this LinkGenerator generator, string routeName, RouteValueDictionary values = null, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string GetUriByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, RouteValueDictionary values = null, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string? GetUriByRouteValues(this LinkGenerator generator, string? routeName, RouteValueDictionary values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
 }
```

