# System.Numerics

``` diff
 namespace System.Numerics {
+    public interface IAdditionOperators<TSelf, TOther, TResult> where TSelf : IAdditionOperators<TSelf, TOther, TResult> {
+        static abstract TResult operator +(TSelf left, TOther right);
+        static abstract TResult operator checked +(TSelf left, TOther right);
+    }
+    public interface IAdditiveIdentity<TSelf, TResult> where TSelf : IAdditiveIdentity<TSelf, TResult> {
+        static abstract TResult AdditiveIdentity { get; }
+    }
+    public interface IBinaryFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFloatingPointIeee754<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryFloatingPointIeee754<TSelf>
+    {
+    }
+    public interface IBinaryInteger<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IShiftOperators<TSelf, TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryInteger<TSelf> {
+        static abstract (TSelf Quotient, TSelf Remainder) DivRem(TSelf left, TSelf right);
+        int GetByteCount();
+        long GetShortestBitLength();
+        static abstract TSelf LeadingZeroCount(TSelf value);
+        static abstract TSelf PopCount(TSelf value);
+        static abstract TSelf RotateLeft(TSelf value, int rotateAmount);
+        static abstract TSelf RotateRight(TSelf value, int rotateAmount);
+        static abstract TSelf TrailingZeroCount(TSelf value);
+        bool TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        int WriteLittleEndian(byte[] destination);
+        int WriteLittleEndian(byte[] destination, int startIndex);
+        int WriteLittleEndian(Span<byte> destination);
+    }
+    public interface IBinaryNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryNumber<TSelf> {
+        static abstract bool IsPow2(TSelf value);
+        static abstract TSelf Log2(TSelf value);
+    }
+    public interface IBitwiseOperators<TSelf, TOther, TResult> where TSelf : IBitwiseOperators<TSelf, TOther, TResult> {
+        static abstract TResult operator &(TSelf left, TOther right);
+        static abstract TResult operator |(TSelf left, TOther right);
+        static abstract TResult operator ^(TSelf left, TOther right);
+        static abstract TResult operator ~(TSelf value);
+    }
+    public interface IComparisonOperators<TSelf, TOther> : IComparable, IComparable<TOther>, IEqualityOperators<TSelf, TOther>, IEquatable<TOther> where TSelf : IComparisonOperators<TSelf, TOther> {
+        static abstract bool operator >(TSelf left, TOther right);
+        static abstract bool operator >=(TSelf left, TOther right);
+        static abstract bool operator <(TSelf left, TOther right);
+        static abstract bool operator <=(TSelf left, TOther right);
+    }
+    public interface IDecrementOperators<TSelf> where TSelf : IDecrementOperators<TSelf> {
+        static abstract TSelf operator checked --(TSelf value);
+        static abstract TSelf operator --(TSelf value);
+    }
+    public interface IDivisionOperators<TSelf, TOther, TResult> where TSelf : IDivisionOperators<TSelf, TOther, TResult> {
+        static abstract TResult operator checked /(TSelf left, TOther right);
+        static abstract TResult operator /(TSelf left, TOther right);
+    }
+    public interface IEqualityOperators<TSelf, TOther> : IEquatable<TOther> where TSelf : IEqualityOperators<TSelf, TOther> {
+        static abstract bool operator ==(TSelf left, TOther right);
+        static abstract bool operator !=(TSelf left, TOther right);
+    }
+    public interface IExponentialFunctions<TSelf> where TSelf : IExponentialFunctions<TSelf> {
+        static abstract TSelf Exp(TSelf x);
+    }
+    public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPoint<TSelf> {
+        static abstract TSelf Ceiling(TSelf x);
+        static abstract TSelf Floor(TSelf x);
+        int GetExponentByteCount();
+        long GetExponentShortestBitLength();
+        long GetSignificandBitLength();
+        int GetSignificandByteCount();
+        static abstract TSelf Round(TSelf x);
+        static abstract TSelf Round(TSelf x, int digits);
+        static abstract TSelf Round(TSelf x, int digits, MidpointRounding mode);
+        static abstract TSelf Round(TSelf x, MidpointRounding mode);
+        static abstract TSelf Truncate(TSelf x);
+        bool TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        int WriteExponentLittleEndian(byte[] destination);
+        int WriteExponentLittleEndian(byte[] destination, int startIndex);
+        int WriteExponentLittleEndian(Span<byte> destination);
+        int WriteSignificandLittleEndian(byte[] destination);
+        int WriteSignificandLittleEndian(byte[] destination, int startIndex);
+        int WriteSignificandLittleEndian(Span<byte> destination);
+    }
+    public interface IFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPointIeee754<TSelf> {
+        static abstract TSelf E { get; }
+        static abstract TSelf Epsilon { get; }
+        static abstract TSelf NaN { get; }
+        static abstract TSelf NegativeInfinity { get; }
+        static abstract TSelf NegativeZero { get; }
+        static abstract TSelf Pi { get; }
+        static abstract TSelf PositiveInfinity { get; }
+        static abstract TSelf Tau { get; }
+        static abstract TSelf BitDecrement(TSelf x);
+        static abstract TSelf BitIncrement(TSelf x);
+        static abstract TSelf FusedMultiplyAdd(TSelf left, TSelf right, TSelf addend);
+        static abstract TSelf Ieee754Remainder(TSelf left, TSelf right);
+        static abstract int ILogB(TSelf x);
+        static abstract bool IsFinite(TSelf value);
+        static abstract bool IsInfinity(TSelf value);
+        static abstract bool IsNaN(TSelf value);
+        static abstract bool IsNegativeInfinity(TSelf value);
+        static abstract bool IsNormal(TSelf value);
+        static abstract bool IsPositiveInfinity(TSelf value);
+        static abstract bool IsSubnormal(TSelf value);
+        static abstract TSelf ReciprocalEstimate(TSelf x);
+        static abstract TSelf ReciprocalSqrtEstimate(TSelf x);
+        static abstract TSelf ScaleB(TSelf x, int n);
+    }
+    public interface IHyperbolicFunctions<TSelf> where TSelf : IHyperbolicFunctions<TSelf> {
+        static abstract TSelf Acosh(TSelf x);
+        static abstract TSelf Asinh(TSelf x);
+        static abstract TSelf Atanh(TSelf x);
+        static abstract TSelf Cosh(TSelf x);
+        static abstract TSelf Sinh(TSelf x);
+        static abstract TSelf Tanh(TSelf x);
+    }
+    public interface IIncrementOperators<TSelf> where TSelf : IIncrementOperators<TSelf> {
+        static abstract TSelf operator checked ++(TSelf value);
+        static abstract TSelf operator ++(TSelf value);
+    }
+    public interface ILogarithmicFunctions<TSelf> where TSelf : ILogarithmicFunctions<TSelf> {
+        static abstract TSelf Log(TSelf x);
+        static abstract TSelf Log(TSelf x, TSelf newBase);
+        static abstract TSelf Log10(TSelf x);
+        static abstract TSelf Log2(TSelf x);
+    }
+    public interface IMinMaxValue<TSelf> where TSelf : IMinMaxValue<TSelf> {
+        static abstract TSelf MaxValue { get; }
+        static abstract TSelf MinValue { get; }
+    }
+    public interface IModulusOperators<TSelf, TOther, TResult> where TSelf : IModulusOperators<TSelf, TOther, TResult> {
+        static abstract TResult operator %(TSelf left, TOther right);
+    }
+    public interface IMultiplicativeIdentity<TSelf, TResult> where TSelf : IMultiplicativeIdentity<TSelf, TResult> {
+        static abstract TResult MultiplicativeIdentity { get; }
+    }
+    public interface IMultiplyOperators<TSelf, TOther, TResult> where TSelf : IMultiplyOperators<TSelf, TOther, TResult> {
+        static abstract TResult operator checked *(TSelf left, TOther right);
+        static abstract TResult operator *(TSelf left, TOther right);
+    }
+    public interface INumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumber<TSelf> {
+        static abstract TSelf Abs(TSelf value);
+        static abstract TSelf Clamp(TSelf value, TSelf min, TSelf max);
+        static abstract TSelf CopySign(TSelf value, TSelf sign);
+        static abstract TSelf CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
+        static abstract TSelf CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
+        static abstract TSelf CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        static abstract bool IsNegative(TSelf value);
+        static abstract TSelf Max(TSelf x, TSelf y);
+        static abstract TSelf MaxMagnitude(TSelf x, TSelf y);
+        static abstract TSelf Min(TSelf x, TSelf y);
+        static abstract TSelf MinMagnitude(TSelf x, TSelf y);
+        static abstract TSelf Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider);
+        static abstract TSelf Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static abstract int Sign(TSelf value);
+        static abstract bool TryCreate<TOther>(TOther value, out TSelf result) where TOther : INumber<TOther>;
+        static abstract bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out TSelf result);
+        static abstract bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out TSelf result);
+    }
+    public interface INumberBase<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, ISpanFormattable, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumberBase<TSelf> {
+        static abstract TSelf One { get; }
+        static abstract TSelf Zero { get; }
+    }
+    public interface IPowerFunctions<TSelf> where TSelf : IPowerFunctions<TSelf> {
+        static abstract TSelf Pow(TSelf x, TSelf y);
+    }
+    public interface IRootFunctions<TSelf> where TSelf : IRootFunctions<TSelf> {
+        static abstract TSelf Cbrt(TSelf x);
+        static abstract TSelf Sqrt(TSelf x);
+    }
+    public interface IShiftOperators<TSelf, TResult> where TSelf : IShiftOperators<TSelf, TResult> {
+        static abstract TResult operator <<(TSelf value, int shiftAmount);
+        static abstract TResult operator >>(TSelf value, int shiftAmount);
+        static abstract TResult operator >>>(TSelf value, int shiftAmount);
+    }
+    public interface ISignedNumber<TSelf> where TSelf : INumberBase<TSelf>, ISignedNumber<TSelf> {
+        static abstract TSelf NegativeOne { get; }
+    }
+    public interface ISubtractionOperators<TSelf, TOther, TResult> where TSelf : ISubtractionOperators<TSelf, TOther, TResult> {
+        static abstract TResult operator checked -(TSelf left, TOther right);
+        static abstract TResult operator -(TSelf left, TOther right);
+    }
+    public interface ITrigonometricFunctions<TSelf> where TSelf : ITrigonometricFunctions<TSelf> {
+        static abstract TSelf Acos(TSelf x);
+        static abstract TSelf Asin(TSelf x);
+        static abstract TSelf Atan(TSelf x);
+        static abstract TSelf Atan2(TSelf y, TSelf x);
+        static abstract TSelf Cos(TSelf x);
+        static abstract TSelf Sin(TSelf x);
+        static abstract (TSelf Sin, TSelf Cos) SinCos(TSelf x);
+        static abstract TSelf Tan(TSelf x);
+    }
+    public interface IUnaryNegationOperators<TSelf, TResult> where TSelf : IUnaryNegationOperators<TSelf, TResult> {
+        static abstract TResult operator checked -(TSelf value);
+        static abstract TResult operator -(TSelf value);
+    }
+    public interface IUnaryPlusOperators<TSelf, TResult> where TSelf : IUnaryPlusOperators<TSelf, TResult> {
+        static abstract TResult operator +(TSelf value);
+    }
+    public interface IUnsignedNumber<TSelf> where TSelf : INumberBase<TSelf>, IUnsignedNumber<TSelf>
+    {
+    }
 }
```

