# System.Numerics

``` diff
 namespace System.Numerics {
-    public readonly struct BigInteger : IComparable, IComparable<BigInteger>, IEquatable<BigInteger>, IFormattable, ISpanFormattable {
+    public readonly struct BigInteger : IAdditionOperators<BigInteger, BigInteger, BigInteger>, IAdditiveIdentity<BigInteger, BigInteger>, IBinaryInteger<BigInteger>, IBinaryNumber<BigInteger>, IBitwiseOperators<BigInteger, BigInteger, BigInteger>, IComparable, IComparable<BigInteger>, IComparisonOperators<BigInteger, BigInteger>, IDecrementOperators<BigInteger>, IDivisionOperators<BigInteger, BigInteger, BigInteger>, IEqualityOperators<BigInteger, BigInteger>, IEquatable<BigInteger>, IFormattable, IIncrementOperators<BigInteger>, IModulusOperators<BigInteger, BigInteger, BigInteger>, IMultiplicativeIdentity<BigInteger, BigInteger>, IMultiplyOperators<BigInteger, BigInteger, BigInteger>, INumber<BigInteger>, INumberBase<BigInteger>, IParsable<BigInteger>, IShiftOperators<BigInteger, BigInteger>, ISignedNumber<BigInteger>, ISpanFormattable, ISpanParsable<BigInteger>, ISubtractionOperators<BigInteger, BigInteger, BigInteger>, IUnaryNegationOperators<BigInteger, BigInteger>, IUnaryPlusOperators<BigInteger, BigInteger> {
+        static BigInteger System.Numerics.IAdditiveIdentity<System.Numerics.BigInteger,System.Numerics.BigInteger>.AdditiveIdentity { get; }
+        static BigInteger System.Numerics.IMultiplicativeIdentity<System.Numerics.BigInteger,System.Numerics.BigInteger>.MultiplicativeIdentity { get; }
+        static int System.Numerics.INumberBase<System.Numerics.BigInteger>.Radix { get; }
+        static BigInteger System.Numerics.ISignedNumber<System.Numerics.BigInteger>.NegativeOne { get; }
+        public static BigInteger Clamp(BigInteger value, BigInteger min, BigInteger max);
+        public static BigInteger CopySign(BigInteger value, BigInteger sign);
+        public static (BigInteger Quotient, BigInteger Remainder) DivRem(BigInteger left, BigInteger right);
+        public static bool IsEvenInteger(BigInteger value);
+        public static bool IsNegative(BigInteger value);
+        public static bool IsOddInteger(BigInteger value);
+        public static bool IsPositive(BigInteger value);
+        public static bool IsPow2(BigInteger value);
+        public static BigInteger LeadingZeroCount(BigInteger value);
+        public static BigInteger Log2(BigInteger value);
+        public static BigInteger MaxMagnitude(BigInteger x, BigInteger y);
+        public static BigInteger MinMagnitude(BigInteger x, BigInteger y);
+        public static explicit operator BigInteger (Half value);
+        public static explicit operator char (BigInteger value);
+        public static explicit operator Half (BigInteger value);
+        public static explicit operator Int128 (BigInteger value);
+        public static explicit operator nint (BigInteger value);
+        public static explicit operator UInt128 (BigInteger value);
+        public static explicit operator nuint (BigInteger value);
+        public static explicit operator BigInteger (Complex value);
+        public static implicit operator BigInteger (char value);
+        public static implicit operator BigInteger (Int128 value);
+        public static implicit operator BigInteger (IntPtr value);
+        public static implicit operator BigInteger (UInt128 value);
+        public static implicit operator BigInteger (UIntPtr value);
+        public static BigInteger operator >>>(BigInteger value, int shiftAmount);
+        public static BigInteger Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static BigInteger PopCount(BigInteger value);
+        public static BigInteger RotateLeft(BigInteger value, int rotateAmount);
+        public static BigInteger RotateRight(BigInteger value, int rotateAmount);
+        static BigInteger IAdditionOperators<BigInteger, BigInteger, BigInteger>.operator checked +(BigInteger left, BigInteger right);
+        int IBinaryInteger<BigInteger>.GetByteCount();
+        int IBinaryInteger<BigInteger>.GetShortestBitLength();
+        bool IBinaryInteger<BigInteger>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<BigInteger>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static BigInteger IDecrementOperators<BigInteger>.operator checked --(BigInteger value);
+        static BigInteger IDivisionOperators<BigInteger, BigInteger, BigInteger>.operator checked /(BigInteger left, BigInteger right);
+        static BigInteger IIncrementOperators<BigInteger>.operator checked ++(BigInteger value);
+        static BigInteger IMultiplyOperators<BigInteger, BigInteger, BigInteger>.operator checked *(BigInteger left, BigInteger right);
+        static BigInteger INumber<BigInteger>.MaxNumber(BigInteger x, BigInteger y);
+        static BigInteger INumber<BigInteger>.MinNumber(BigInteger x, BigInteger y);
+        static int INumber<BigInteger>.Sign(BigInteger value);
+        static bool INumberBase<BigInteger>.IsCanonical(BigInteger value);
+        static bool INumberBase<BigInteger>.IsComplexNumber(BigInteger value);
+        static bool INumberBase<BigInteger>.IsFinite(BigInteger value);
+        static bool INumberBase<BigInteger>.IsImaginaryNumber(BigInteger value);
+        static bool INumberBase<BigInteger>.IsInfinity(BigInteger value);
+        static bool INumberBase<BigInteger>.IsInteger(BigInteger value);
+        static bool INumberBase<BigInteger>.IsNaN(BigInteger value);
+        static bool INumberBase<BigInteger>.IsNegativeInfinity(BigInteger value);
+        static bool INumberBase<BigInteger>.IsNormal(BigInteger value);
+        static bool INumberBase<BigInteger>.IsPositiveInfinity(BigInteger value);
+        static bool INumberBase<BigInteger>.IsRealNumber(BigInteger value);
+        static bool INumberBase<BigInteger>.IsSubnormal(BigInteger value);
+        static bool INumberBase<BigInteger>.IsZero(BigInteger value);
+        static BigInteger INumberBase<BigInteger>.MaxMagnitudeNumber(BigInteger x, BigInteger y);
+        static BigInteger INumberBase<BigInteger>.MinMagnitudeNumber(BigInteger x, BigInteger y);
+        static bool INumberBase<BigInteger>.TryConvertFromChecked<TOther>(TOther value, out BigInteger result);
+        static bool INumberBase<BigInteger>.TryConvertFromSaturating<TOther>(TOther value, out BigInteger result);
+        static bool INumberBase<BigInteger>.TryConvertFromTruncating<TOther>(TOther value, out BigInteger result);
+        static bool INumberBase<BigInteger>.TryConvertToChecked<TOther>(BigInteger value, out TOther result);
+        static bool INumberBase<BigInteger>.TryConvertToSaturating<TOther>(BigInteger value, out TOther result);
+        static bool INumberBase<BigInteger>.TryConvertToTruncating<TOther>(BigInteger value, out TOther result);
+        static BigInteger ISubtractionOperators<BigInteger, BigInteger, BigInteger>.operator checked -(BigInteger left, BigInteger right);
+        static BigInteger IUnaryNegationOperators<BigInteger, BigInteger>.operator checked -(BigInteger value);
+        public static BigInteger TrailingZeroCount(BigInteger value);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out BigInteger result);
+        public static bool TryParse(string? s, IFormatProvider? provider, out BigInteger result);
     }
-    public readonly struct Complex : IEquatable<Complex>, IFormattable {
+    public readonly struct Complex : IAdditionOperators<Complex, Complex, Complex>, IAdditiveIdentity<Complex, Complex>, IDecrementOperators<Complex>, IDivisionOperators<Complex, Complex, Complex>, IEqualityOperators<Complex, Complex>, IEquatable<Complex>, IFormattable, IIncrementOperators<Complex>, IMultiplicativeIdentity<Complex, Complex>, IMultiplyOperators<Complex, Complex, Complex>, INumberBase<Complex>, IParsable<Complex>, ISignedNumber<Complex>, ISpanFormattable, ISpanParsable<Complex>, ISubtractionOperators<Complex, Complex, Complex>, IUnaryNegationOperators<Complex, Complex>, IUnaryPlusOperators<Complex, Complex> {
+        static Complex System.Numerics.IAdditiveIdentity<System.Numerics.Complex,System.Numerics.Complex>.AdditiveIdentity { get; }
+        static Complex System.Numerics.IMultiplicativeIdentity<System.Numerics.Complex,System.Numerics.Complex>.MultiplicativeIdentity { get; }
+        static Complex System.Numerics.INumberBase<System.Numerics.Complex>.One { get; }
+        static int System.Numerics.INumberBase<System.Numerics.Complex>.Radix { get; }
+        static Complex System.Numerics.INumberBase<System.Numerics.Complex>.Zero { get; }
+        static Complex System.Numerics.ISignedNumber<System.Numerics.Complex>.NegativeOne { get; }
+        public static bool IsComplexNumber(Complex value);
+        public static bool IsEvenInteger(Complex value);
+        public static bool IsImaginaryNumber(Complex value);
+        public static bool IsInteger(Complex value);
+        public static bool IsNegative(Complex value);
+        public static bool IsNegativeInfinity(Complex value);
+        public static bool IsNormal(Complex value);
+        public static bool IsOddInteger(Complex value);
+        public static bool IsPositive(Complex value);
+        public static bool IsPositiveInfinity(Complex value);
+        public static bool IsRealNumber(Complex value);
+        public static bool IsSubnormal(Complex value);
+        public static Complex MaxMagnitude(Complex x, Complex y);
+        public static Complex MinMagnitude(Complex x, Complex y);
+        public static Complex operator --(Complex value);
+        public static explicit operator Complex (Int128 value);
+        public static explicit operator Complex (UInt128 value);
+        public static implicit operator Complex (char value);
+        public static implicit operator Complex (Half value);
+        public static implicit operator Complex (IntPtr value);
+        public static implicit operator Complex (UIntPtr value);
+        public static Complex operator ++(Complex value);
+        public static Complex operator +(Complex value);
+        public static Complex Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider);
+        public static Complex Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static Complex Parse(string s, NumberStyles style, IFormatProvider? provider);
+        public static Complex Parse(string s, IFormatProvider? provider);
+        static Complex IAdditionOperators<Complex, Complex, Complex>.operator checked +(Complex left, Complex right);
+        static Complex IDecrementOperators<Complex>.operator checked --(Complex value);
+        static Complex IDivisionOperators<Complex, Complex, Complex>.operator checked /(Complex left, Complex right);
+        static Complex IIncrementOperators<Complex>.operator checked ++(Complex value);
+        static Complex IMultiplyOperators<Complex, Complex, Complex>.operator checked *(Complex left, Complex right);
+        static Complex INumberBase<Complex>.Abs(Complex value);
+        static bool INumberBase<Complex>.IsCanonical(Complex value);
+        static bool INumberBase<Complex>.IsZero(Complex value);
+        static Complex INumberBase<Complex>.MaxMagnitudeNumber(Complex x, Complex y);
+        static Complex INumberBase<Complex>.MinMagnitudeNumber(Complex x, Complex y);
+        static bool INumberBase<Complex>.TryConvertFromChecked<TOther>(TOther value, out Complex result);
+        static bool INumberBase<Complex>.TryConvertFromSaturating<TOther>(TOther value, out Complex result);
+        static bool INumberBase<Complex>.TryConvertFromTruncating<TOther>(TOther value, out Complex result);
+        static bool INumberBase<Complex>.TryConvertToChecked<TOther>(Complex value, out TOther result);
+        static bool INumberBase<Complex>.TryConvertToSaturating<TOther>(Complex value, out TOther result);
+        static bool INumberBase<Complex>.TryConvertToTruncating<TOther>(Complex value, out TOther result);
+        static Complex ISubtractionOperators<Complex, Complex, Complex>.operator checked -(Complex left, Complex right);
+        static Complex IUnaryNegationOperators<Complex, Complex>.operator checked -(Complex value);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider? provider);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Complex result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Complex result);
+        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Complex result);
+        public static bool TryParse(string? s, IFormatProvider? provider, out Complex result);
     }
     public interface IBinaryInteger<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IShiftOperators<TSelf, TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryInteger<TSelf> {
-        long GetShortestBitLength();
+        int GetShortestBitLength();
+        bool TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        int WriteBigEndian(byte[] destination);
+        int WriteBigEndian(byte[] destination, int startIndex);
+        int WriteBigEndian(Span<byte> destination);
     }
     public interface IExponentialFunctions<TSelf> where TSelf : IExponentialFunctions<TSelf> {
+        static abstract TSelf Exp10(TSelf x);
+        static abstract TSelf Exp10M1(TSelf x);
+        static abstract TSelf Exp2(TSelf x);
+        static abstract TSelf Exp2M1(TSelf x);
+        static abstract TSelf ExpM1(TSelf x);
     }
     public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPoint<TSelf> {
-        long GetExponentShortestBitLength();
+        int GetExponentShortestBitLength();
-        long GetSignificandBitLength();
+        int GetSignificandBitLength();
+        bool TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        int WriteExponentBigEndian(byte[] destination);
+        int WriteExponentBigEndian(byte[] destination, int startIndex);
+        int WriteExponentBigEndian(Span<byte> destination);
+        int WriteSignificandBigEndian(byte[] destination);
+        int WriteSignificandBigEndian(byte[] destination, int startIndex);
+        int WriteSignificandBigEndian(Span<byte> destination);
     }
     public interface IFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPointIeee754<TSelf> {
-        static abstract bool IsFinite(TSelf value);
-        static abstract bool IsInfinity(TSelf value);
-        static abstract bool IsNaN(TSelf value);
-        static abstract bool IsNegativeInfinity(TSelf value);
-        static abstract bool IsNormal(TSelf value);
-        static abstract bool IsPositiveInfinity(TSelf value);
-        static abstract bool IsSubnormal(TSelf value);
     }
     public interface ILogarithmicFunctions<TSelf> where TSelf : ILogarithmicFunctions<TSelf> {
+        static abstract TSelf Log10P1(TSelf x);
+        static abstract TSelf Log2P1(TSelf x);
+        static abstract TSelf LogP1(TSelf x);
     }
     public interface INumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumber<TSelf> {
-        static abstract TSelf Abs(TSelf value);
-        static abstract TSelf CreateChecked<TOther>(TOther value);
-        static abstract TSelf CreateSaturating<TOther>(TOther value);
-        static abstract TSelf CreateTruncating<TOther>(TOther value);
-        static abstract bool IsNegative(TSelf value);
-        static abstract TSelf MaxMagnitude(TSelf x, TSelf y);
+        static abstract TSelf MaxNumber(TSelf x, TSelf y);
-        static abstract TSelf MinMagnitude(TSelf x, TSelf y);
+        static abstract TSelf MinNumber(TSelf x, TSelf y);
-        static abstract TSelf Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider);
-        static abstract TSelf Parse(string s, NumberStyles style, IFormatProvider? provider);
-        static abstract bool TryCreate<TOther>(TOther value, out TSelf result);
-        static abstract bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out TSelf result);
-        static abstract bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out TSelf result);
     }
-    public interface INumberBase<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, ISpanFormattable, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumberBase<TSelf> {
+    public interface INumberBase<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumberBase<TSelf> {
+        static abstract int Radix { get; }
+        static abstract TSelf Abs(TSelf value);
+        static TSelf CreateChecked<TOther>(TOther value);
+        static TSelf CreateSaturating<TOther>(TOther value);
+        static TSelf CreateTruncating<TOther>(TOther value);
+        static abstract bool IsCanonical(TSelf value);
+        static abstract bool IsComplexNumber(TSelf value);
+        static abstract bool IsEvenInteger(TSelf value);
+        static abstract bool IsFinite(TSelf value);
+        static abstract bool IsImaginaryNumber(TSelf value);
+        static abstract bool IsInfinity(TSelf value);
+        static abstract bool IsInteger(TSelf value);
+        static abstract bool IsNaN(TSelf value);
+        static abstract bool IsNegative(TSelf value);
+        static abstract bool IsNegativeInfinity(TSelf value);
+        static abstract bool IsNormal(TSelf value);
+        static abstract bool IsOddInteger(TSelf value);
+        static abstract bool IsPositive(TSelf value);
+        static abstract bool IsPositiveInfinity(TSelf value);
+        static abstract bool IsRealNumber(TSelf value);
+        static abstract bool IsSubnormal(TSelf value);
+        static abstract bool IsZero(TSelf value);
+        static abstract TSelf MaxMagnitude(TSelf x, TSelf y);
+        static abstract TSelf MaxMagnitudeNumber(TSelf x, TSelf y);
+        static abstract TSelf MinMagnitude(TSelf x, TSelf y);
+        static abstract TSelf MinMagnitudeNumber(TSelf x, TSelf y);
+        static abstract TSelf Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider);
+        static abstract TSelf Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static abstract bool TryConvertFromChecked<TOther>(TOther value, out TSelf? result);
+        static abstract bool TryConvertFromSaturating<TOther>(TOther value, out TSelf? result);
+        static abstract bool TryConvertFromTruncating<TOther>(TOther value, out TSelf? result);
+        static abstract bool TryConvertToChecked<TOther>(TSelf value, out TOther? result);
+        static abstract bool TryConvertToSaturating<TOther>(TSelf value, out TOther? result);
+        static abstract bool TryConvertToTruncating<TOther>(TSelf value, out TOther? result);
+        static abstract bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out TSelf result);
+        static abstract bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out TSelf result);
     }
 }
```

