# System.Text.Json

``` diff
 namespace System.Text.Json {
     public static class JsonSerializer {
         public static object? Deserialize(Stream utf8Json, Type returnType, JsonSerializerOptions? options = null);
         public static object? Deserialize(ReadOnlySpan<byte> utf8Json, Type returnType, JsonSerializerOptions? options = null);
         public static object? Deserialize(ReadOnlySpan<char> json, Type returnType, JsonSerializerOptions? options = null);
         public static object? Deserialize(string json, Type returnType, JsonSerializerOptions? options = null);
         public static object? Deserialize(this JsonDocument document, Type returnType, JsonSerializerOptions? options = null);
         public static object? Deserialize(this JsonElement element, Type returnType, JsonSerializerOptions? options = null);
         public static object? Deserialize(this JsonNode? node, Type returnType, JsonSerializerOptions? options = null);
         public static object? Deserialize(ref Utf8JsonReader reader, Type returnType, JsonSerializerOptions? options = null);
         public static TValue? Deserialize<TValue>(Stream utf8Json, JsonSerializerOptions? options = null);
         public static TValue? Deserialize<TValue>(ReadOnlySpan<byte> utf8Json, JsonSerializerOptions? options = null);
         public static TValue? Deserialize<TValue>(ReadOnlySpan<char> json, JsonSerializerOptions? options = null);
         public static TValue? Deserialize<TValue>(string json, JsonSerializerOptions? options = null);
         public static TValue? Deserialize<TValue>(this JsonDocument document, JsonSerializerOptions? options = null);
         public static TValue? Deserialize<TValue>(this JsonElement element, JsonSerializerOptions? options = null);
         public static TValue? Deserialize<TValue>(this JsonNode? node, JsonSerializerOptions? options = null);
         public static TValue? Deserialize<TValue>(ref Utf8JsonReader reader, JsonSerializerOptions? options = null);
         public static ValueTask<object?> DeserializeAsync(Stream utf8Json, Type returnType, JsonSerializerOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
         public static ValueTask<TValue?> DeserializeAsync<TValue>(Stream utf8Json, JsonSerializerOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
         public static IAsyncEnumerable<TValue?> DeserializeAsyncEnumerable<TValue>(Stream utf8Json, JsonSerializerOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static IAsyncEnumerable<TValue?> DeserializeAsyncEnumerable<TValue>(Stream utf8Json, JsonTypeInfo<TValue> jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
         public static void Serialize(Stream utf8Json, object? value, Type inputType, JsonSerializerOptions? options = null);
         public static string Serialize(object? value, Type inputType, JsonSerializerOptions? options = null);
         public static void Serialize(Utf8JsonWriter writer, object? value, Type inputType, JsonSerializerOptions? options = null);
         public static void Serialize<TValue>(Stream utf8Json, TValue value, JsonSerializerOptions? options = null);
         public static void Serialize<TValue>(Utf8JsonWriter writer, TValue value, JsonSerializerOptions? options = null);
         public static string Serialize<TValue>(TValue value, JsonSerializerOptions? options = null);
         public static Task SerializeAsync(Stream utf8Json, object? value, Type inputType, JsonSerializerOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
         public static Task SerializeAsync<TValue>(Stream utf8Json, TValue value, JsonSerializerOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
         public static JsonDocument SerializeToDocument(object? value, Type inputType, JsonSerializerOptions? options = null);
         public static JsonDocument SerializeToDocument<TValue>(TValue value, JsonSerializerOptions? options = null);
         public static JsonElement SerializeToElement(object? value, Type inputType, JsonSerializerOptions? options = null);
         public static JsonElement SerializeToElement<TValue>(TValue value, JsonSerializerOptions? options = null);
         public static JsonNode? SerializeToNode(object? value, Type inputType, JsonSerializerOptions? options = null);
         public static JsonNode? SerializeToNode<TValue>(TValue value, JsonSerializerOptions? options = null);
         public static byte[] SerializeToUtf8Bytes(object? value, Type inputType, JsonSerializerOptions? options = null);
         public static byte[] SerializeToUtf8Bytes<TValue>(TValue value, JsonSerializerOptions? options = null);
     }
     public sealed class JsonSerializerOptions {
         public JsonConverter GetConverter(Type typeToConvert);
     }
     public ref struct Utf8JsonReader {
+        public bool ValueIsEscaped { get; }
+        public int CopyString(Span<byte> utf8Destination);
+        public int CopyString(Span<char> destination);
     }
 }
```

