# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
     public static class ControllerEndpointRouteBuilderExtensions {
-        public static ControllerActionEndpointConventionBuilder MapAreaControllerRoute(this IEndpointRouteBuilder endpoints, string name, string areaName, string pattern, object? defaults = null, object? constraints = null, object? dataTokens = null);
+        public static ControllerActionEndpointConventionBuilder MapAreaControllerRoute(this IEndpointRouteBuilder endpoints, string name, string areaName, [StringSyntaxAttribute("Route")] string pattern, object? defaults = null, object? constraints = null, object? dataTokens = null);
-        public static ControllerActionEndpointConventionBuilder MapControllerRoute(this IEndpointRouteBuilder endpoints, string name, string pattern, object? defaults = null, object? constraints = null, object? dataTokens = null);
+        public static ControllerActionEndpointConventionBuilder MapControllerRoute(this IEndpointRouteBuilder endpoints, string name, [StringSyntaxAttribute("Route")] string pattern, object? defaults = null, object? constraints = null, object? dataTokens = null);
-        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern) where TTransformer : DynamicRouteValueTransformer;
-        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern, object? state) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, object? state) where TTransformer : DynamicRouteValueTransformer;
-        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern, object state, int order) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, object state, int order) where TTransformer : DynamicRouteValueTransformer;
-        public static IEndpointConventionBuilder MapFallbackToAreaController(this IEndpointRouteBuilder endpoints, string pattern, string action, string controller, string area);
+        public static IEndpointConventionBuilder MapFallbackToAreaController(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string action, string controller, string area);
-        public static IEndpointConventionBuilder MapFallbackToController(this IEndpointRouteBuilder endpoints, string pattern, string action, string controller);
+        public static IEndpointConventionBuilder MapFallbackToController(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string action, string controller);
     }
     public abstract class EndpointBuilder {
+        public IServiceProvider ApplicationServices { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
-        public string DisplayName { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public string? DisplayName { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
-        public RequestDelegate RequestDelegate { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public RequestDelegate? RequestDelegate { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
-        public IServiceProvider ServiceProvider { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
     }
     public static class EndpointRouteBuilderExtensions {
-        public static IEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, RequestDelegate requestDelegate);
-        public static IEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder Map(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static IEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapDelete(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder MapFallback(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapFallback(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static IEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapGet(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static GroupRouteBuilder MapGroup(this IEndpointRouteBuilder endpoints, RoutePattern prefix);
+        public static RouteGroupBuilder MapGroup(this IEndpointRouteBuilder endpoints, RoutePattern prefix);
-        public static GroupRouteBuilder MapGroup(this IEndpointRouteBuilder endpoints, string prefix);
+        public static RouteGroupBuilder MapGroup(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string prefix);
-        public static IEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, IEnumerable<string> httpMethods, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapMethods(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, IEnumerable<string> httpMethods, Delegate handler);
-        public static IEndpointConventionBuilder MapPatch(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapPatch(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder MapPatch(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapPatch(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static IEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapPost(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static IEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapPut(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
     }
     public static class FallbackEndpointRouteBuilderExtensions {
-        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
-        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
     }
     public static class MapRouteRouteBuilderExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
-        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string? name, string? template);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
+        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string? name, [StringSyntaxAttribute("Route")] string? template);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
-        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, string template, object defaults);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
+        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, [StringSyntaxAttribute("Route")] string template, object defaults);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
-        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, string template, object defaults, object constraints);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
+        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, [StringSyntaxAttribute("Route")] string template, object defaults, object constraints);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
-        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, string template, object defaults, object constraints, object dataTokens);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
+        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, [StringSyntaxAttribute("Route")] string template, object defaults, object constraints, object dataTokens);
     }
     public static class MvcAreaRouteBuilderExtensions {
-        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, string? template);
+        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, [StringSyntaxAttribute("Route")] string? template);
-        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, string? template, object? defaults);
+        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, [StringSyntaxAttribute("Route")] string? template, object? defaults);
-        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, string? template, object? defaults, object? constraints);
+        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, [StringSyntaxAttribute("Route")] string? template, object? defaults, object? constraints);
-        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, string? template, object? defaults, object? constraints, object? dataTokens);
+        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, [StringSyntaxAttribute("Route")] string? template, object? defaults, object? constraints, object? dataTokens);
     }
+    public static class OutputCacheApplicationBuilderExtensions {
+        public static IApplicationBuilder UseOutputCache(this IApplicationBuilder app);
+    }
+    public static class RequestDecompressionBuilderExtensions {
+        public static IApplicationBuilder UseRequestDecompression(this IApplicationBuilder builder);
+    }
     public static class StaticFilesEndpointRouteBuilderExtensions {
-        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string filePath);
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="MapFallbackToFile RequireUnreferencedCode if the RequestDelegate has a Task<T> return type which is not the case here.")]
+        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string filePath);
-        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string filePath, StaticFileOptions options);
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="MapFallbackToFile RequireUnreferencedCode if the RequestDelegate has a Task<T> return type which is not the case here.")]
+        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string filePath, StaticFileOptions options);
-        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string pattern, string filePath);
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="MapFallbackToFile RequireUnreferencedCode if the RequestDelegate has a Task<T> return type which is not the case here.")]
+        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string filePath);
-        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string pattern, string filePath, StaticFileOptions options);
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="MapFallbackToFile RequireUnreferencedCode if the RequestDelegate has a Task<T> return type which is not the case.")]
+        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string filePath, StaticFileOptions options);
     }
 }
```

