# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public class DynamicComponent : IComponent {
-        public Task SetParametersAsync(ParameterView parameters);
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2072", Justification="We expect that types used with DynamicComponent will be defined in assemblies that don't get trimmed.")]
+        public Task SetParametersAsync(ParameterView parameters);
     }
     public static class EventCallbackFactoryBinderExtensions {
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<bool> setter, bool existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateOnly> setter, DateOnly existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateOnly> setter, DateOnly existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateTime> setter, DateTime existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateTime> setter, DateTime existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateTimeOffset> setter, DateTimeOffset existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateTimeOffset> setter, DateTimeOffset existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<decimal> setter, decimal existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<double> setter, double existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<short> setter, short existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<int> setter, int existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<long> setter, long existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<bool?> setter, bool? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateOnly?> setter, DateOnly? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateOnly?> setter, DateOnly? existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateTime?> setter, DateTime? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateTime?> setter, DateTime? existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateTimeOffset?> setter, DateTimeOffset? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<DateTimeOffset?> setter, DateTimeOffset? existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<decimal?> setter, decimal? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<double?> setter, double? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<short?> setter, short? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<int?> setter, int? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<long?> setter, long? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<float?> setter, float? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<TimeOnly?> setter, TimeOnly? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<TimeOnly?> setter, TimeOnly? existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<float> setter, float existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<string?> setter, string existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<TimeOnly> setter, TimeOnly existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, EventCallback<TimeOnly> setter, TimeOnly existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder<T>(this EventCallbackFactory factory, object receiver, EventCallback<T> setter, T existingValue, CultureInfo? culture = null);
     }
     [AttributeUsageAttribute(4, AllowMultiple=false, Inherited=true)]
     public sealed class LayoutAttribute : Attribute {
-        public LayoutAttribute(Type layoutType);
+        public LayoutAttribute([DynamicallyAccessedMembersAttribute(-1)] Type layoutType);
     }
     public class RouteView : IComponent {
-        protected virtual void Render(RenderTreeBuilder builder);
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2111", Justification="Layout components are preserved because the LayoutAttribute constructor parameter is correctly annotated.")]
+        protected virtual void Render(RenderTreeBuilder builder);
     }
 }
```

