# Microsoft.AspNetCore.OutputCaching

``` diff
+namespace Microsoft.AspNetCore.OutputCaching {
+    public sealed class CacheVaryByRules {
+        public CacheVaryByRules();
+        public StringValues Headers { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public StringValues QueryKeys { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public IDictionary<string, string> VaryByCustom { get; }
+        public StringValues VaryByPrefix { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+    }
+    public interface IOutputCacheFeature {
+        OutputCacheContext Context { get; }
+    }
+    public interface IOutputCachePolicy {
+        ValueTask CacheRequestAsync(OutputCacheContext context, CancellationToken cancellation);
+        ValueTask ServeFromCacheAsync(OutputCacheContext context, CancellationToken cancellation);
+        ValueTask ServeResponseAsync(OutputCacheContext context, CancellationToken cancellation);
+    }
+    public interface IOutputCacheStore {
+        ValueTask EvictByTagAsync(string tag, CancellationToken cancellationToken);
+        ValueTask<byte[]?> GetAsync(string key, CancellationToken cancellationToken);
+        ValueTask SetAsync(string key, byte[] value, string[]? tags, TimeSpan validFor, CancellationToken cancellationToken);
+    }
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public sealed class OutputCacheAttribute : Attribute {
+        public OutputCacheAttribute();
+        public int Duration { get; set; }
+        public bool NoStore { get; set; }
+        public string PolicyName { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public string[]? VaryByHeaders { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public string[]? VaryByQueryKeys { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+    }
+    public sealed class OutputCacheContext {
+        public bool AllowCacheLookup { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public bool AllowCacheStorage { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public bool AllowLocking { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public CacheVaryByRules CacheVaryByRules { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public bool EnableOutputCaching { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public HttpContext HttpContext { [CompilerGeneratedAttribute] get; }
+        public TimeSpan? ResponseExpirationTimeSpan { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public DateTimeOffset? ResponseTime { [CompilerGeneratedAttribute] get; }
+        public HashSet<string> Tags { [CompilerGeneratedAttribute] get; }
+    }
+    public class OutputCacheOptions {
+        public OutputCacheOptions();
+        public IServiceProvider ApplicationServices { [CompilerGeneratedAttribute] get; }
+        public TimeSpan DefaultExpirationTimeSpan { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public long MaximumBodySize { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public long SizeLimit { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public bool UseCaseSensitivePaths { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public void AddBasePolicy(IOutputCachePolicy policy);
+        public void AddBasePolicy(Action<OutputCachePolicyBuilder> build);
+        public void AddPolicy(string name, IOutputCachePolicy policy);
+        public void AddPolicy(string name, Action<OutputCachePolicyBuilder> build);
+    }
+    public sealed class OutputCachePolicyBuilder {
+        public OutputCachePolicyBuilder();
+        public OutputCachePolicyBuilder AddPolicy([DynamicallyAccessedMembersAttribute(3)] Type policyType);
+        public OutputCachePolicyBuilder AddPolicy<T>() where T : IOutputCachePolicy;
+        public OutputCachePolicyBuilder AllowLocking(bool lockResponse = true);
+        public OutputCachePolicyBuilder Clear();
+        public OutputCachePolicyBuilder Expire(TimeSpan expiration);
+        public OutputCachePolicyBuilder NoCache();
+        public OutputCachePolicyBuilder Tag(params string[] tags);
+        public OutputCachePolicyBuilder VaryByHeader(params string[] headers);
+        public OutputCachePolicyBuilder VaryByQuery(params string[] queryKeys);
+        public OutputCachePolicyBuilder VaryByValue(Func<HttpContext, KeyValuePair<string, string>> varyBy);
+        public OutputCachePolicyBuilder VaryByValue(Func<HttpContext, string> varyBy);
+        public OutputCachePolicyBuilder VaryByValue(Func<HttpContext, CancellationToken, ValueTask<KeyValuePair<string, string>>> varyBy);
+        public OutputCachePolicyBuilder VaryByValue(Func<HttpContext, CancellationToken, ValueTask<string>> varyBy);
+        public OutputCachePolicyBuilder With(Func<OutputCacheContext, bool> predicate);
+        public OutputCachePolicyBuilder With(Func<OutputCacheContext, CancellationToken, Task<bool>> predicate);
+    }
+}
```

