# Microsoft.AspNetCore.Routing.Patterns

``` diff
 namespace Microsoft.AspNetCore.Routing.Patterns {
     public sealed class RoutePatternException : Exception {
-        public RoutePatternException(string pattern, string message);
+        public RoutePatternException([StringSyntaxAttribute("Route")] string pattern, string message);
     }
     public static class RoutePatternFactory {
-        public static RoutePattern Parse(string pattern);
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern);
-        public static RoutePattern Parse(string pattern, RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies);
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern, RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies);
-        public static RoutePattern Parse(string pattern, RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies, RouteValueDictionary? requiredValues);
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern, RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies, RouteValueDictionary? requiredValues);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static RoutePattern Parse(string pattern, object? defaults, object? parameterPolicies);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern, object? defaults, object? parameterPolicies);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static RoutePattern Parse(string pattern, object? defaults, object? parameterPolicies, object? requiredValues);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern, object? defaults, object? parameterPolicies, object? requiredValues);
     }
 }
```

