# System.Data.Common

``` diff
 namespace System.Data.Common {
+    public abstract class DbDataSource : IAsyncDisposable, IDisposable {
+        protected DbDataSource();
+        public abstract string ConnectionString { get; }
+        public DbBatch CreateBatch();
+        public DbCommand CreateCommand(string? commandText = null);
+        public DbConnection CreateConnection();
+        protected virtual DbBatch CreateDbBatch();
+        protected virtual DbCommand CreateDbCommand(string? commandText = null);
+        protected abstract DbConnection CreateDbConnection();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public ValueTask DisposeAsync();
+        protected virtual ValueTask DisposeAsyncCore();
+        public DbConnection OpenConnection();
+        public ValueTask<DbConnection> OpenConnectionAsync(CancellationToken cancellationToken = default(CancellationToken));
+        protected virtual DbConnection OpenDbConnection();
+        protected virtual ValueTask<DbConnection> OpenDbConnectionAsync(CancellationToken cancellationToken = default(CancellationToken));
+    }
     public abstract class DbProviderFactory {
+        public virtual DbDataSource CreateDataSource(string connectionString);
     }
 }
```

