# System.Formats.Tar

``` diff
 namespace System.Formats.Tar {
     public sealed class GnuTarEntry : PosixTarEntry {
+        public GnuTarEntry(TarEntry other);
     }
+    public sealed class PaxGlobalExtendedAttributesTarEntry : PosixTarEntry {
+        public PaxGlobalExtendedAttributesTarEntry(IEnumerable<KeyValuePair<string, string>> globalExtendedAttributes);
+        public IReadOnlyDictionary<string, string> GlobalExtendedAttributes { get; }
+    }
     public sealed class PaxTarEntry : PosixTarEntry {
+        public PaxTarEntry(TarEntry other);
     }
     public abstract class TarEntry {
+        public TarEntryFormat Format { get; }
     }
+    public enum TarEntryFormat {
+        Gnu = 4,
+        Pax = 3,
+        Unknown = 0,
+        Ustar = 2,
+        V7 = 1,
+    }
-    public enum TarFormat {
-        Gnu = 4,
-        Pax = 3,
-        Unknown = 0,
-        Ustar = 2,
-        V7 = 1,
-    }
     public sealed class TarReader : IDisposable {
-        public TarFormat Format { get; }
-        public IReadOnlyDictionary<string, string>? GlobalExtendedAttributes { get; }
     }
     public sealed class TarWriter : IDisposable {
+        public TarWriter(Stream archiveStream);
+        public TarWriter(Stream archiveStream, bool leaveOpen = false);
-        public TarWriter(Stream archiveStream, IEnumerable<KeyValuePair<string, string>>? globalExtendedAttributes = null, bool leaveOpen = false);
+        public TarWriter(Stream archiveStream, TarEntryFormat format = TarEntryFormat.Pax, bool leaveOpen = false);
-        public TarWriter(Stream archiveStream, TarFormat archiveFormat, bool leaveOpen = false);
-        public TarFormat Format { get; }
+        public TarEntryFormat Format { get; }
     }
     public sealed class UstarTarEntry : PosixTarEntry {
+        public UstarTarEntry(TarEntry other);
     }
     public sealed class V7TarEntry : TarEntry {
+        public V7TarEntry(TarEntry other);
     }
 }
```

