# System.Net.Security

``` diff
 namespace System.Net.Security {
+    public sealed class NegotiateAuthentication : IDisposable {
+        public NegotiateAuthentication(NegotiateAuthenticationClientOptions clientOptions);
+        public NegotiateAuthentication(NegotiateAuthenticationServerOptions serverOptions);
+        public bool IsAuthenticated { get; }
+        public bool IsEncrypted { get; }
+        public bool IsMutuallyAuthenticated { get; }
+        public bool IsServer { get; }
+        public bool IsSigned { get; }
+        public string Package { get; }
+        public ProtectionLevel ProtectionLevel { get; }
+        public IIdentity RemoteIdentity { get; }
+        public string? TargetName { get; }
+        public void Dispose();
+        public byte[]? GetOutgoingBlob(ReadOnlySpan<byte> incomingBlob, out NegotiateAuthenticationStatusCode statusCode);
+        public string? GetOutgoingBlob(string? incomingBlob, out NegotiateAuthenticationStatusCode statusCode);
+    }
+    public class NegotiateAuthenticationClientOptions {
+        public NegotiateAuthenticationClientOptions();
+        public ChannelBinding? Binding { get; set; }
+        public NetworkCredential Credential { get; set; }
+        public string Package { get; set; }
+        public ProtectionLevel RequiredProtectionLevel { get; set; }
+        public string? TargetName { get; set; }
+    }
+    public class NegotiateAuthenticationServerOptions {
+        public NegotiateAuthenticationServerOptions();
+        public ChannelBinding? Binding { get; set; }
+        public NetworkCredential Credential { get; set; }
+        public string Package { get; set; }
+        public ProtectionLevel RequiredProtectionLevel { get; set; }
+    }
+    public enum NegotiateAuthenticationStatusCode {
+        BadBinding = 3,
+        Completed = 0,
+        ContextExpired = 6,
+        ContinueNeeded = 1,
+        CredentialsExpired = 7,
+        GenericFailure = 2,
+        InvalidCredentials = 8,
+        InvalidToken = 9,
+        MessageAltered = 5,
+        OutOfSequence = 12,
+        QopNotSupported = 11,
+        UnknownCredentials = 10,
+        Unsupported = 4,
+    }
 }
```

