# System.Net.Quic

``` diff
+namespace System.Net.Quic {
+    [FlagsAttribute]
+    public enum QuicAbortDirection {
+        Both = 3,
+        Read = 1,
+        Write = 2,
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class QuicClientConnectionOptions : QuicConnectionOptions {
+        public QuicClientConnectionOptions();
+        public SslClientAuthenticationOptions ClientAuthenticationOptions { get; set; }
+        [NullableAttribute((byte)2)]
+        public IPEndPoint? LocalEndPoint { [NullableContextAttribute((byte)2)] get; [NullableContextAttribute((byte)2)] set; }
+        public EndPoint RemoteEndPoint { get; set; }
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class QuicConnection : IAsyncDisposable {
+        public static bool IsSupported { get; }
+        public IPEndPoint LocalEndPoint { get; }
+        public SslApplicationProtocol NegotiatedApplicationProtocol { get; }
+        [NullableAttribute((byte)2)]
+        public X509Certificate? RemoteCertificate { [NullableContextAttribute((byte)2)] get; }
+        public IPEndPoint RemoteEndPoint { get; }
+        [return: NullableAttribute(new byte[]{ (byte)0, (byte)1})]
+        public ValueTask<QuicStream> AcceptInboundStreamAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask CloseAsync(long errorCode, CancellationToken cancellationToken = default(CancellationToken));
+        [return: NullableAttribute(new byte[]{ (byte)0, (byte)1})]
+        public static ValueTask<QuicConnection> ConnectAsync(QuicClientConnectionOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask DisposeAsync();
+        [return: NullableAttribute(new byte[]{ (byte)0, (byte)1})]
+        public ValueTask<QuicStream> OpenOutboundStreamAsync(QuicStreamType type, CancellationToken cancellationToken = default(CancellationToken));
+        public override string ToString();
+    }
+    public abstract class QuicConnectionOptions {
+        public long DefaultCloseErrorCode { get; set; }
+        public long DefaultStreamErrorCode { get; set; }
+        public TimeSpan IdleTimeout { get; set; }
+        public int MaxInboundBidirectionalStreams { get; set; }
+        public int MaxInboundUnidirectionalStreams { get; set; }
+    }
+    public enum QuicError {
+        AddressInUse = 4,
+        ConnectionAborted = 2,
+        ConnectionIdle = 10,
+        ConnectionRefused = 8,
+        ConnectionTimeout = 6,
+        HostUnreachable = 7,
+        InternalError = 1,
+        InvalidAddress = 5,
+        OperationAborted = 12,
+        ProtocolError = 11,
+        StreamAborted = 3,
+        Success = 0,
+        VersionNegotiationError = 9,
+    }
+    public sealed class QuicException : IOException {
+        [NullableContextAttribute((byte)1)]
+        public QuicException(QuicError error, long? applicationErrorCode, string message);
+        public long? ApplicationErrorCode { get; }
+        public QuicError QuicError { get; }
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class QuicListener : IAsyncDisposable {
+        public static bool IsSupported { get; }
+        public IPEndPoint LocalEndPoint { get; }
+        [return: NullableAttribute(new byte[]{ (byte)0, (byte)1})]
+        public ValueTask<QuicConnection> AcceptConnectionAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask DisposeAsync();
+        [return: NullableAttribute(new byte[]{ (byte)0, (byte)1})]
+        public static ValueTask<QuicListener> ListenAsync(QuicListenerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public override string ToString();
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class QuicListenerOptions {
+        public QuicListenerOptions();
+        public List<SslApplicationProtocol> ApplicationProtocols { get; set; }
+        [NullableAttribute(new byte[]{ (byte)1, (byte)1, (byte)0, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)1, (byte)1, (byte)0, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)1, (byte)1, (byte)0, (byte)1})]
+        public Func<QuicConnection, SslClientHelloInfo, CancellationToken, ValueTask<QuicServerConnectionOptions>> ConnectionOptionsCallback { get; set; }
+        public int ListenBacklog { get; set; }
+        public IPEndPoint ListenEndPoint { get; set; }
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class QuicServerConnectionOptions : QuicConnectionOptions {
+        public QuicServerConnectionOptions();
+        public SslServerAuthenticationOptions ServerAuthenticationOptions { get; set; }
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class QuicStream : Stream {
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanTimeout { get; }
+        public override bool CanWrite { get; }
+        public long Id { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public Task ReadsClosed { get; }
+        public override int ReadTimeout { get; set; }
+        public QuicStreamType Type { get; }
+        public Task WritesClosed { get; }
+        public override int WriteTimeout { get; set; }
+        public void Abort(QuicAbortDirection abortDirection, long errorCode);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, [NullableAttribute((byte)2)] AsyncCallback? callback, [NullableAttribute((byte)2)] object? state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, [NullableAttribute((byte)2)] AsyncCallback? callback, [NullableAttribute((byte)2)] object? state);
+        public void CompleteWrites();
+        protected override void Dispose(bool disposing);
+        public override ValueTask DisposeAsync();
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public override int Read(byte[] buffer, int offset, int count);
+        [NullableContextAttribute((byte)0)]
+        public override int Read(Span<byte> buffer);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken = default(CancellationToken));
+        [NullableContextAttribute((byte)0)]
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+        [NullableContextAttribute((byte)0)]
+        public override void Write(ReadOnlySpan<byte> buffer);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken = default(CancellationToken));
+        [NullableContextAttribute((byte)0)]
+        public ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, bool completeWrites, CancellationToken cancellationToken = default(CancellationToken));
+        [NullableContextAttribute((byte)0)]
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override void WriteByte(byte value);
+    }
+    public enum QuicStreamType {
+        Bidirectional = 1,
+        Unidirectional = 0,
+    }
+}
```

