# System.Net.Security

``` diff
 namespace System.Net.Security {
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public sealed class NegotiateAuthentication : IDisposable {
+        public TokenImpersonationLevel ImpersonationLevel { get; }
+        public NegotiateAuthenticationStatusCode Unwrap(ReadOnlySpan<byte> input, [NullableAttribute((byte)1)] IBufferWriter<byte> outputWriter, out bool wasEncrypted);
+        public NegotiateAuthenticationStatusCode UnwrapInPlace(Span<byte> input, out int unwrappedOffset, out int unwrappedLength, out bool wasEncrypted);
+        public NegotiateAuthenticationStatusCode Wrap(ReadOnlySpan<byte> input, [NullableAttribute((byte)1)] IBufferWriter<byte> outputWriter, bool requestEncryption, out bool isEncrypted);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public class NegotiateAuthenticationClientOptions {
+        public TokenImpersonationLevel AllowedImpersonationLevel { get; set; }
+        public bool RequireMutualAuthentication { get; set; }
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public class NegotiateAuthenticationServerOptions {
+        [NullableAttribute((byte)2)]
+        public ExtendedProtectionPolicy? Policy { [NullableContextAttribute((byte)2)] get; [NullableContextAttribute((byte)2)] set; }
+        public TokenImpersonationLevel RequiredImpersonationLevel { get; set; }
     }
     public enum NegotiateAuthenticationStatusCode {
+        ImpersonationValidationFailed = 15,
+        SecurityQosFailed = 13,
+        TargetUnknown = 14,
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)2)]
     public class SslClientAuthenticationOptions {
+        public X509ChainPolicy CertificateChainPolicy { get; set; }
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)2)]
     public class SslServerAuthenticationOptions {
+        public X509ChainPolicy CertificateChainPolicy { get; set; }
     }
 }
```

