# Microsoft.AspNetCore.Routing

``` diff
 namespace Microsoft.AspNetCore.Routing {
     [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
     public sealed class HttpMethodMetadata : IHttpMethodMetadata {
-        public bool AcceptCorsPreflight { get; }
+        public bool AcceptCorsPreflight { get; set; }
     }
     public interface IHttpMethodMetadata {
-        bool AcceptCorsPreflight { get; }
+        bool AcceptCorsPreflight { get; set; }
     }
     public sealed class RouteEndpointBuilder : EndpointBuilder {
-        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="We surface a RequireUnreferencedCode in AddEndpointFilter which is required to call unreferenced code here. The trimmer is unable to infer this.")]
+        public override Endpoint Build();
     }
     public sealed class RouteGroupBuilder : IEndpointConventionBuilder, IEndpointRouteBuilder {
+        void IEndpointConventionBuilder.Finally(Action<EndpointBuilder> finalConvention);
     }
     public sealed class RouteGroupContext {
+        public RouteGroupContext();
-        public RouteGroupContext(RoutePattern prefix, IReadOnlyList<Action<EndpointBuilder>> conventions, IServiceProvider applicationServices);
-        public IServiceProvider ApplicationServices { get; }
+        public IServiceProvider ApplicationServices { get; set; }
-        public IReadOnlyList<Action<EndpointBuilder>> Conventions { get; }
+        public IReadOnlyList<Action<EndpointBuilder>> Conventions { get; set; }
+        public IReadOnlyList<Action<EndpointBuilder>> FinallyConventions { get; set; }
-        public RoutePattern Prefix { get; }
+        public required RoutePattern Prefix { get; set; }
     }
     public class RouteOptions {
-        public IDictionary<string, Type> ConstraintMap { [RequiresUnreferencedCodeAttribute("The linker cannot determine what constraints are being added via the ConstraintMap property. Prefer RouteOptions.SetParameterPolicy instead for setting constraints. This warning can be suppressed if this property is being used to read of delete constraints.")] get; set; }
+        public IDictionary<string, Type> ConstraintMap { [RequiresUnreferencedCodeAttribute("The linker cannot determine what constraints are being added via the ConstraintMap property. Prefer RouteOptions.SetParameterPolicy instead for setting constraints. This warning can be suppressed if this property is being used to read or delete constraints.")] get; set; }
     }
 }
```

