# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
-    public class DefaultServiceProviderFactory : IServiceProviderFactory<IServiceCollection>
+    [RequiresDynamicCodeAttribute("Using Microsoft.Extensions.DependencyInjection requires generating code dynamically at runtime. For example, when using enumerable and generic ValueType services.")]
+    public class DefaultServiceProviderFactory : IServiceProviderFactory<IServiceCollection>
+    public static class HttpJsonServiceExtensions {
+        public static IServiceCollection ConfigureHttpJsonOptions(this IServiceCollection services, Action<JsonOptions> configureOptions);
+    }
     public static class OptionsBuilderConfigurationExtensions {
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config) where TOptions : class;
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static OptionsBuilder<TOptions> BindConfiguration<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, string configSectionPath, Action<BinderOptions>? configureBinder = null) where TOptions : class;
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static OptionsBuilder<TOptions> BindConfiguration<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, string configSectionPath, Action<BinderOptions>? configureBinder = null) where TOptions : class;
     }
     public static class OptionsConfigurationServiceCollectionExtensions {
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config) where TOptions : class;
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, IConfiguration config) where TOptions : class;
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, IConfiguration config) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
     }
-    public static class RouteHandlerJsonServiceExtensions {
-        public static IServiceCollection ConfigureRouteHandlerJsonOptions(this IServiceCollection services, Action<JsonOptions> configureOptions);
-    }
     public static class ServiceCollectionContainerBuilderExtensions {
-        public static ServiceProvider BuildServiceProvider(this IServiceCollection services);
+        [RequiresDynamicCodeAttribute("Using Microsoft.Extensions.DependencyInjection requires generating code dynamically at runtime. For example, when using enumerable and generic ValueType services.")]
+        public static ServiceProvider BuildServiceProvider(this IServiceCollection services);
-        public static ServiceProvider BuildServiceProvider(this IServiceCollection services, ServiceProviderOptions options);
+        [RequiresDynamicCodeAttribute("Using Microsoft.Extensions.DependencyInjection requires generating code dynamically at runtime. For example, when using enumerable and generic ValueType services.")]
+        public static ServiceProvider BuildServiceProvider(this IServiceCollection services, ServiceProviderOptions options);
-        public static ServiceProvider BuildServiceProvider(this IServiceCollection services, bool validateScopes);
+        [RequiresDynamicCodeAttribute("Using Microsoft.Extensions.DependencyInjection requires generating code dynamically at runtime. For example, when using enumerable and generic ValueType services.")]
+        public static ServiceProvider BuildServiceProvider(this IServiceCollection services, bool validateScopes);
     }
     public static class ServiceProviderServiceExtensions {
-        public static IEnumerable<object?> GetServices(this IServiceProvider provider, Type serviceType);
+        [RequiresDynamicCodeAttribute("The native code for an IEnumerable<serviceType> might not be available at runtime.")]
+        public static IEnumerable<object?> GetServices(this IServiceProvider provider, Type serviceType);
     }
 }
```

