# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public class DiagnosticListener : DiagnosticSource, IDisposable, IObservable<KeyValuePair<string, object?>> {
-        public override void Write(string name, object? value);
+        [RequiresDynamicCodeAttribute("DiagnosticSource may require creating new generic types or methods, which requires creating code at runtime. This may not work when AOT compiling.")]
+        public override void Write(string name, object? value);
     }
     public abstract class DiagnosticSource {
-        public Activity StartActivity(Activity activity, object? args);
+        [RequiresDynamicCodeAttribute("DiagnosticSource may require creating new generic types or methods, which requires creating code at runtime. This may not work when AOT compiling.")]
+        public Activity StartActivity(Activity activity, object? args);
-        public void StopActivity(Activity activity, object? args);
+        [RequiresDynamicCodeAttribute("DiagnosticSource may require creating new generic types or methods, which requires creating code at runtime. This may not work when AOT compiling.")]
+        public void StopActivity(Activity activity, object? args);
-        public abstract void Write(string name, object? value);
+        [RequiresDynamicCodeAttribute("DiagnosticSource may require creating new generic types or methods, which requires creating code at runtime. This may not work when AOT compiling.")]
+        public abstract void Write(string name, object? value);
     }
+    public sealed class InitializingSwitchEventArgs : EventArgs {
+        public InitializingSwitchEventArgs(Switch @switch);
+        public Switch Switch { get; }
+    }
+    public sealed class InitializingTraceSourceEventArgs : EventArgs {
+        public InitializingTraceSourceEventArgs(TraceSource traceSource);
+        public TraceSource TraceSource { get; }
+        public bool WasInitialized { get; set; }
+    }
     public class Process : Component, IDisposable {
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public TimeSpan PrivilegedProcessorTime { get; }
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public TimeSpan PrivilegedProcessorTime { get; }
     }
     public abstract class Switch {
+        public string DefaultValue { get; }
-        protected string Value { get; set; }
+        public string Value { get; set; }
+        public static event EventHandler<InitializingSwitchEventArgs>? Initializing;
+        public void Refresh();
     }
     public sealed class Trace {
+        public static event EventHandler Refreshing;
     }
     public class TraceSource {
+        public SourceLevels DefaultLevel { get; }
+        public static event EventHandler<InitializingTraceSourceEventArgs>? Initializing;
     }
 }
```

