# System.Runtime.Serialization.DataContracts

``` diff
+namespace System.Runtime.Serialization.DataContracts {
+    public abstract class DataContract {
+        public virtual DataContract? BaseContract { get; }
+        public virtual string? ContractType { get; }
+        public virtual ReadOnlyCollection<DataMember> DataMembers { get; }
+        public virtual bool IsBuiltInDataContract { get; }
+        public virtual bool IsISerializable { get; }
+        public virtual bool IsReference { get; }
+        public virtual bool IsValueType { get; }
+        public virtual Dictionary<XmlQualifiedName, DataContract>? KnownDataContracts { get; }
+        public virtual Type OriginalUnderlyingType { get; }
+        public virtual XmlDictionaryString? TopLevelElementName { get; }
+        public virtual XmlDictionaryString? TopLevelElementNamespace { get; }
+        public virtual Type UnderlyingType { get; }
+        public virtual XmlQualifiedName XmlName { get; }
+        public virtual XmlQualifiedName GetArrayTypeName(bool isNullable);
+        public static DataContract? GetBuiltInDataContract(string name, string ns);
+        public static XmlQualifiedName GetXmlName(Type type);
+        public virtual bool IsDictionaryLike([NotNullWhenAttribute(true)] out string? keyName, [NotNullWhenAttribute(true)] out string? valueName, [NotNullWhenAttribute(true)] out string? itemName);
+    }
+    public sealed class DataContractSet {
+        public DataContractSet(DataContractSet dataContractSet);
+        public DataContractSet(ISerializationSurrogateProvider? dataContractSurrogate, IEnumerable<Type>? referencedTypes, IEnumerable<Type>? referencedCollectionTypes);
+        public Dictionary<XmlQualifiedName, DataContract> Contracts { get; }
+        public Dictionary<XmlQualifiedName, DataContract>? KnownTypesForObject { get; }
+        public Dictionary<DataContract, object> ProcessedContracts { get; }
+        public Hashtable SurrogateData { get; }
+        public DataContract GetDataContract(Type type);
+        public DataContract? GetDataContract(XmlQualifiedName key);
+        public Type? GetReferencedType(XmlQualifiedName xmlName, DataContract dataContract, out DataContract? referencedContract, out object[]? genericParameters, bool? supportGenericTypes = default(bool?));
+        public List<XmlQualifiedName> ImportSchemaSet(XmlSchemaSet schemaSet, IEnumerable<XmlSchemaElement> elements, bool importXmlDataType);
+        public void ImportSchemaSet(XmlSchemaSet schemaSet, IEnumerable<XmlQualifiedName>? typeNames, bool importXmlDataType);
+    }
+    public sealed class DataMember {
+        public bool EmitDefaultValue { get; }
+        public bool IsNullable { get; }
+        public bool IsRequired { get; }
+        public DataContract MemberTypeContract { get; }
+        public string Name { get; }
+        public long Order { get; }
+    }
+    public sealed class XmlDataContract : DataContract {
+        public bool HasRoot { get; }
+        public bool IsAnonymous { get; }
+        public bool IsTopLevelElementNullable { get; }
+        public bool IsTypeDefinedOnImport { get; set; }
+        public new bool IsValueType { get; set; }
+        public XmlSchemaType? XsdType { get; }
+    }
+}
```

