# .NET Core SDK 1.0.3 with .NET Core 1.0.4 & 1.1.1 

The installers and binary archives on this page include .NET Core SDK 1.0.3, .NET Core 1.0.4 and .NET Core 1.1.1. Runtime-only installers and binaries can be found on the .NET Core [1.0.4](1.0.4-download.md) and [1.1.1](1.1.1-download.md) installer pages.

|                         | SDK Installer                                                                                                        | SDK Binaries                                             |
| ----------------------- | :----------------------------------------------:                                                                     | :----------------------------------------------:         |
| Windows                 | [32-bit](https://go.microsoft.com/fwlink/?LinkID=847102) / [64-bit](https://go.microsoft.com/fwlink/?LinkID=847097)  | [32-bit](https://go.microsoft.com/fwlink/?LinkID=847092) / [64-bit](https://go.microsoft.com/fwlink/?LinkID=847091)
| macOS                   | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847009)                                                             | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847094) |
| CentOS 7.1              | -                                                                                                                    | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847103) |
| Debian 8                | -                                                                                                                    | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847105) |
| Fedora 24               | -                                                                                                                    | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847100) |
| OpenSUSE 42.1           | -                                                                                                                    | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847096) |
| Ubuntu 14.04            |[64-bit](https://go.microsoft.com/fwlink/?LinkID=847095)                                                              | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847106) |
| Ubuntu 16.04            |[64-bit](https://go.microsoft.com/fwlink/?LinkID=847093)                                                              | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847089) |
| Ubuntu 16.10            |[64-bit](https://go.microsoft.com/fwlink/?LinkID=847101)                                                              | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847090) |
| RHEL 7                  | -                                                                                                                    | [64-bit](https://go.microsoft.com/fwlink/?LinkID=847098) |

## Installation from a binary archive

When using binary archives to install, we recommend the contents be extracted to `/opt/dotnet` and a symbolic link created for `dotnet`. If an earlier release of .NET Core is already installed, the directory and symbolic link may already exist. Ubuntu and Mint users should follow the instructions in the Ubuntu Installation section below.

```bash
sudo mkdir -p /opt/dotnet
sudo tar zxf [tar.gz filename] -C /opt/dotnet
sudo ln -s /opt/dotnet/dotnet /usr/local/bin
```

## Ubuntu installation

```
dotnet-sdk-ubuntu-x64.1.0.3.deb
```

### Set up package source

The first step is to establish the source feed for the package manager. This is only needed if you have not previously set up the source or if you are installing for the first time.

#### Ubuntu 14.04 and Linux Mint 17

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
sudo apt-get install dotnet-dev-1.0.3

```

Installed packages

```
dotnet-sdk-ubuntu-x64.1.0.3.deb
```

#### Ubuntu 16.04 and Linux Mint 18

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
sudo apt-get install dotnet-dev-1.0.3
```

Installed packages

```
sudo apt-get install dotnet-dev-1.0.3
```

#### Ubuntu 16.10

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ yakkety main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
sudo apt-get install dotnet-dev-1.0.3
```

Installed packages

```
sudo apt-get install dotnet-dev-1.0.3
```

## Windows Server Hosting
If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the [Windows (Server Hosting) installer](https://go.microsoft.com/fwlink/?LinkID=844461) and run the following command from an Administrator command prompt:

``DotNetCore.1.0.4_1.1.1-WindowsHosting.exe OPT_INSTALL_LTS_REDIST=0 OPT_INSTALL_FTS_REDIST=0``
