# .NET Core 2.1 Preview 1 Known Issues

This document lists known issues for *.NET Core 2.1 Preview 1* which may be encountered during usage.

## SDK

Nightly builds of the .NET Core SDK with  version numbers starting with 2.2.0-preview or 15.5.0-preview will prevent Preview 1 from being used.

**Workaround** - Manually uninstall the nightly build. See https://github.com/dotnet/announcements/issues/57

The dotnet install tool fails if a feed can't be reached, even if the package is available in the offline cache. For example, this might happen when the machine is offline.

**Workaround** - Temporarily edit your NuGet.Config and remove unreachable feeds there.

The dotnet pack command fails to pack .NET Core tools that contain project to project references. See https://github.com/dotnet/sdk/issues/1998

**Workaround** - None

## Runtime

Code that was using Lazy<T, Tmetadata> and working in 2.0.0 may produce this error when upgrading to 2.1:

> Error	CS0012	The type 'Lazy<,>' is defined in an assembly that is not referenced. You must add a reference to assembly 'System.ComponentModel.Composition, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089'.

This is because this was previously satisfied by a type forward in the assembly System.ComponentModel.Composition. This assembly has now been populated with a port of MEF and in the process was pulled out of the core netcoreapp package.

Add a package reference to https://www.nuget.org/packages/Microsoft.Windows.Compatibility

https://github.com/dotnet/corefx/issues/27299

## Visual Studio

If you install .NET Core 2.1 Preview 1 on a machine with Visual Studio 2017 version 15.5.6 or lower, then ASP.NET Core 2.0 is not available in dropdown when creating new web applications

Apply VS update 15.5.7 to make ASP.NET Core 2.0 show up in the web project creation dialog again 
