# System.Numerics

``` diff
 namespace System.Numerics {
+    public static class BitOperations {
+        public static int LeadingZeroCount(uint value);
+        public static int LeadingZeroCount(ulong value);
+        public static int Log2(uint value);
+        public static int Log2(ulong value);
+        public static int PopCount(uint value);
+        public static int PopCount(ulong value);
+        public static uint RotateLeft(uint value, int offset);
+        public static ulong RotateLeft(ulong value, int offset);
+        public static uint RotateRight(uint value, int offset);
+        public static ulong RotateRight(ulong value, int offset);
+        public static int TrailingZeroCount(int value);
+        public static int TrailingZeroCount(long value);
+        public static int TrailingZeroCount(uint value);
+        public static int TrailingZeroCount(ulong value);
+    }
     public struct Complex : IEquatable<Complex>, IFormattable {
+        public static readonly Complex Infinity;
+        public static readonly Complex NaN;
+        public static Complex Add(double left, Complex right);
+        public static Complex Add(Complex left, double right);
+        public static Complex Divide(double dividend, Complex divisor);
+        public static Complex Divide(Complex dividend, double divisor);
+        public static bool IsFinite(Complex value);
+        public static bool IsInfinity(Complex value);
+        public static bool IsNaN(Complex value);
+        public static Complex Multiply(double left, Complex right);
+        public static Complex Multiply(Complex left, double right);
+        public static Complex operator +(double left, Complex right);
+        public static Complex operator +(Complex left, double right);
+        public static Complex operator /(double left, Complex right);
+        public static Complex operator /(Complex left, double right);
+        public static Complex operator *(double left, Complex right);
+        public static Complex operator *(Complex left, double right);
+        public static Complex operator -(double left, Complex right);
+        public static Complex operator -(Complex left, double right);
+        public static Complex Subtract(double left, Complex right);
+        public static Complex Subtract(Complex left, double right);
     }
     public struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct {
+        public Vector(ReadOnlySpan<byte> values);
+        public Vector(ReadOnlySpan<T> values);
+        public void CopyTo(Span<byte> destination);
+        public void CopyTo(Span<T> destination);
+        public bool TryCopyTo(Span<byte> destination);
+        public bool TryCopyTo(Span<T> destination);
     }
 }
```

