# Microsoft.AspNetCore.Cors

``` diff
 {
     namespace Microsoft.AspNetCore.Builder {
+        public static class CorsEndpointConventionBuilderExtensions {
+            public static TBuilder RequireCors<TBuilder>(this TBuilder builder, Action<CorsPolicyBuilder> configurePolicy) where TBuilder : IEndpointConventionBuilder;
+            public static TBuilder RequireCors<TBuilder>(this TBuilder builder, string policyName) where TBuilder : IEndpointConventionBuilder;
+        }
     }
     namespace Microsoft.AspNetCore.Cors {
+        public class CorsPolicyMetadata : ICorsMetadata, ICorsPolicyMetadata {
+            public CorsPolicyMetadata(CorsPolicy policy);
+            public CorsPolicy Policy { get; }
+        }
-        public class DisableCorsAttribute : Attribute, IDisableCorsAttribute
+        public class DisableCorsAttribute : Attribute, ICorsMetadata, IDisableCorsAttribute
-        public class EnableCorsAttribute : Attribute, IEnableCorsAttribute
+        public class EnableCorsAttribute : Attribute, ICorsMetadata, IEnableCorsAttribute
     }
     namespace Microsoft.AspNetCore.Cors.Infrastructure {
         public class CorsMiddleware {
-            public CorsMiddleware(RequestDelegate next, ICorsService corsService, CorsPolicy policy);

-            public CorsMiddleware(RequestDelegate next, ICorsService corsService, ICorsPolicyProvider policyProvider);

-            public CorsMiddleware(RequestDelegate next, ICorsService corsService, ICorsPolicyProvider policyProvider, ILoggerFactory loggerFactory);

-            public CorsMiddleware(RequestDelegate next, ICorsService corsService, ICorsPolicyProvider policyProvider, ILoggerFactory loggerFactory, string policyName);

-            public CorsMiddleware(RequestDelegate next, ICorsService corsService, ICorsPolicyProvider policyProvider, string policyName);

+            public CorsMiddleware(RequestDelegate next, ICorsService corsService, ILoggerFactory loggerFactory);
+            public CorsMiddleware(RequestDelegate next, ICorsService corsService, ILoggerFactory loggerFactory, string policyName);
-            public Task Invoke(HttpContext context);

+            public Task Invoke(HttpContext context, ICorsPolicyProvider corsPolicyProvider);
         }
         public class CorsService : ICorsService {
-            public CorsService(IOptions<CorsOptions> options);

         }
+        public interface ICorsPolicyMetadata : ICorsMetadata {
+            CorsPolicy Policy { get; }
+        }
-        public interface IDisableCorsAttribute
+        public interface IDisableCorsAttribute : ICorsMetadata
-        public interface IEnableCorsAttribute
+        public interface IEnableCorsAttribute : ICorsMetadata
     }
 }
```

