# Microsoft.AspNetCore.Razor.Language

``` diff
 {
     namespace Microsoft.AspNetCore.Razor.Language {
         public abstract class BoundAttributeDescriptor : IEquatable<BoundAttributeDescriptor> {
+            public virtual IReadOnlyList<BoundAttributeParameterDescriptor> BoundAttributeParameters { get; protected set; }
+            public bool CaseSensitive { get; protected set; }
         }
         public abstract class BoundAttributeDescriptorBuilder {
+            public virtual IReadOnlyList<BoundAttributeParameterDescriptorBuilder> BoundAttributeParameters { get; }
+            public virtual void BindAttributeParameter(Action<BoundAttributeParameterDescriptorBuilder> configure);
         }
         public static class BoundAttributeDescriptorBuilderExtensions {
+            public static string GetPropertyName(this BoundAttributeParameterDescriptorBuilder builder);
+            public static bool IsDirectiveAttribute(this BoundAttributeDescriptorBuilder builder);
+            public static void SetPropertyName(this BoundAttributeParameterDescriptorBuilder builder, string propertyName);
         }
         public static class BoundAttributeDescriptorExtensions {
+            public static string GetPropertyName(this BoundAttributeParameterDescriptor parameter);
+            public static bool IsDefaultKind(this BoundAttributeParameterDescriptor parameter);
+            public static bool IsDirectiveAttribute(this BoundAttributeDescriptor attribute);
         }
+        public abstract class BoundAttributeParameterDescriptor : IEquatable<BoundAttributeParameterDescriptor> {
+            protected BoundAttributeParameterDescriptor(string kind);
+            public bool CaseSensitive { get; protected set; }
+            public IReadOnlyList<RazorDiagnostic> Diagnostics { get; protected set; }
+            public string DisplayName { get; protected set; }
+            public string Documentation { get; protected set; }
+            public bool HasErrors { get; }
+            public bool IsBooleanProperty { get; protected set; }
+            public bool IsEnum { get; protected set; }
+            public bool IsStringProperty { get; protected set; }
+            public string Kind { get; }
+            public IReadOnlyDictionary<string, string> Metadata { get; protected set; }
+            public string Name { get; protected set; }
+            public string TypeName { get; protected set; }
+            public bool Equals(BoundAttributeParameterDescriptor other);
+            public override bool Equals(object obj);
+            public override int GetHashCode();
+            public override string ToString();
+        }
+        public abstract class BoundAttributeParameterDescriptorBuilder {
+            protected BoundAttributeParameterDescriptorBuilder();
+            public abstract RazorDiagnosticCollection Diagnostics { get; }
+            public abstract string DisplayName { get; set; }
+            public abstract string Documentation { get; set; }
+            public abstract bool IsEnum { get; set; }
+            public abstract IDictionary<string, string> Metadata { get; }
+            public abstract string Name { get; set; }
+            public abstract string TypeName { get; set; }
+        }
         public static class DirectiveDescriptorBuilderExtensions {
+            public static IDirectiveDescriptorBuilder AddAttributeToken(this IDirectiveDescriptorBuilder builder);
+            public static IDirectiveDescriptorBuilder AddAttributeToken(this IDirectiveDescriptorBuilder builder, string name, string description);
+            public static IDirectiveDescriptorBuilder AddOptionalAttributeToken(this IDirectiveDescriptorBuilder builder);
+            public static IDirectiveDescriptorBuilder AddOptionalAttributeToken(this IDirectiveDescriptorBuilder builder, string name, string description);
         }
         public enum DirectiveTokenKind {
+            Attribute = 4,
         }
         public abstract class DocumentClassifierPassBase : IntermediateNodePassBase, IRazorDocumentClassifierPass, IRazorEngineFeature, IRazorFeature {
+            protected IReadOnlyList<ICodeTargetExtension> TargetExtensions { get; private set; }
+            protected virtual CodeTarget CreateTarget(RazorCodeDocument codeDocument, RazorCodeGenerationOptions options);
         }
+        public static class FileKinds {
+            public static readonly string Component;
+            public static readonly string ComponentImport;
+            public static readonly string Legacy;
+            public static string GetComponentFileKindFromFilePath(string filePath);
+            public static string GetFileKindFromFilePath(string filePath);
+            public static bool IsComponent(string fileKind);
+            public static bool IsComponentImport(string fileKind);
+        }
-        public sealed class ItemCollection : ICollection<KeyValuePair<object, object>>, IEnumerable, IEnumerable<KeyValuePair<object, object>> {
+        public sealed class ItemCollection : ICollection, ICollection<KeyValuePair<object, object>>, IEnumerable, IEnumerable<KeyValuePair<object, object>> {
-            int System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.Count { get; }

-            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.IsReadOnly { get; }

+            bool System.Collections.ICollection.IsSynchronized { get; }
+            object System.Collections.ICollection.SyncRoot { get; }
+            void System.Collections.ICollection.CopyTo(Array array, int index);
         }
         public static class RazorCodeDocumentExtensions {
+            public static string GetFileKind(this RazorCodeDocument document);
+            public static void SetFileKind(this RazorCodeDocument document, string fileKind);
+            public static bool TryComputeNamespace(this RazorCodeDocument document, bool fallbackToRootNamespace, out string @namespace);
         }
         public abstract class RazorCodeGenerationOptions {
+            public virtual string RootNamespace { get; }
+            public virtual bool SuppressNullabilityEnforcement { get; }
+            public virtual bool SuppressPrimaryMethodBody { get; protected set; }
         }
         public abstract class RazorCodeGenerationOptionsBuilder {
+            public virtual string FileKind { get; }
+            public virtual string RootNamespace { get; set; }
+            public virtual bool SuppressNullabilityEnforcement { get; set; }
+            public virtual bool SuppressPrimaryMethodBody { get; set; }
         }
         public abstract class RazorCSharpDocument {
-            public static RazorCSharpDocument Create(string generatedCode, RazorCodeGenerationOptions options, IEnumerable<RazorDiagnostic> diagnostics, IEnumerable<SourceMapping> sourceMappings);

+            public static RazorCSharpDocument Create(string generatedCode, RazorCodeGenerationOptions options, IEnumerable<RazorDiagnostic> diagnostics, IEnumerable<SourceMapping> sourceMappings, IEnumerable<LinePragma> linePragmas);
         }
         public sealed class RazorDiagnosticCollection : ICollection<RazorDiagnostic>, IEnumerable, IEnumerable<RazorDiagnostic>, IList<RazorDiagnostic> {
+            public void AddRange(RazorDiagnosticCollection items);
+            public void AddRange(IEnumerable<RazorDiagnostic> items);
         }
         public enum RazorDiagnosticSeverity {
+            Warning = 2,
         }
         public sealed class RazorLanguageVersion : IComparable<RazorLanguageVersion>, IEquatable<RazorLanguageVersion> {
+            public static readonly RazorLanguageVersion Version_3_0;
         }
         public abstract class RazorParserOptions {
+            public static RazorParserOptions Create(Action<RazorParserOptionsBuilder> configure, string fileKind);
+            public static RazorParserOptions CreateDesignTime(Action<RazorParserOptionsBuilder> configure, string fileKind);
         }
         public abstract class RazorParserOptionsBuilder {
+            public virtual string FileKind { get; }
         }
         public abstract class RazorProject {
-            public static RazorProject Create(string rootDirectoryPath);

+            public abstract RazorProjectItem GetItem(string path, string fileKind);
         }
         public abstract class RazorProjectEngine {
+            public virtual RazorCodeDocument Process(RazorSourceDocument source, string fileKind, IReadOnlyList<RazorSourceDocument> importSources, IReadOnlyList<TagHelperDescriptor> tagHelpers);
+            public virtual RazorCodeDocument ProcessDeclarationOnly(RazorProjectItem projectItem);
+            public virtual RazorCodeDocument ProcessDeclarationOnly(RazorSourceDocument source, string fileKind, IReadOnlyList<RazorSourceDocument> importSources, IReadOnlyList<TagHelperDescriptor> tagHelpers);
+            public virtual RazorCodeDocument ProcessDesignTime(RazorSourceDocument source, string fileKind, IReadOnlyList<RazorSourceDocument> importSources, IReadOnlyList<TagHelperDescriptor> tagHelpers);
         }
         public static class RazorProjectEngineBuilderExtensions {
+            public static RazorProjectEngineBuilder AddDirective(this RazorProjectEngineBuilder builder, DirectiveDescriptor directive, params string[] fileKinds);
+            public static RazorProjectEngineBuilder SetRootNamespace(this RazorProjectEngineBuilder builder, string rootNamespace);
         }
         public abstract class RazorProjectFileSystem : RazorProject {
-            public static new RazorProjectFileSystem Create(string rootDirectoryPath);
+            public static RazorProjectFileSystem Create(string rootDirectoryPath);
         }
         public abstract class RazorProjectItem {
+            public virtual string FileKind { get; }
         }
-        public class RazorTemplateEngine {
 {
-            public RazorTemplateEngine(RazorEngine engine, RazorProject project);

-            public RazorEngine Engine { get; }

-            public RazorTemplateEngineOptions Options { get; set; }

-            public RazorProject Project { get; }

-            public virtual RazorCodeDocument CreateCodeDocument(RazorProjectItem projectItem);

-            public virtual RazorCodeDocument CreateCodeDocument(string path);

-            public virtual RazorCSharpDocument GenerateCode(RazorCodeDocument codeDocument);

-            public RazorCSharpDocument GenerateCode(RazorProjectItem projectItem);

-            public RazorCSharpDocument GenerateCode(string path);

-            public virtual IEnumerable<RazorProjectItem> GetImportItems(RazorProjectItem projectItem);

-            public IEnumerable<RazorProjectItem> GetImportItems(string path);

-            public virtual IEnumerable<RazorSourceDocument> GetImports(RazorProjectItem projectItem);

-            public IEnumerable<RazorSourceDocument> GetImports(string path);

-        }
-        public sealed class RazorTemplateEngineOptions {
 {
-            public RazorTemplateEngineOptions();

-            public RazorSourceDocument DefaultImports { get; set; }

-            public string ImportsFileName { get; set; }

-        }
         public abstract class RequiredAttributeDescriptor : IEquatable<RequiredAttributeDescriptor> {
+            public bool CaseSensitive { get; protected set; }
+            public IReadOnlyDictionary<string, string> Metadata { get; protected set; }
         }
         public abstract class RequiredAttributeDescriptorBuilder {
+            public virtual IDictionary<string, string> Metadata { get; }
         }
+        public static class RequiredAttributeDescriptorBuilderExtensions
+        public static class RequiredAttributeDescriptorExtensions {
+            public static bool IsDirectiveAttribute(this RequiredAttributeDescriptor descriptor);
+        }
         public sealed class TagHelperBinding {
+            public bool IsAttributeMatch { get; }
+            public IReadOnlyDictionary<TagHelperDescriptor, IReadOnlyList<TagMatchingRuleDescriptor>> Mappings { get; }
         }
         public static class TagHelperConventions {
+            public static readonly string ComponentKind;
         }
         public abstract class TagHelperDescriptor : IEquatable<TagHelperDescriptor> {
+            public bool CaseSensitive { get; protected set; }
         }
         public abstract class TagHelperDescriptorBuilder {
+            public virtual bool CaseSensitive { get; set; }
         }
         public static class TagHelperDescriptorExtensions {
+            public static bool IsComponentOrChildContentTagHelper(this TagHelperDescriptor tagHelper);
         }
         public static class TagHelperMetadata {
             public static class Common {
+                public static readonly string ClassifyAttributesOnly;
             }
         }
         public abstract class TagMatchingRuleDescriptor : IEquatable<TagMatchingRuleDescriptor> {
+            public bool CaseSensitive { get; protected set; }
         }
     }
     namespace Microsoft.AspNetCore.Razor.Language.CodeGeneration {
         public abstract class CodeRenderingContext {
+            public virtual void AddLinePragma(LinePragma linePragma);
         }
         public abstract class DocumentWriter {
-            public DocumentWriter Create(CodeTarget codeTarget, RazorCodeGenerationOptions options);

         }
         public abstract class IntermediateNodeWriter {
+            public virtual void WriteComponent(CodeRenderingContext context, ComponentIntermediateNode node);
+            public virtual void WriteComponentAttribute(CodeRenderingContext context, ComponentAttributeIntermediateNode node);
+            public virtual void WriteComponentChildContent(CodeRenderingContext context, ComponentChildContentIntermediateNode node);
+            public virtual void WriteComponentTypeArgument(CodeRenderingContext context, ComponentTypeArgumentIntermediateNode node);
+            public virtual void WriteComponentTypeInferenceMethod(CodeRenderingContext context, ComponentTypeInferenceMethodIntermediateNode node);
+            public virtual void WriteMarkupBlock(CodeRenderingContext context, MarkupBlockIntermediateNode node);
+            public virtual void WriteMarkupElement(CodeRenderingContext context, MarkupElementIntermediateNode node);
+            public virtual void WriteReferenceCapture(CodeRenderingContext context, ReferenceCaptureIntermediateNode node);
+            public virtual void WriteSetKey(CodeRenderingContext context, SetKeyIntermediateNode node);
+            public virtual void WriteSplat(CodeRenderingContext context, SplatIntermediateNode node);
         }
+        public readonly struct LinePragma : IEquatable<LinePragma> {
+            public LinePragma(int startLineIndex, int lineCount, string filePath);
+            public int EndLineIndex { get; }
+            public string FilePath { get; }
+            public int LineCount { get; }
+            public int StartLineIndex { get; }
+            public bool Equals(LinePragma other);
+            public override bool Equals(object obj);
+            public override int GetHashCode();
+            public override string ToString();
+        }
     }
+    namespace Microsoft.AspNetCore.Razor.Language.Components {
+        public static class ComponentCodeDirective {
+            public static readonly DirectiveDescriptor Directive;
+            public static void Register(RazorProjectEngineBuilder builder);
+        }
+    }
     namespace Microsoft.AspNetCore.Razor.Language.Extensions {
+        public static class NamespaceDirective {
+            public static readonly DirectiveDescriptor Directive;
+            public static RazorProjectEngineBuilder Register(RazorProjectEngineBuilder builder);
+        }
     }
     namespace Microsoft.AspNetCore.Razor.Language.Intermediate {
+        public sealed class ComponentAttributeIntermediateNode : IntermediateNode {
+            public ComponentAttributeIntermediateNode();
+            public ComponentAttributeIntermediateNode(TagHelperDirectiveAttributeIntermediateNode directiveAttributeNode);
+            public ComponentAttributeIntermediateNode(TagHelperHtmlAttributeIntermediateNode attributeNode);
+            public ComponentAttributeIntermediateNode(TagHelperPropertyIntermediateNode propertyNode);
+            public string AttributeName { get; set; }
+            public AttributeStructure AttributeStructure { get; set; }
+            public BoundAttributeDescriptor BoundAttribute { get; set; }
+            public override IntermediateNodeCollection Children { get; }
+            public string GloballyQualifiedTypeName { get; set; }
+            public string PropertyName { get; set; }
+            public TagHelperDescriptor TagHelper { get; set; }
+            public string TypeName { get; set; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+            public bool TryParseEventCallbackTypeArgument(out string argument);
+        }
+        public sealed class ComponentChildContentIntermediateNode : IntermediateNode {
+            public ComponentChildContentIntermediateNode();
+            public string AttributeName { get; }
+            public BoundAttributeDescriptor BoundAttribute { get; set; }
+            public override IntermediateNodeCollection Children { get; }
+            public bool IsParameterized { get; }
+            public string ParameterName { get; set; }
+            public string TypeName { get; set; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class ComponentIntermediateNode : IntermediateNode {
+            public ComponentIntermediateNode();
+            public IEnumerable<ComponentAttributeIntermediateNode> Attributes { get; }
+            public IEnumerable<ReferenceCaptureIntermediateNode> Captures { get; }
+            public string ChildContentParameterName { get; set; }
+            public IEnumerable<ComponentChildContentIntermediateNode> ChildContents { get; }
+            public override IntermediateNodeCollection Children { get; }
+            public TagHelperDescriptor Component { get; set; }
+            public IEnumerable<SetKeyIntermediateNode> SetKeys { get; }
+            public IEnumerable<SplatIntermediateNode> Splats { get; }
+            public string TagName { get; set; }
+            public IEnumerable<ComponentTypeArgumentIntermediateNode> TypeArguments { get; }
+            public ComponentTypeInferenceMethodIntermediateNode TypeInferenceNode { get; set; }
+            public string TypeName { get; set; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class ComponentTypeArgumentIntermediateNode : IntermediateNode {
+            public ComponentTypeArgumentIntermediateNode(TagHelperPropertyIntermediateNode propertyNode);
+            public BoundAttributeDescriptor BoundAttribute { get; set; }
+            public override IntermediateNodeCollection Children { get; }
+            public TagHelperDescriptor TagHelper { get; set; }
+            public string TypeParameterName { get; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class ComponentTypeInferenceMethodIntermediateNode : IntermediateNode {
+            public ComponentTypeInferenceMethodIntermediateNode();
+            public override IntermediateNodeCollection Children { get; }
+            public ComponentIntermediateNode Component { get; set; }
+            public string FullTypeName { get; internal set; }
+            public string MethodName { get; set; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
         public static class DocumentIntermediateNodeExtensions {
+            public static IReadOnlyList<IntermediateNodeReference> FindDescendantReferences<TNode>(this DocumentIntermediateNode document) where TNode : IntermediateNode;
         }
         public sealed class FieldDeclarationIntermediateNode : MemberDeclarationIntermediateNode {
+            public IList<string> SuppressWarnings { get; }
         }
         public sealed class HtmlAttributeIntermediateNode : IntermediateNode {
+            public string EventUpdatesAttributeName { get; set; }
         }
         public sealed class IntermediateNodeCollection : ICollection<IntermediateNode>, IEnumerable, IEnumerable<IntermediateNode>, IList<IntermediateNode> {
+            public void AddRange(IntermediateNodeCollection items);
+            public void AddRange(IEnumerable<IntermediateNode> items);
         }
         public abstract class IntermediateNodeVisitor {
+            public virtual void VisitComponent(ComponentIntermediateNode node);
+            public virtual void VisitComponentAttribute(ComponentAttributeIntermediateNode node);
+            public virtual void VisitComponentChildContent(ComponentChildContentIntermediateNode node);
+            public virtual void VisitComponentTypeArgument(ComponentTypeArgumentIntermediateNode node);
+            public virtual void VisitComponentTypeInferenceMethod(ComponentTypeInferenceMethodIntermediateNode node);
+            public virtual void VisitMarkupBlock(MarkupBlockIntermediateNode node);
+            public virtual void VisitMarkupElement(MarkupElementIntermediateNode node);
+            public virtual void VisitReferenceCapture(ReferenceCaptureIntermediateNode node);
+            public virtual void VisitSetKey(SetKeyIntermediateNode node);
+            public virtual void VisitSplat(SplatIntermediateNode node);
+            public virtual void VisitTagHelperDirectiveAttribute(TagHelperDirectiveAttributeIntermediateNode node);
+            public virtual void VisitTagHelperDirectiveAttributeParameter(TagHelperDirectiveAttributeParameterIntermediateNode node);
         }
+        public sealed class MarkupBlockIntermediateNode : IntermediateNode {
+            public MarkupBlockIntermediateNode();
+            public override IntermediateNodeCollection Children { get; }
+            public string Content { get; set; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class MarkupElementIntermediateNode : IntermediateNode {
+            public MarkupElementIntermediateNode();
+            public IEnumerable<HtmlAttributeIntermediateNode> Attributes { get; }
+            public IEnumerable<IntermediateNode> Body { get; }
+            public IEnumerable<ReferenceCaptureIntermediateNode> Captures { get; }
+            public override IntermediateNodeCollection Children { get; }
+            public IEnumerable<SetKeyIntermediateNode> SetKeys { get; }
+            public string TagName { get; set; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class ReferenceCaptureIntermediateNode : IntermediateNode {
+            public ReferenceCaptureIntermediateNode(IntermediateToken identifierToken);
+            public ReferenceCaptureIntermediateNode(IntermediateToken identifierToken, string componentCaptureTypeName);
+            public override IntermediateNodeCollection Children { get; }
+            public string ComponentCaptureTypeName { get; set; }
+            public string FieldTypeName { get; }
+            public IntermediateToken IdentifierToken { get; }
+            public bool IsComponentCapture { get; }
+            public string TypeName { get; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class SetKeyIntermediateNode : IntermediateNode {
+            public SetKeyIntermediateNode(IntermediateToken keyValueToken);
+            public override IntermediateNodeCollection Children { get; }
+            public IntermediateToken KeyValueToken { get; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class SplatIntermediateNode : IntermediateNode {
+            public SplatIntermediateNode();
+            public override IntermediateNodeCollection Children { get; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class TagHelperDirectiveAttributeIntermediateNode : IntermediateNode {
+            public TagHelperDirectiveAttributeIntermediateNode();
+            public string AttributeName { get; set; }
+            public AttributeStructure AttributeStructure { get; set; }
+            public BoundAttributeDescriptor BoundAttribute { get; set; }
+            public override IntermediateNodeCollection Children { get; }
+            public bool IsIndexerNameMatch { get; set; }
+            public string OriginalAttributeName { get; set; }
+            public TagHelperDescriptor TagHelper { get; set; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
+        public sealed class TagHelperDirectiveAttributeParameterIntermediateNode : IntermediateNode {
+            public TagHelperDirectiveAttributeParameterIntermediateNode();
+            public string AttributeName { get; set; }
+            public string AttributeNameWithoutParameter { get; set; }
+            public AttributeStructure AttributeStructure { get; set; }
+            public BoundAttributeDescriptor BoundAttribute { get; set; }
+            public BoundAttributeParameterDescriptor BoundAttributeParameter { get; set; }
+            public override IntermediateNodeCollection Children { get; }
+            public bool IsIndexerNameMatch { get; set; }
+            public string OriginalAttributeName { get; set; }
+            public TagHelperDescriptor TagHelper { get; set; }
+            public override void Accept(IntermediateNodeVisitor visitor);
+            public override void FormatNode(IntermediateNodeFormatter formatter);
+        }
     }
 }
```

