
***Note: For all new known issues after [3.0 GA](../3.0.0/3.0.0.md) refer the [3.0 known issues file.](../3.0-known-issues.md)***

# .NET Core 3.0 Preview Known Issues

This document lists known issues for **.NET Core 3.0 Preview releases** which may be encountered during usage.

## .NET Core

### .NET Core 3.0 SDK, all releases

- **`PATH` intermittently not updated when installing on MacOS ([core-sdk/3331](https://github.com/dotnet/core-sdk/issues/3331))**

    There are some situations, which we do not yet understand, where PATH is not properly updated after installing the .NET Core SDK on MacOS. The result is a `dotnet: command not found` error reported in the terminal when attempting to run a `dotnet` command.

    The PATH issue can be confirmed by typing `echo $PATH | grep "dotnet"` and observing if `dotnet` is shown in the output. If `/usr/local/share/dotnet` is not present in PATH, it can be added for the current terminal session with `export PATH = $PATH:/usr/local/share/dotnet`.

    To update the path for every new terminal session, the `export` entry will need to be added to your terminal resource file. This file will be different depending upon your default terminal (eg bash, zsh, ...) and configuration (.bash_profile, .bashrc, .zshrc, ...).

### Preview 9

- **[RESOLVED] Misnamed or colliding non-resx resources ([microsoft/msbuild#4740](https://github.com/microsoft/msbuild/issues/4740))**

    Projects that specify non-resx `EmbeddedResource`s may have the resources embedded under an incorrect name (causing code that uses the correct name to fail at runtime). If two or more files are embedded in this way, `CS1508: The resource identifier ... has already been used in this assembly` may be issued at build time.
    
    This can be worked around with a property in the project file
    
    ```xml
    <PropertyGroup>
        <!-- Work around https://github.com/microsoft/msbuild/issues/4740 -->
        <EmbeddedResourceUseDependentUponConvention>false</EmbeddedResourceUseDependentUponConvention>
    </PropertyGroup>
    ```
    
    Resolved in the final `3.0.100` SDK.

- **Builds fail with `MSB3041` when a `.resx` file is in a subfolder [microsoft/msbuild#4695](https://github.com/microsoft/msbuild/issues/4695)**

    MSBuild incorrectly constructs paths to `DependentUpon` source files related to `.resx` files that aren't at the project root. There is a workaround:
    
    Explicitly set `DependentUpon` metadata for resource files ([example for Entity Framework migrations](https://github.com/aspnet/EntityFramework6/issues/1225#issuecomment-528571274)).
    
### Preview 5

- **Visual style in WinForms app not showing correctly when publishing with PublishReadyToRun=true**

    The ReadyToRun compiler in this preview does not copy Win32 resources from the managed assembly to the compiled output binary, which causes an issue with visual styles in WinForms apps. The workaround is to skip compilation of System.Windows.Forms.dll by adding the following to the project file:
    ```xml
    <ItemGroup>
      <PublishReadyToRunExclude Include="System.Windows.Forms.dll" />            
    </ItemGroup>
    ```    

- **[RESOLVED] Scaffolding hangs indefinitely**

    With a 3.0.100-preview5 SDK installed, and Visual Studio 16.0-preview2 or earlier, attempting to scaffold a .NET Core 3.0 project in Visual Studio will cause Visual Studio to hang indefinitely, with no indication of the problem. With a 3.0.100-preview5 SDK installed, and Visual Studio 16.0-preview3, Scaffolding will fail for all 3.0 projects.

    Workaround: Uninstall 3.0.100-preview5 and install a lower version.

## ASP.NET Core

### Preview 9

- **[RESOLVED] WebSocket connections to IIS In-Process servers will close after the client sends ~30MB**

    WebSocket connections to IIS In-Process servers will close after the client sends ~30MB of data.

    To workaround this issue you can host your app with the [OutOfProcess](https://docs.microsoft.com/aspnet/core/host-and-deploy/aspnet-core-module?view=aspnetcore-3.0#out-of-process-hosting-model) hosting model. Or you can change the `MaxRequestBodySize` limit in your app when handling WebSocket requests by adding the following to your middleware pipeline:
  
  ```csharp
  app.Use(next => context =>
  {
      if (context.WebSockets.IsWebSocketRequest)
      {
          context.Features.Get<IHttpMaxRequestBodySizeFeature>()?.MaxRequestBodySize = null;
      }
      return next(context);
  });
  ```

### Preview 8

- **[RESOLVED] Starting a client or bi-directional streaming gRPC call with an already canceled `CallOptions.CancellationToken` will hang**

   Starting a client or bi-directional streaming call with an already canceled `CallOptions.CancellationToken` will not properly cancel the call. Sending a message with `RequestStream.WriteAsync` will hang.
   
   To workaround this issue ensure that the `CancellationToken` passed to client or bi-directional streaming calls is only ever canceled after the call has started.
   
- **[RESOLVED] Using the @ref automatic backing field feature result in build errors**

   We added a productivity feature in Blazor to automatically generate backing fields for elements that utilized the `@ref` attribute. Unfortunately, we missed a critical design flaw which prevents this from working end-to-end. For more information check out the corresponding [announcement](https://github.com/aspnet/Announcements/issues/381).

### Preview 7

- **[RESOLVED] Incorrect launch URL for the Web API template**

   The Web API template was updated to generate a `WeatherForecastController` instead of a `ValuesController`, but the launch URL was not updated accordingly. As a result Visual Studio launches the browser at the wrong URL for the Web API, which results in a 404 response. To work around this issue update the *Properties/launchSettings.json* file to change the launch URL from "api/values" to "weatherforecast".

### Preview 6

- **[RESOLVED] Publishing an ASP.NET Core hosted client-side Blazor app to Azure as a self-contained app fails**

    Publishing an ASP.NET Core hosted client-side Blazor app to Azure as a self-contained app fails with the following error:

    ```
    Error NETSDK1005: Assets file 'C:\Users\user\Source\Repos\WebApplication1\WebApplication1.Client\obj\project.assets.json' doesn't have a target for '.NETStandard,Version=v2.0'. Ensure that restore has run and that you have included 'netstandard2.0' in the TargetFrameworks for your project.
    ```

    To work around this issue remove the `<TargetFramework>netcoreapp3.0</TargetFramework>` line from the generated pubxml file under *Properties\Publish Profiles<profilename>.pubxml*.

- **[RESOLVED] Cancellation is not sent to the server when using the `Grpc.Net.Client` gRPC client**

    Canceling a gRPC client will cancel the call on the client, but will not send a cancellation notification to the server.

    If your gRPC services rely on cancellation you should continue to use the `Grpc.Core` gRPC client until preview 7. This issue will be fixed in a future update.

- **[RESOLVED] `@bind-value` on its own results in a build error**

    Writing `<input @bind-value="SOMEVALUE" />` in a component results in the following error:

    ```
    error RZ9991: The attribute names could not be inferred from bind attribute '@bind-value'. Bind attributes should be of the form'bind' or 'bind-value' along with their corresponding optional parameters like 'bind-value:event', 'bind:format' etc.
    ```

    To work around this issue add a `@bind-value:event="SOMEEVENT"` to the input element: `<input @bind-value="SOMEVALUE" @bind-value:event="SOMEEVENT" />`.

- **[RESOLVED] `@attribute` directive does not work in _Imports.razor**

    When adding the `@attribute` directive in *_Imports.razor* the project may fail to build with the following error:

    ```
    System.IndexOutOfRangeException : Index was outside the bounds of the array.
    ```

    To workaround this issue add the `@attribute` to the individual .razor files instead of in *_Imports.razor*.

- **[RESOLVED] Using element refs with JavaScript interop in a client-side Blazor apps fails when the IL linker is disabled**

    Using element refs with JavaScript interop in a client-side Blazor apps fails when the IL linker is disabled with the following exception:

    ```
    System.MissingMethodException: Method not found: !!0& System.Runtime.CompilerServices.Unsafe.Unbox<!0>(object)
    ```

    To work around this issue enable the IL linker as part of the build.

- **[RESOLVED] Using the AuthorizingContent and NotAuthorizedContent parameters on Router results in a compilation error in server-side Blazor apps**

    Specifying the `AuthorizingContent` or `NotAuthorizedContent` parameters on the `Router` component in a server-side Blazor app results in a compilation error.

    ```
    error RZ9996: Unrecognized child content inside component 'Router'. The component 'Router' accepts child content through the following top-level items: 'NotFoundContent'.
    ```

    This issue will be fixed in a future update.

- **[RESOLVED] `Grpc.Net.ClientFactory` does not reference all required types when used outside of ASP.NET Core**

    The gRPC client factory does not reference the `Microsoft.Extensions.Http` package. If you are using the client factory you will need to include a reference to `Microsoft.Extensions.Http` in the project file.

    ```xml
    <PackageReference Include="Grpc.Net.ClientFactory" Version="0.1.21-pre1" />
    <PackageReference Include="Microsoft.Extensions.Http" Version="2.2.1" />
    ```

    This issue will be fixed in a future update.

### Preview 4

- **[RESOLVED] Server-side Blazor app fails to run on non-Windows platforms**

    Running a server-side Blazor app on a non-Windows platform fails with the following error:

    ```
    System.InvalidOperationException: Could not load the embedded file manifest 'Microsoft.Extensions.FileProviders.Embedded.Manifest.xml' for assembly 'Microsoft.AspNetCore.Components.Server'.
    ```

    This will be addressed in the next preview update.

- **[RESOLVED] A request made to a CORS-enabled endpoint without an origin header fails with an HTTP 500 error.**

    Possible workarounds include:

    1. Having a middleware that sets the value in `HttpContext.Items` after `UseCors()`

        ```C#
        app.UseCors();

        app.Use((context, next) =>
        {
            context.Items["__CorsMiddlewareInvoked"] = true;
            return next();
        });
        ```

    2. Disable the check in `EndpointRouting`:
    
        ```C#
        services.AddRouting(r => r.SuppressCheckForUnhandledSecurityMetadata = true);
        ```

    The first option would be preferred since it's not removing a check for a mis-configured application.

- **[RESOLVED] Design-time errors in Visual Studio when using a component with child content from a component that lives in a different namespace**

    This issue will be addressed in a future preview of Visual Studio. To workaround this issue, fully qualify the name of the child component

- **[RESOLVED] Design-time errors in Visual Studio for class libraries with Blazor components**

    This issue will be addressed in a future preview of Visual Studio. To workaround this issue add the `<AddRazorSupportForMvc>true</AddRazorSupportForMvc>` property to your project file.

- **[RESOLVED] Publishing an ASP.NET Core hosted client-side Blazor app to Azure as a self-contained app fails**

    Publishing an ASP.NET Core hosted client-side Blazor app to Azure as a self-contained app fails with the following error:

    ```
    Error CS0006: Metadata file 'C:\Users\user\Source\Repos\WebApplication3\WebApplication3.Client\bin\Release\netstandard2.0\win-x86\WebApplication1.Client.dll' could not be found
    ```

    To workaround this issue, add the `<AppendRuntimeIdentifierToOutputPath>false</AppendRuntimeIdentifierToOutputPath>` property to the client project file.

### Preview 3

- **[RESOLVED] The Windows Hosting bundle doesn't exist for Preview3**: The Windows Hosting bundle contained an issue which copied the 32 bit dlls into 64 bit locations. To work aroud this issue, please install the 3.0 Preview 2 [Hosting Bundle](https://github.com/dotnet/core/blob/main/release-notes/3.0/preview/3.0.0-preview2-download.md) and run the executable on a command line with the paramaters `OPT_NO_SHAREDFX=1 OPT_NO_RUNTIME=1`. Then install the appropriate .NET and ASP.NET runtimes for preview3.

- **[RESOLVED] Updates to .razor files fail to show up in subsequent builds**: Updates to Razor Component (.razor) in Visual Studio may fail to show up in subsequent builds. To work around this issue add the following item group to the project file:

    ```xml
    <ItemGroup>
        <UpToDateCheckInput Include="@(Content->WithMetadataValue('Extension', '.razor'))" />
    </ItemGroup>
    ```

- **[RESOLVED] Updates to Razor Components in .razor files fail to show up in IntelliSense**: Updates to Razor Components defined in .razor files may fail to show up in IntelliSense in Visual Studio. To workaround this issue rebuild the project.

- **[RESOLVED] Single Page Applications with authentication enabled throws method not found exception when visiting the register or login pages**: The exception message is the one below.
`Method not found: 'Microsoft.EntityFrameworkCore.Metadata.Builders.IndexBuilder Microsoft.EntityFrameworkCore.Metadata.Builders.EntityTypeBuilder``1.HasIndex(System.Linq.Expressions.Expression``1<System.Func``2<!0,System.Object>>)'.` To workaround this issue follow these steps:
  * Replace the following package references with the ones below in your csproj folder:
    ```xml
    <PackageReference Include="Microsoft.AspNetCore.Identity.EntityFrameworkCore" Version="3.0.0-preview3-19153-02" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Sqlite" Version="3.0.0-preview3.19153.1" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Tools" Version="3.0.0-preview3.19153.1" />
    ```

    ```xml
    <PackageReference Include="Microsoft.AspNetCore.Identity.EntityFrameworkCore" Version="3.0.0-preview-18579-0056" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Sqlite" Version="3.0.0-preview.19080.1" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Tools" Version="3.0.0-preview.19080.1" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Relational" Version="3.0.0-preview.19080.1" />
    <PackageReference Include="Microsoft.EntityFrameworkCore" Version="3.0.0-preview.19080.1" />
    ```

  * Add the following snippet to your csproj file:
    ```xml
    <PropertyGroup>
      <NoWarn>$(NoWarn);NU1605</NoWarn>
    </PropertyGroup>
    ```
    
- **[RESOLVED] Referencing 3.0.0 MVC libraries don't work as intended**: There are several issues with referencing a 3.0.0 MVC library.

    * Razor pages will 404, 
    * ApplicationParts and factories will not be discoverable
    * Controllers will not be discoverable

    To workaround this issue do the following:

    * Add the helper method:
    ```C#
    private void Add30AssemblyWorkaround(Assembly referencedAssembly, ApplicationPartManager applicationPartManager)
    {
        var partFactory = ApplicationPartFactory.GetApplicationPartFactory(referencedAssembly);

        foreach (var part in partFactory.GetApplicationParts(referencedAssembly))
        {
            applicationPartManager.ApplicationParts.Add(part);
        }

        var relatedAssemblies = RelatedAssemblyAttribute.GetRelatedAssemblies(referencedAssembly, throwOnError: true);
        foreach (var assembly in relatedAssemblies)
        {
            partFactory = ApplicationPartFactory.GetApplicationPartFactory(assembly);
            foreach (var part in partFactory.GetApplicationParts(assembly))
            {
                applicationPartManager.ApplicationParts.Add(part);
            }
        }
    }
    ```

    * Modify your `services.AddMvc()` call in `Startup.cs`:
    ```C#
    services.AddMvc()
        .ConfigureApplicationPartManager(manager =>
        {
            var referencedAssembly = Assembly.Load("RCL");
            Add30AssemblyWorkaround(referencedAssembly, manager);
        })
        ...
    ```

- **[RESOLVED] React template with authentication has a syntax error on build** in file /ClientApp/src/components/api-authorization/ApiAuthorizationConstants.js
When building or running the react template with authentication, after opening the browser, the app won't work and the following error message will be displayed.
  ```console
  ×
  Error: Module build failed: SyntaxError: ClientApp/src/components/  api-authorization/ApiAuthorizationConstants.js: Unexpected token (27:25)
  
    25 |   DefaultLoginRedirectPath: '/',
    26 |   ApiAuthorizationClientConfigurationUrl: `/_configuration/$ {ApplicationName}`,
  > 27 |   ApiAuthorizationPrefix = prefix,
       |                          ^
    28 |   Login: `${prefix}/${LoginActions.Login}`,
    29 |   LoginFailed: `${prefix}/${LoginActions.LoginFailed}`,
    30 |   LoginCallback: `${prefix}/${LoginActions.LoginCallback}`,
  ```
  * Workaround:
  Replace `ApiAuthorizationPrefix = prefix,` with `ApiAuthorizationPrefix: prefix,`

- **[RESOLVED] Import error "Cannot find module "./components/api-authorization/Login"**: When building or running the react template with authentication, after opening the browser, the app won't work and the following error message will be displayed.
  ```console
  ×
  Error: Cannot find module "./components/api-authorization/Login"
  ▼ 13 stack frames were expanded.
  ./src/components/api-authorization/ApiAuthorizationRoutes.js
  https://localhost:44315/static/js/bundle.js:53166:7
  __webpack_require__
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:678
  fn
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:88
  ./src/App.js
  https://localhost:44315/static/js/bundle.js:51925:111
  __webpack_require__
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:678
  fn
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:88
  ./src/index.js
  https://localhost:44315/static/js/bundle.js:54708:63
  __webpack_require__
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:678
  fn
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:88
  0
  https://localhost:44315/static/js/bundle.js:54860:18
  __webpack_require__
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:678
  (anonymous function)
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:724
  (anonymous function)
  https://localhost:44315/static/js/bundle.js:728:10
  ```

  * Workaround:
    * Remove the file /ClientApp/src/components/api-authorizationApi/AuthorizationRoutes.js
    * Replace the contents of App.js with these
      ```javascript
      import React, { Component } from 'react';
      import { Route } from 'react-router';
      import { Layout } from './components/Layout';
      import { Home } from './components/Home';
      import { FetchData } from './components/FetchData';
      import { Counter } from './components/Counter';
      import { Login } from './components/api-authorization/Login'
      import { Logout } from './components/api-authorization/Logout'
      import AuthorizeRoute from './components/api-authorization/AuthorizeRoute';
      import { ApplicationPaths, LoginActions, LogoutActions } from './components/api-authorization/ApiAuthorizationConstants';

      export default class App extends Component {
        static displayName = App.name;

        render () {
          return (
            <Layout>
              <Route exact path='/' component={Home} />
              <Route path='/counter' component={Counter} />
              <AuthorizeRoute path='/fetch-data' component={FetchData} />
              <Route path={ApplicationPaths.Login} render={() => loginAction(LoginActions.Login)} />
              <Route path={ApplicationPaths.LoginFailed} render={() => loginAction(LoginActions.LoginFailed)} />
              <Route path={ApplicationPaths.LoginCallback} render={() => loginAction(LoginActions.LoginCallback)} />
              <Route path={ApplicationPaths.Profile} render={() => loginAction(LoginActions.Profile)} />
              <Route path={ApplicationPaths.Register} render={() => loginAction(LoginActions.Register)} />
              <Route path={ApplicationPaths.LogOut} render={() => logoutAction(LogoutActions.Logout)} />
              <Route path={ApplicationPaths.LogOutCallback} render={() => logoutAction(LogoutActions.LogoutCallback)} />
              <Route path={ApplicationPaths.LoggedOut} render={() => logoutAction(LogoutActions.LoggedOut)} />
            </Layout>
          );
        }
      }

      function loginAction(name){
          return (<Login action={name}></Login>);
      }

      function logoutAction(name) {
          return (<Logout action={name}></Logout>);
      }
      ```

- **[RESOLVED] Runtime compilation using Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation throws an error stating "Cannot find reference assembly"**: When performing runtime Razor compilation, the application throws an error stating reference assemblies cannot be found. To workaround this, edit the project file and add this following property:
  ```xml
  <PropertyGroup>
    <PreserveCompilationReferences>true</PreserveCompilationReferences>
  </PropertyGroup>
   ```
