# System.Resources.Extensions

``` diff
+namespace System.Resources.Extensions {
+    public sealed class DeserializingResourceReader : IDisposable, IEnumerable, IResourceReader {
+        public DeserializingResourceReader(Stream stream);
+        public DeserializingResourceReader(string fileName);
+        public void Close();
+        public void Dispose();
+        public IDictionaryEnumerator GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public sealed class PreserializedResourceWriter : IDisposable, IResourceWriter {
+        public PreserializedResourceWriter(Stream stream);
+        public PreserializedResourceWriter(string fileName);
+        public void AddActivatorResource(string name, string typeName, Stream value, bool closeAfterWrite = false);
+        public void AddBinaryFormattedResource(string name, string typeName, byte[] value);
+        public void AddResource(string name, byte[] value);
+        public void AddResource(string name, Stream value, bool closeAfterWrite = false);
+        public void AddResource(string name, object value);
+        public void AddResource(string name, string value);
+        public void AddTypeConverterResource(string name, string typeName, byte[] value);
+        public void AddTypeConverterResource(string name, string typeName, string value);
+        public void Close();
+        public void Dispose();
+        public void Generate();
+    }
+}
```

