# .NET Core 3.1.301 - June 9, 2020

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 3.1.301
* .NET Core Runtime 3.1.5
* ASP.NET Core 3.1.5

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.5/3.1.5.md) for details about what is included in this update.


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.6 | [3.1.301](#downloads) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.105](3.1.5.md) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel 3.1/stable –-classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |


## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-3.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-3.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.1.5-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.5/3.1.301-download.md
[snap-install]: 3.1.5-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.5-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-march-2020/





[//]: # ( Runtime 3.1.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/15132a5c-f0f4-4373-8b8b-b7e70834d899/cad479dda52359ad43956471274ec932/dotnet-runtime-3.1.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65291ed8-e931-4605-9d5a-265928a835d0/1a15d18655c8b260170117e9bd1a1cb7/dotnet-runtime-3.1.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb2d5114-feed-4dd9-aada-afe3784d2c1a/95e7bc1576e4344b3a1b101e3b4f763d/dotnet-runtime-3.1.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56f86fa0-834a-4397-94b4-d4331078c91f/7de4bc57ed6a5cd7dddcefeed7aa1fd6/dotnet-runtime-3.1.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d00eaeea-6d7b-4e73-9d96-c0234ed3b665/0d25d9d1aeaebdeef01d15370d5cd22b/dotnet-runtime-3.1.5-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e6494006-4940-48ed-9c28-a91fd4cfafba/fd10e3e409d55ff15f43611db6f9ead0/dotnet-runtime-3.1.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1c0ee25-9bd5-48ef-96e9-33d3d8e52a7c/8cf1d5065aa5352b838c1c4278942dcf/dotnet-runtime-3.1.5-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49656370-10aa-4db6-858b-db9fb51a1797/45929f56c70c9c6b7d864e353dae84e1/dotnet-runtime-3.1.5-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/49b6cd90-d8d1-4ce8-a7c2-2f7dfd3bdd5c/618343672c8f8972704f12b3517ce912/dotnet-runtime-3.1.5-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d97cfaf4-b17f-46c7-9a11-7f0d25dfd8b0/f76d4fce8e38b289efb9403aab0a0c9f/dotnet-runtime-3.1.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bc76dfb3-3666-4dcb-9e29-79f0a4e5c727/3b1c6aa838db8d49d8de1cb65feae626/dotnet-runtime-3.1.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fcea8129-4de7-4842-aa80-42efb2e0f250/3205c15852a1b559659991236eca5ac5/dotnet-runtime-3.1.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/76a97b28-a754-456b-be6d-fbf82cc8a237/746ac1926d55f8e0827404a763a5c5c0/dotnet-runtime-3.1.5-win-x86.zip

[//]: # ( WindowsDesktop 3.1.5)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/86835fe4-93b5-4f4e-a7ad-c0b0532e407b/f4f2b1239f1203a05b9952028d54fc13/windowsdesktop-runtime-3.1.5-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/df7b90d9-b93e-4974-85ef-c1de418bc186/e380e58bbd8505ebaee6c3abb23baade/windowsdesktop-runtime-3.1.5-win-x86.exe

[//]: # ( ASP 3.1.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e519c5b-b434-4067-bc0b-bb38179f7e4f/80a840dc7fb2c4a065f442aea1d98516/aspnetcore-runtime-3.1.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91f02336-1852-421d-907f-4aeae252a15e/dbb20e3a176c38a569cbcaa5d1d5782b/aspnetcore-runtime-3.1.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/021b09b2-1de4-47f8-9dcb-183795e2ada3/4f823c9ab8b968f734eda54f7d40090e/aspnetcore-runtime-3.1.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8438f49c-a336-4846-87ae-b3badfb978ee/2b4d72e03ccd0e737657e0534f4e092c/aspnetcore-runtime-3.1.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6827d794-a218-4352-b3b3-a19ec773c975/e3e53bc2f20df220a29c6e09f74d8a00/aspnetcore-runtime-3.1.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d4a6ce4-7d9f-4087-bd06-23aa54d1b9ac/e6fb7592489a5d5a8a2801196509dd72/aspnetcore-runtime-3.1.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/c21c6919-1016-49b9-a99b-3d99fe489f3c/5e25370475eb6a891d883de77ebc4613/aspnetcore-runtime-3.1.5-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6818f1f7-75de-43e5-9202-2b328ca127f7/039edc4bab29e5af63ed618e59f82fad/aspnetcore-runtime-3.1.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b5d221a7-f799-4ac2-9da9-26855a6778c1/7eefcd7210b825b98c4ad14190075f70/aspnetcore-runtime-3.1.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c5f311ca-3ed2-4249-8e09-51ff15250836/dfbee818fd022129a60f290187215b2f/aspnetcore-runtime-3.1.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7e417328-ef5b-4584-96c6-feaadcb8da80/e5c2f428da51907d6a2c6abc35fa172a/aspnetcore-runtime-3.1.5-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/7c30d3a1-f519-4167-b850-b9c49bf2aa0e/dbfa957a76a41a1e1795f59d400d4ccd/dotnet-hosting-3.1.5-win.exe

[//]: # ( SDK 3.1.301 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbf4ea18-70bf-4b0f-ae9c-65c8c88bcadd/115e84fb95170ddeeaf9bdb9222c964d/dotnet-sdk-3.1.301-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fe5c0663-3ed1-4a93-95e1-fd068b89215b/14d1caad8fd2859d5f3514745a9bf6b3/dotnet-sdk-3.1.301-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5cb7099e-fc8e-4a44-b9ec-79f353c4635f/234e69ea68821cf6fa022c4aa9781cbb/dotnet-sdk-3.1.301-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8db2b522-7fa2-4903-97ec-d6d04d297a01/f467006b9098c2de256e40d2e2f36fea/dotnet-sdk-3.1.301-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/aad9adc7-90bb-4294-a378-00f4cc5fb695/89cfc771a783b1441c34ac925aee7141/dotnet-sdk-3.1.301-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d8bc3271-b869-4dc3-96db-d91c574bacc7/b2fbdac38ca4ac71194a41cdd97f1d82/dotnet-sdk-3.1.301-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f64df040-452c-4e57-96e1-56936ee8a8ea/758bc5ce3ad1331a97f2c39f5f21f27b/dotnet-sdk-3.1.301-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/46cc1326-b655-46b5-925b-bd69e627f699/4110a7c0356eb62ae5c44a7cff9b0f56/dotnet-sdk-3.1.301-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4e88f517-196e-4b17-a40c-2692c689661d/eed3f5fca28262f764d8b650585a7278/dotnet-sdk-3.1.301-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cb535978-7eb4-4bcb-8e85-98c3d42eae3f/1acdc320ba87e1d840242ee4b930b026/dotnet-sdk-3.1.301-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/77b944fa-aa83-4101-85a9-9d3bde200ebc/f0f0e2a3544593b19df8471cbe9b6b61/dotnet-sdk-3.1.301-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/26af3d3c-a6d9-43f7-8e31-63e6fdd122a9/63722096d4aca389101c3c8ca74c9334/dotnet-sdk-3.1.301-win-x86.zip

[//]: # ( Symbols )
