# .NET 5.0.207 SDK - September 14, 2021

The .NET SDK 5.0.207 release is available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe]  \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.207
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.10](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6687](https://github.com/dotnet/core/issues/6687) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/5.0.10/5.0.10.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.10-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.10-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/september-2021-updates/



[linux-packages]: ../install-linux.md


[//]: # ( Runtime 5.0.10)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/142ca547-55c2-4b0e-946c-dc30c555fc50/b26a3a9218f49a913c749dc6eb493ab9/dotnet-runtime-5.0.10-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/99d1c6f0-ab17-42aa-834b-a54aa112bd3f/fdb07756e0ba625a60697f208950817e/dotnet-runtime-5.0.10-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2f1bce6-0d63-48a0-82f0-cb72982e2dc1/21770b33bea847a4c7d6c53ff814d666/dotnet-runtime-5.0.10-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f1511ac-61e2-40e5-8030-7493c1b0a4b2/f405a7bac235b73fd544ab492641187a/dotnet-runtime-5.0.10-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f1e3cb9-cdf2-4adc-bcc3-31cd52481b08/ffb85bc6b87dc70765de2f66e061be1a/dotnet-runtime-5.0.10-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bb93b65-658d-4c6c-b4e2-32ec2a3d8aa6/ca3a11e65bcbc6dbb30330a54fcc1059/dotnet-runtime-5.0.10-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0a1577a6-a7f1-4da0-ae64-9003ff8badb5/3b3a9291a0bdcb5591afab9e842272db/dotnet-runtime-5.0.10-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7358d713-f1f5-40c3-877d-1181bad92414/0a92ccada1f5ec96b99458def5ea354e/dotnet-runtime-5.0.10-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b3a90bf5-65ed-4941-8429-5af6f0498510/700f817199c527d68f9348cbf87840e3/dotnet-runtime-5.0.10-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/75aa56a0-41af-471b-8f52-10effacf4a57/dfab419662069806eab1d8e0df11890d/dotnet-runtime-5.0.10-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9f93e474-1bad-4c66-8445-57a2ef6983d6/b49e4837fc4851a0c85da41d70495c13/dotnet-runtime-5.0.10-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e285f4d2-03b3-44b3-960c-4897d24b36a6/3e2458ba37e913aad84394253c0a50da/dotnet-runtime-5.0.10-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c28d0535-cb4c-45f7-a709-7fe5ead90735/a266d0f95f4fe11e2da4afd7b5353009/dotnet-runtime-5.0.10-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/95a92e1e-b378-4427-9830-8d5acaffeec4/27e8325097b16ff5b8e9846b7a289cc3/dotnet-runtime-5.0.10-win-x86.zip

[//]: # ( WindowsDesktop 5.0.10)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/20b2a5e9-2a9d-4856-be13-198b58121829/7d46975c9facb1e185d9b26b690f4f23/windowsdesktop-runtime-5.0.10-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/78fa839b-2d86-4ece-9d97-5b9fe6fb66fa/10d406c0d247470daa80691d3b3460a6/windowsdesktop-runtime-5.0.10-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7ed142ef-5738-4eea-bdd3-9210c5dd4973/ce3d680c487b178a828c5c3edd9ec685/windowsdesktop-runtime-5.0.10-win-x86.exe

[//]: # ( ASP 5.0.10)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7155f514-7899-4fc8-98ea-9f08f75b5523/348df0133f0ba0b81f5f984d6c55b748/aspnetcore-runtime-5.0.10-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ce6cf91-6aff-4565-87df-d20212418009/e3a924fa1192637dcd7379c1109e14e0/aspnetcore-runtime-5.0.10-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89fcfe21-7239-483c-bcfb-61057afec532/63a73333fbb69159ade943f104cfc363/aspnetcore-runtime-5.0.10-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5dc73750-ff87-4882-85aa-fed91b5cdaf7/4741c00ddbe1cc4c17e29878c0cd2aa5/aspnetcore-runtime-5.0.10-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a256de3f-b516-437f-a480-d66499a84aad/0fe47b7f0eee95bfaa5c6515ae0dd893/aspnetcore-runtime-5.0.10-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20984ce7-f18d-414a-9a16-bf05cd0cc7a1/ca5ab821884e7e3b3b4febf9f7a4b50e/aspnetcore-runtime-5.0.10-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd84e4c7-8267-4b4e-843e-f25a01dfbe15/1191a8b6422be4390b47cef54fba8790/aspnetcore-runtime-5.0.10-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ab961f8e-14c4-41ce-af2f-864fb8aa83ff/86f460a0c4c2071d9c4307f9b56d92c1/aspnetcore-runtime-5.0.10-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/69a4b292-6680-46b6-a067-eaf5b4a7ed1e/a14fa32031441812288c113bee953c8d/aspnetcore-runtime-5.0.10-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0db94a33-1682-4f52-b935-cb4c28c11b6b/74528bafc65548a82a9ece361d8a8262/aspnetcore-runtime-5.0.10-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1ddcc549-d626-4cda-bf0d-0b9f5571db0c/14dfffdcb7cd11f7001fccf6a4a54de2/aspnetcore-runtime-5.0.10-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/65c29806-52ef-4f27-8dc2-20fbd2275638/5ea07dd6d765f21f19caf58153a64b56/aspnetcore-runtime-5.0.10-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/a0da9621-68f0-439a-b617-4697ee0669e3/38eb4aa6e879b9f06b73599ea2e1535f/dotnet-hosting-5.0.10-win.exe

[//]: # ( SDK 5.0.207)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2248b305-b890-4bc2-9e3b-1bc7628d0263/5f48e2b546fc3027158bf7e5b7418918/dotnet-sdk-5.0.207-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31403923-a489-4de7-99ba-4b14b1e031cf/258bd1120db287c09b999b328ba7bbf8/dotnet-sdk-5.0.207-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0eccff17-5f41-47d7-86f2-49fee9c9c5f3/b4f9cc38c2c99c832f6f483b8bff2c89/dotnet-sdk-5.0.207-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d2958a9-bfd3-4888-a00e-5e9669a7c990/9712a18aecb75413e94fe4038aef0459/dotnet-sdk-5.0.207-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6dbdec94-bd15-479f-ae52-124788016198/d7ecb1085cdcfd7a22923b1903d139e8/dotnet-sdk-5.0.207-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b08708ca-f066-4f67-b645-f1f09b3bd614/0f2b95f0c1b20d12fcddce061c55f5c0/dotnet-sdk-5.0.207-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/802cdade-b981-405b-a21c-9fa840c57d0a/4e4f3091680271f7f9b663f72c2473db/dotnet-sdk-5.0.207-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d229e751-2ae5-4665-942b-8644ed361eb8/3d4ba0b91535e56d4efe95eb0c37c4fc/dotnet-sdk-5.0.207-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f6066061-eef0-4d69-820a-18375861d8e4/77b580a25a90072b03cce74db4899050/dotnet-sdk-5.0.207-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c087c3ea-25f0-47d7-85c8-984abc717b9b/a3dcf3b375339b1486c89780755aa9e5/dotnet-sdk-5.0.207-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e23c19c7-d01b-4498-b29b-f177495149e6/67e499e4aa5b754b93c0d803579b64c9/dotnet-sdk-5.0.207-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c93eccd7-15ce-4c16-9f67-5165a0646768/6b2e2425432b24d7e5d0d9f58325198e/dotnet-sdk-5.0.207-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/88854ea0-27dd-48a3-8dde-d457cceafe58/f5824da05b1f1ac843193578724798af/dotnet-sdk-5.0.207-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d8759622-7db9-455e-8c85-dcd91fbe501c/18c84a56aed541d3b2a2e2ba99e11b7f/dotnet-sdk-5.0.207-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6b127c98-8eeb-4f02-8996-25fe56dd12a6/2e3179ac063724c03235990df0808426/dotnet-sdk-5.0.207-win-x86.zip
