# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public enum Architecture {
+        Wasm = 4,
     }
+    public static class CollectionsMarshal {
+        public static Span<T> AsSpan<T>(List<T> list);
+    }
     public class ComAwareEventInfo : EventInfo {
+        public override int MetadataToken { get; }
+        public override Module Module { get; }
+        public override IList<CustomAttributeData> GetCustomAttributesData();
+        public override MethodInfo[] GetOtherMethods(bool nonPublic);
     }
+    public abstract class ComWrappers {
+        protected ComWrappers();
+        protected unsafe abstract ComWrappers.ComInterfaceEntry* ComputeVtables(object obj, CreateComInterfaceFlags flags, out int count);
+        protected abstract object CreateObject(IntPtr externalComObject, CreateObjectFlags flags);
+        protected static void GetIUnknownImpl(out IntPtr fpQueryInterface, out IntPtr fpAddRef, out IntPtr fpRelease);
+        public IntPtr GetOrCreateComInterfaceForObject(object instance, CreateComInterfaceFlags flags);
+        public object GetOrCreateObjectForComInstance(IntPtr externalComObject, CreateObjectFlags flags);
+        public object GetOrRegisterObjectForComInstance(IntPtr externalComObject, CreateObjectFlags flags, object wrapper);
+        public static void RegisterForMarshalling(ComWrappers instance);
+        public static void RegisterForTrackerSupport(ComWrappers instance);
+        protected abstract void ReleaseObjects(IEnumerable objects);
+        public struct ComInterfaceDispatch {
+            public IntPtr Vtable;
+            public unsafe static T GetInstance<T>(ComWrappers.ComInterfaceDispatch* dispatchPtr) where T : class;
+        }
+        public struct ComInterfaceEntry {
+            public Guid IID;
+            public IntPtr Vtable;
+        }
+    }
+    public enum CreateComInterfaceFlags {
+        CallerDefinedIUnknown = 1,
+        None = 0,
+        TrackerSupport = 2,
+    }
+    public enum CreateObjectFlags {
+        None = 0,
+        TrackerObject = 1,
+        UniqueInstance = 2,
+    }
+    public delegate IntPtr DllImportResolver(string libraryName, Assembly assembly, DllImportSearchPath? searchPath);
+    public sealed class DynamicInterfaceCastableImplementationAttribute : Attribute {
+        public DynamicInterfaceCastableImplementationAttribute();
+    }
+    public interface IDynamicInterfaceCastable {
+        RuntimeTypeHandle GetInterfaceImplementation(RuntimeTypeHandle interfaceType);
+        bool IsInterfaceImplemented(RuntimeTypeHandle interfaceType, bool throwIfNotImplemented);
+    }
     public static class Marshal {
+        public static int GetEndComSlot(Type t);
+        public static IntPtr GetExceptionPointers();
+        public static bool IsTypeVisibleFromCom(Type t);
     }
     public static class MemoryMarshal {
+        public static ref readonly T AsRef<T>(ReadOnlySpan<byte> span) where T : struct;
+        public static ref T AsRef<T>(Span<byte> span) where T : struct;
+        public static ref T GetArrayDataReference<T>(T[] array);
     }
+    public static class NativeLibrary {
+        public static void Free(IntPtr handle);
+        public static IntPtr GetExport(IntPtr handle, string name);
+        public static IntPtr Load(string libraryPath);
+        public static IntPtr Load(string libraryName, Assembly assembly, DllImportSearchPath? searchPath);
+        public static void SetDllImportResolver(Assembly assembly, DllImportResolver resolver);
+        public static bool TryGetExport(IntPtr handle, string name, out IntPtr address);
+        public static bool TryLoad(string libraryPath, out IntPtr handle);
+        public static bool TryLoad(string libraryName, Assembly assembly, DllImportSearchPath? searchPath, out IntPtr handle);
+    }
     public readonly struct OSPlatform : IEquatable<OSPlatform> {
+        public static OSPlatform FreeBSD { get; }
     }
     public static class RuntimeInformation {
+        public static string RuntimeIdentifier { get; }
     }
+    public class StandardOleMarshalObject : MarshalByRefObject {
+        protected StandardOleMarshalObject();
+    }
+    public sealed class SuppressGCTransitionAttribute : Attribute {
+        public SuppressGCTransitionAttribute();
+    }
+    public sealed class UnmanagedCallersOnlyAttribute : Attribute {
+        public string EntryPoint;
+        public Type[] CallConvs;
+        public UnmanagedCallersOnlyAttribute();
+    }
 }
```

