# System.Text.RegularExpressions

``` diff
 namespace System.Text.RegularExpressions {
+    public enum RegexParseError {
+        AlternationHasComment = 17,
+        AlternationHasMalformedCondition = 2,
+        AlternationHasMalformedReference = 18,
+        AlternationHasNamedCapture = 16,
+        AlternationHasTooManyConditions = 1,
+        AlternationHasUndefinedReference = 19,
+        CaptureGroupNameInvalid = 20,
+        CaptureGroupOfZero = 21,
+        ExclusionGroupNotLast = 23,
+        InsufficientClosingParentheses = 26,
+        InsufficientOpeningParentheses = 30,
+        InsufficientOrInvalidHexDigits = 8,
+        InvalidGroupingConstruct = 15,
+        InvalidUnicodePropertyEscape = 3,
+        MalformedNamedReference = 12,
+        MalformedUnicodePropertyEscape = 4,
+        MissingControlCharacter = 7,
+        NestedQuantifiersNotParenthesized = 28,
+        QuantifierAfterNothing = 29,
+        QuantifierOrCaptureGroupOutOfRange = 9,
+        ReversedCharacterRange = 24,
+        ReversedQuantifierRange = 27,
+        ShorthandClassInCharacterRange = 25,
+        UndefinedNamedReference = 10,
+        UndefinedNumberedReference = 11,
+        UnescapedEndingBackslash = 13,
+        Unknown = 0,
+        UnrecognizedControlCharacter = 6,
+        UnrecognizedEscape = 5,
+        UnrecognizedUnicodeProperty = 31,
+        UnterminatedBracket = 22,
+        UnterminatedComment = 14,
+    }
+    public sealed class RegexParseException : ArgumentException {
+        public RegexParseError Error { get; }
+        public int Offset { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
 }
```

