# Microsoft.JSInterop

``` diff
 namespace Microsoft.JSInterop {
+    public interface IJSUnmarshalledRuntime {
+        TResult InvokeUnmarshalled<T0, T1, T2, TResult>(string identifier, T0 arg0, T1 arg1, T2 arg2);
+        TResult InvokeUnmarshalled<T0, T1, TResult>(string identifier, T0 arg0, T1 arg1);
+        TResult InvokeUnmarshalled<T0, TResult>(string identifier, T0 arg0);
+        TResult InvokeUnmarshalled<TResult>(string identifier);
+    }
+    public enum JSCallResultType {
+        Default = 0,
+        JSObjectReference = 1,
+    }
+    public class JSInProcessObjectReference : JSObjectReference {
+        public TValue Invoke<TValue>(string identifier, params object[] args);
+    }
     public abstract class JSInProcessRuntime : JSRuntime, IJSInProcessRuntime, IJSRuntime {
-        protected abstract string InvokeJS(string identifier, string argsJson);
+        protected virtual string InvokeJS(string identifier, string argsJson);
+        protected abstract string InvokeJS(string identifier, string argsJson, JSCallResultType resultType, long targetInstanceId);
     }
+    public class JSObjectReference : IAsyncDisposable {
+        public ValueTask DisposeAsync();
+        public ValueTask<TValue> InvokeAsync<TValue>(string identifier, params object[] args);
+        public ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, params object[] args);
+        public ValueTask InvokeVoidAsync(string identifier, params object[] args);
+        protected void ThrowIfDisposed();
+    }
     public abstract class JSRuntime : IJSRuntime {
-        protected abstract void BeginInvokeJS(long taskId, string identifier, string argsJson);
+        protected virtual void BeginInvokeJS(long taskId, string identifier, string argsJson);
+        protected abstract void BeginInvokeJS(long taskId, string identifier, string argsJson, JSCallResultType resultType, long targetInstanceId);
+        protected static JSCallResultType ResultTypeFromGeneric<TResult>();
     }
 }
```

