# .NET 6.0.10 - October 11, 2022

The .NET 6.0.10, [.NET SDK 6.0.110](6.0.110.md), and [.NET SDK 6.0.305](6.0.305.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.402
```

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Notable Changes
.NET 6.0.10 release carries security and non-security fixes.

# Microsoft Security Advisory CVE-2022-41032 | .NET Elevation of Privilege Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET Core 3.1, and NuGet (NuGet.exe, NuGet.Commands, NuGet.CommandLine, NuGet.Protocol). This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET Core 3.1, and NuGet clients (NuGet.exe, NuGet.Commands, NuGet.CommandLine, NuGet.Protocol) where a malicious actor could cause a user to execute arbitrary code.

### Additional fixes in this release

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.10+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7864](https://github.com/dotnet/core/issues/7864) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.10/6.0.10.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.10-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.10-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/october-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.10
Microsoft.WindowsDesktop.App.Ref| 6.0.10
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.10
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.10
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.10
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.10
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.10
Microsoft.NETCore.App.Host.linux-arm64| 6.0.10
Microsoft.NETCore.App.Host.linux-arm| 6.0.10
Microsoft.NETCore.App.Host.win-x64| 6.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.10
Microsoft.NETCore.App.Composite| 6.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.10
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86| 6.0.10
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.10
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.10
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.10
Microsoft.NETCore.App.Host.osx-arm64| 6.0.10
Microsoft.NETCore.App.Host.win-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.10
Microsoft.Extensions.Hosting.WindowsServices| 6.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400| 6.0.10
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.10
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.10
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.10
Microsoft.NETCore.App.Host.win-x86| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.10
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.win-x64| 6.0.10
Microsoft.Extensions.DependencyInjection| 6.0.1
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.10
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.10
Microsoft.NETCore.App.Ref| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 6.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64| 6.0.10
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64| 6.0.10
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.10
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.10
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.10
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.10
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 6.0.10
Microsoft.NETCore.DotNetHostPolicy| 6.0.10
Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 6.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.10
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.10
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 6.0.10
Microsoft.NETCore.DotNetHost| 6.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.10
Microsoft.NETCore.App.Host.linux-x64| 6.0.10
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.10
Microsoft.NETCore.App.Host.osx-x64| 6.0.10
Microsoft.NETCore.App.Host.win-arm| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.10
Microsoft.NETCore.App.Runtime.win-arm| 6.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 6.0.10
Microsoft.NETCore.Platforms| 6.0.6
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.10
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.10
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 6.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 6.0.10
Microsoft.NETCore.App.Runtime.win-x86| 6.0.10
Microsoft.NETCore.DotNetAppHost| 6.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.10
Microsoft.AspNetCore.App.Ref| 6.0.10
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.10
Microsoft.AspNetCore.Components.WebAssembly| 6.0.10
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.10
Microsoft.AspNetCore.DataProtection| 6.0.10
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.10
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.10
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.10
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.10
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.10
Microsoft.AspNetCore.HeaderPropagation| 6.0.10
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.10
Microsoft.AspNetCore.Identity.UI| 6.0.10
Microsoft.AspNetCore.Http.Connections.Client| 6.0.10
Microsoft.AspNetCore.Http.Connections.Common| 6.0.10
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.10
Microsoft.AspNetCore.JsonPatch| 6.0.10
Microsoft.AspNetCore.Metadata| 6.0.10
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.10
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.10
Microsoft.AspNetCore.Razor.Language| 6.0.10
Microsoft.AspNetCore.SignalR.Client| 6.0.10
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.10
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.10
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.10
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.10
Microsoft.AspNetCore.SpaProxy| 6.0.10
Microsoft.Authentication.WebAssembly.Msal| 6.0.10
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.10
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.10
Microsoft.Extensions.ApiDescription.Client| 6.0.10
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.10
Microsoft.Extensions.WebEncoders| 6.0.10
Microsoft.JSInterop| 6.0.10
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.10
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.10
Microsoft.AspNetCore.Owin| 6.0.10
Microsoft.AspNetCore.Mvc.Testing| 6.0.10
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.10
AspNetCoreRuntime.6.0.x64| 6.0.10
AspNetCoreRuntime.6.0.x86| 6.0.10
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.10
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.10
Microsoft.AspNetCore.Authentication.Certificate| 6.0.10
Microsoft.AspNetCore.Authentication.Google| 6.0.10
Microsoft.AspNetCore.Authentication.Facebook| 6.0.10
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.10
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.10
Microsoft.AspNetCore.Components.Analyzers| 6.0.10
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.10
Microsoft.AspNetCore.Components.Forms| 6.0.10
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.10
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.10
dotnet-sql-cache| 6.0.10
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.10
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.10
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.10
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.10
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.10
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.10
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.10
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.10
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.10
Microsoft.AspNetCore.Authentication.Twitter| 6.0.10
Microsoft.AspNetCore.Authorization| 6.0.10
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.10
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.10
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.10
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.10
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.10
Microsoft.AspNetCore.SignalR.Common| 6.0.10
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.10
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.10
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.10
Microsoft.Extensions.FileProviders.Embedded| 6.0.10
Microsoft.Extensions.Identity.Stores| 6.0.10
Microsoft.JSInterop.WebAssembly| 6.0.10
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.10
Microsoft.AspNetCore.TestHost| 6.0.10
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.10
Microsoft.dotnet-openapi| 6.0.10
Microsoft.CodeAnalysis.Razor| 6.0.10
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.10
Microsoft.Extensions.Features| 6.0.10
Microsoft.Extensions.Caching.SqlServer| 6.0.10
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.10
Microsoft.Extensions.Identity.Core| 6.0.10
Microsoft.Extensions.Localization| 6.0.10
Microsoft.Extensions.Http.Polly| 6.0.10
Microsoft.Extensions.ObjectPool| 6.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.10
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.10
Microsoft.AspNetCore.Components| 6.0.10
Microsoft.AspNetCore.Components.Authorization| 6.0.10
Microsoft.AspNetCore.Components.Web| 6.0.10
Microsoft.AspNetCore.Connections.Abstractions| 6.0.10
Microsoft.AspNetCore.Components.WebView| 6.0.10
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.10
Microsoft.AspNetCore.Cryptography.Internal| 6.0.10
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.10
Microsoft.Extensions.ApiDescription.Server| 6.0.10
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.10
Microsoft.Extensions.Localization.Abstractions| 6.0.10
Microsoft.Extensions.Logging.AzureAppServices| 6.0.10
Microsoft.TemplateEngine.Abstractions| 6.0.110
Microsoft.TemplateEngine.Core| 6.0.110
Microsoft.TemplateEngine.IDE| 6.0.110
Microsoft.TemplateEngine.Core.Contracts| 6.0.110
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.110
Microsoft.TemplateEngine.Utils| 6.0.110
Microsoft.TemplateEngine.Edge| 6.0.110
Microsoft.DotNet.Common.ItemTemplates| 6.0.110
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.110
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.110
Microsoft.TemplateSearch.Common| 6.0.110
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.110
nupkgs\sdk\packages\Microsoft.DotNet.Compatibility| 1.0.0-servicing.22476.46
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400| 6.0.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64| 6.0.10
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64| 6.0.10
Microsoft.EntityFrameworkCore| 6.0.10
dotnet-ef| 6.0.10
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.10
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.10
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.10
Microsoft.EntityFrameworkCore.Relational| 6.0.10
Microsoft.EntityFrameworkCore.Proxies| 6.0.10
Microsoft.EntityFrameworkCore.Sqlite| 6.0.10
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.10
Microsoft.EntityFrameworkCore.SqlServer| 6.0.10
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.10
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.10
Microsoft.EntityFrameworkCore.Tools| 6.0.10
Microsoft.Data.Sqlite| 6.0.10
Microsoft.Data.Sqlite.Core| 6.0.10
Microsoft.EntityFrameworkCore.Abstractions| 6.0.10
Microsoft.EntityFrameworkCore.Analyzers| 6.0.10
Microsoft.EntityFrameworkCore.Design| 6.0.10
Microsoft.EntityFrameworkCore.InMemory| 6.0.10
Microsoft.EntityFrameworkCore.Cosmos| 6.0.10
Microsoft.TemplateEngine.IDE| 6.0.305
Microsoft.TemplateEngine.Core.Contracts| 6.0.305
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.305
Microsoft.TemplateEngine.Utils| 6.0.305
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.305
Microsoft.TemplateEngine.Abstractions| 6.0.305
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.305
Microsoft.TemplateEngine.Core| 6.0.305
Microsoft.TemplateEngine.Edge| 6.0.305
Microsoft.TemplateSearch.Common| 6.0.305
Microsoft.DotNet.Common.ItemTemplates| 6.0.305
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.305
Microsoft.DotNet.Common.ProjectTemplates.2.0| 6.0.402
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.402
Microsoft.TemplateEngine.IDE| 6.0.402
Microsoft.TemplateEngine.Core| 6.0.402
Microsoft.TemplateEngine.Core.Contracts| 6.0.402
Microsoft.TemplateEngine.Edge| 6.0.402
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.402
Microsoft.TemplateSearch.Common| 6.0.402
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.402
Microsoft.DotNet.Common.ItemTemplates| 6.0.402
Microsoft.DotNet.Common.ProjectTemplates.1.x| 6.0.402
Microsoft.DotNet.Common.ProjectTemplates.2.1| 6.0.402
Microsoft.DotNet.Common.ProjectTemplates.2.2| 6.0.402
Microsoft.DotNet.Common.ProjectTemplates.3.0| 6.0.402
Microsoft.DotNet.Common.ProjectTemplates.3.1| 6.0.402
Microsoft.TemplateEngine.Abstractions| 6.0.402
Microsoft.DotNet.Common.ProjectTemplates.5.0| 6.0.402
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.402
Microsoft.TemplateEngine.Utils| 6.0.402



[//]: # ( Runtime 6.0.10)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b760400-58d8-4b6a-a44e-6d4468041136/3d3f29fa7154c975f1e558f0ce7f34a2/dotnet-runtime-6.0.10-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/21bc0b9c-669f-4d59-9e6b-d16d1917afc0/fd3fce1337cef07b2e3763d754becb05/dotnet-runtime-6.0.10-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2fcd51d-b4b5-4b18-9781-03725e0f8698/319cf1066c7b16c177364c2b3b8e34dc/dotnet-runtime-6.0.10-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/503f71f3-de50-42ee-b57e-6a657a311729/f2e94dd72400ed84fec1b325ac7c362f/dotnet-runtime-6.0.10-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0962aa41-5e26-4382-94bb-9bf15faf146e/8968881c7f465e73626235470b0faf6c/dotnet-runtime-6.0.10-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48fbc600-8228-424e-aaed-52b7e601c277/c493b8ac4629341f1e5acc4ff515fead/dotnet-runtime-6.0.10-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6afedb21-384c-4110-9856-189c169b231f/843a9a27982eaf00b0bb8ed5a9626401/dotnet-runtime-6.0.10-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f48a8f09-4b5a-40b4-ac4d-197d6ac53038/3cdc2003e07ccf4b22e9bf9a0313a5dc/dotnet-runtime-6.0.10-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1cf60908-695c-4d98-a502-47ba21c9f9bf/8163b98d2c2a4f725af448adbe1047a7/dotnet-runtime-6.0.10-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f088e65a-26aa-4da3-a3e5-b4e7e419add8/79a7a79a56eeb08b0646f34952a00091/dotnet-runtime-6.0.10-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1d61e401-55e3-498f-aa6a-de0a29ef2d8d/39d3d5ff136e14a6cc3621b4d8202495/dotnet-runtime-6.0.10-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f3ca8276-8a53-4c46-9486-bbdf32ea8481/114a1049ce0f1efab0b59663ccfc34ed/dotnet-runtime-6.0.10-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/50336bc7-7fd1-4a12-b5a2-81ce0219edf9/8d862413975808de0d835888e41e49a7/dotnet-runtime-6.0.10-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e764b48d-970f-41b5-a23b-c0f78a42fa03/16c9c1d0e5d168c6acbdfc1236f635b8/dotnet-runtime-6.0.10-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/aaf0e61e-c5f6-4ead-9324-d0ff07e4c3de/677f360ffac9ba1b7a062cf4e5265ca7/dotnet-runtime-6.0.10-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7e7a6898-148f-4524-bfb5-a846049c7b6f/1e0c24eb4228adbe9b446dda64957bc4/dotnet-runtime-6.0.10-win-x86.zip

[//]: # ( WindowsDesktop 6.0.10)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b05a38ca-a434-473c-b031-07f05c75487e/0dfe9108f47050d81f1bc09002de6881/windowsdesktop-runtime-6.0.10-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/cbab112c-20d1-4526-9811-50be6530a6dc/1fd204150641afde14110d19789da47d/windowsdesktop-runtime-6.0.10-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a6e878eb-d1da-40cb-8b6a-7f5b9390f09c/e4431ce2aa28b6c9956db672209be500/windowsdesktop-runtime-6.0.10-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5a9d799c-5675-4aa6-a752-67123531478d/a973751190ea104b3a710191208e66b9/windowsdesktop-runtime-6.0.10-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6f8cf899-4800-400e-a196-867e7593c8e4/351213f8ae397c30efcfbb78fb10def2/windowsdesktop-runtime-6.0.10-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1b88711d-3354-4863-ba5e-0ccccec7e81c/036f96959c5855ee9ef0d73763595d3e/windowsdesktop-runtime-6.0.10-win-x86.zip

[//]: # ( ASP 6.0.10)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eb049d47-1cd1-4a76-8b4c-3efee9890f2a/53441bce40b9ac8d073fb4742d823c3b/aspnetcore-runtime-6.0.10-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c37e7250-886d-47e1-840e-fc0ae2aad195/81f019f66f158b7ccb3511d2fa5dec53/aspnetcore-runtime-6.0.10-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9d1c5701-2a62-44d2-8fa0-908a94913df6/ec6c9c40cd2bad036248660511310d71/aspnetcore-runtime-6.0.10-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/14ba166b-6dde-4a9c-85d4-e4294fb4f676/8c2476c039a628a7f573bb2b257ccd84/aspnetcore-runtime-6.0.10-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb38e333-d733-448a-b7e9-7020b720d0e3/9cbdb02e1e42bacc02479312ef8afd09/aspnetcore-runtime-6.0.10-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d44ddeb-ad35-41a8-a581-03b151afbd80/6888586c28836b1e1f71df879184550b/aspnetcore-runtime-6.0.10-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49c2a919-5162-4314-9010-a8da201e965e/f346ee2fc7ff046045edcca0778c625c/aspnetcore-runtime-6.0.10-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38af6f1b-7b6b-40dc-8f0c-1f2025bea76e/795b0e4dff571fc01702d9cfbad359c0/aspnetcore-runtime-6.0.10-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/4ce27377-7db7-486d-bd0d-d83906c8c14b/3ee001cc96bd654db502109ef6a97a2d/aspnetcore-runtime-6.0.10-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2370bcad-45b1-4ccb-bc61-21ffd7116d63/1aa8efcabfb60ee778b913a5eb237a56/aspnetcore-runtime-6.0.10-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a3892a55-5630-4dbf-81ff-17f08fb0632b/f55b436dad325fe8b41f67fcb80e1366/aspnetcore-runtime-6.0.10-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/16a50311-71a0-49c2-bfdc-2ed11ade7043/b7ee5cb05411fc03931b6ec9d6c63e87/aspnetcore-runtime-6.0.10-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9f84c767-7d96-4b86-befb-0dc436636140/23840bbf8abc9690dbefa96162f704de/aspnetcore-runtime-6.0.10-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/870aa66a-733e-45fa-aecb-27aaec423f40/833d0387587b9fb35e47e75f2cfe0288/dotnet-hosting-6.0.10-win.exe

[//]: # ( SDK 6.0.402)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7be1dda3-3412-4f9a-88f2-e6a8e5f118ff/7bd57a63288994da06e7a1b9a4e407e3/dotnet-sdk-6.0.402-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/234daf6a-5e12-4fa3-a73b-b12db44a3154/df7c012e5e4e2cc510de9226425dad88/dotnet-sdk-6.0.402-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6720784d-4581-4d8b-8443-04dc6fb1c2cb/2aa8b8958b3835fc3665fe879e612cf5/dotnet-sdk-6.0.402-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/24851c21-6942-46e3-8da8-c6d00df1ddb1/13ae9d1dcdd94895372b441ee7763440/dotnet-sdk-6.0.402-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb184637-dd94-484d-9fb2-5a736147e906/4a6bf66940155ab1db6286f342eca954/dotnet-sdk-6.0.402-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3e46476-4494-41b7-a628-c517794c5a6a/6066215f6c0a18b070e8e6e8b715de0b/dotnet-sdk-6.0.402-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1816a0af-0621-4608-b21a-9852ce83d788/04675dad54b50d6778db98f226f1b944/dotnet-sdk-6.0.402-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8857cf39-5c46-413c-875b-e091f4b00c9b/19f79f518af3e91ddce328db7f4e1910/dotnet-sdk-6.0.402-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f55a179b-7084-41b9-98e3-408a3c317158/5445f9e747fa29ce0be3240017d28322/dotnet-sdk-6.0.402-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2601dfcb-7d2f-4186-9a08-d121e63a06dd/cd89903b769b1d6e3bdc1e7cd5fcc19a/dotnet-sdk-6.0.402-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/5618f67c-ec7c-4610-9262-94fa8a723e4e/985b6ce4df32ae34cba00c1f674c1739/dotnet-sdk-6.0.402-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0c9b7a5d-2b83-4cf3-ba20-94a26d1bd61f/995c6f046868e52b4e6ad120f2606963/dotnet-sdk-6.0.402-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9f4d3331-ff2a-4415-ab5d-eafc9c4f09ee/1922162c9ed35d6c10160f46c26127d6/dotnet-sdk-6.0.402-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/554fb42f-36ae-4f2f-b7e1-6b447ebb1867/a512568a4574fc3494b73c187a5316d8/dotnet-sdk-6.0.402-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/12c673aa-5f3a-4183-9cbb-d42bf5b76a6d/2391e030a526f52f51d4d2bdb4cf9bef/dotnet-sdk-6.0.402-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d8acba56-9bae-4e67-bd33-b98df3f3600b/9f656456ea9f145e67b4322c1bccb15a/dotnet-sdk-6.0.402-win-x86.zip