# .NET 6.0.200 SDK - February 15, 2022

The .NET 6.0.200 SDK release is available for download. This SDK includes the previously released .NET 6.0.2 Runtime and is in support of Visual Studio 17.1 GA release. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.200
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.




## Visual Studio Compatibility

You need [Visual Studio 17.1 GA](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.2/6.0.200-sdk.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.2-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.2.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.2.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.2.nupkg
Microsoft.WindowsDesktop.App.Ref | 6.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Ref | 6.0.2.nupkg
Microsoft.Extensions.Caching.Memory | 6.0.1.nupkg
Microsoft.NETCore.App.Composite | 6.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 6.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.2.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.2.nupkg
System.IO.Pipelines | 6.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
System.DirectoryServices.Protocols | 6.0.1.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.2.nupkg
Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.2.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.2.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.2.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.2.nupkg
System.Text.Json | 6.0.2.nupkg
System.Runtime.Experimental | 6.0.1.nupkg
System.IO.Hashing | 6.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.win-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.win-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.win-x86 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.2.nupkg
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.2.nupkg
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.2.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 6.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.2.nupkg
Microsoft.Extensions.Hosting | 6.0.1.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.2.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.2.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.2.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.2.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 6.0.1.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.2.nupkg
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.2.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 6.0.2.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.2.nupkg
AspNetCoreRuntime.6.0.x64 | 6.0.2.nupkg
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.2.nupkg
Microsoft.AspNetCore.SpaProxy | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.2.nupkg
dotnet-sql-cache | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Google | 6.0.2.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.2.nupkg
Microsoft.AspNetCore.TestHost | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.2.nupkg
Microsoft.Extensions.ApiDescription.Client | 6.0.2.nupkg
Microsoft.Extensions.Caching.SqlServer | 6.0.2.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.2.nupkg
Microsoft.Extensions.FileProviders.Embedded | 6.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.2.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.2.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 6.0.2.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.2.nupkg
Microsoft.AspNetCore.Components.Forms | 6.0.2.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.2.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.2.nupkg
Microsoft.AspNetCore.Owin | 6.0.2.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.2.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.2.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Ref | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.2.nupkg
Microsoft.JSInterop.WebAssembly | 6.0.2.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 6.0.2.nupkg
Microsoft.Extensions.Localization | 6.0.2.nupkg
Microsoft.Extensions.Identity.Core | 6.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.AspNetCore.Mvc.Testing | 6.0.2.nupkg
Microsoft.AspNetCore.Identity.UI | 6.0.2.nupkg
Microsoft.dotnet-openapi | 6.0.2.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.AspNetCore.Metadata | 6.0.2.nupkg
Microsoft.AspNetCore.HeaderPropagation | 6.0.2.nupkg
Microsoft.AspNetCore.JsonPatch | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.2.nupkg
Microsoft.JSInterop | 6.0.2.nupkg
Microsoft.Extensions.Identity.Stores | 6.0.2.nupkg
Microsoft.Extensions.Features | 6.0.2.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection | 6.0.2.nupkg
Microsoft.AspNetCore.Components.Analyzers | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.2.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.2.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.2.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.2.nupkg
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.2.nupkg
Microsoft.Authentication.WebAssembly.Msal | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Common | 6.0.2.nupkg
Microsoft.Extensions.ApiDescription.Server | 6.0.2.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebView | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.2.nupkg
Microsoft.AspNetCore.Components.Web | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 6.0.2.nupkg
Microsoft.AspNetCore.Components.Authorization | 6.0.2.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.2.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.2.nupkg
AspNetCoreRuntime.6.0.x86 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.2.nupkg
Microsoft.CodeAnalysis.Razor | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Client | 6.0.2.nupkg
Microsoft.Extensions.WebEncoders | 6.0.2.nupkg
Microsoft.Extensions.ObjectPool | 6.0.2.nupkg
Microsoft.Extensions.Http.Polly | 6.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.2.nupkg
Microsoft.AspNetCore.Razor.Language | 6.0.2.nupkg
Microsoft.Extensions.Localization.Abstractions | 6.0.2.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.2.nupkg
Microsoft.AspNetCore.Components | 6.0.2.nupkg
Microsoft.AspNetCore.Authorization | 6.0.2.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 6.0.2.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.2.nupkg
Microsoft.TemplateSearch.Common | 6.0.200.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.200.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.200.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.200.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.200.nupkg
Microsoft.DotNet.Common.ItemTemplates | 6.0.200.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.200.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.200.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.200.nupkg
Microsoft.TemplateEngine.Core.Contracts | 6.0.200.nupkg
Microsoft.TemplateEngine.IDE | 6.0.200.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.200.nupkg
Microsoft.TemplateEngine.Core | 6.0.200.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.200.nupkg
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.200.nupkg
Microsoft.TemplateEngine.Utils | 6.0.200.nupkg
Microsoft.TemplateEngine.Abstractions | 6.0.200.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.200.nupkg
Microsoft.TemplateEngine.Edge | 6.0.200.nupkg
Microsoft.DotNet.Compatibility | 1.0.0-rtm.22104.9.nupkg
Microsoft.Data.Sqlite | 6.0.2.nupkg
Microsoft.Data.Sqlite.Core | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.2.nupkg
dotnet-ef | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.InMemory | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Tools | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Design | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Proxies | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.2.nupkg
Microsoft.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Relational | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 6.0.2.nupkg




[//]: # ( Runtime 6.0.2)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c34904d-88e8-4dc1-af91-fc1e5cb64a25/6ae9f205eb54fdd03e12e04daa43c015/dotnet-runtime-6.0.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b952787-51c7-4708-b20b-a1f59423f1a2/65151b3e18d451fa1303606e402c17fe/dotnet-runtime-6.0.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8359981a-8ad7-4925-b5c7-b8e59ca01cbc/439b7b835ce333d234fb20d9191c6ec6/dotnet-runtime-6.0.2-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9b71f19d-e9d7-463e-8a37-8b2ef071a024/59a777de384a922720292cbb9c91da85/dotnet-runtime-6.0.2-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/327699d6-13f5-4ce5-91ec-c34b7bb505ed/9faa5cf0b173a8878ab7f0d013591079/dotnet-runtime-6.0.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28029b9e-2851-4224-b781-13f2bfa8b975/4a3d5684cb104f6efdaef10d7978872e/dotnet-runtime-6.0.2-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0d80c9b0-764f-4a13-8858-bc51e7b54b8f/7980e983431cfbbc0b28fb85f7770034/dotnet-runtime-6.0.2-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75f9bc5a-ff02-4dd3-8d28-ed4cd672f796/ab73e4ab6e6ec6ab608c2d68cea90f8b/dotnet-runtime-6.0.2-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/26c9c72e-65be-4241-b048-11858350afb3/0dc4dee2b444eb7b0e8120a76fd69b09/dotnet-runtime-6.0.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5857b1e-9348-49c0-b35c-1aabde6ca28b/bd56e9c2fb52ae4fb551e22dae22a70e/dotnet-runtime-6.0.2-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/17878f6d-e10b-4354-baa9-53ad551f4195/dc5651cb5042bed7accaaf6401917427/dotnet-runtime-6.0.2-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3db8a9fe-0c34-49d1-8c8d-d6c7e8f24d79/e92448c495378cb16e34b1e17fd697c9/dotnet-runtime-6.0.2-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f3eaf689-f89a-40d0-9779-8c536dd9d2dc/924fd88b9c8d3622cb61112057c9ef47/dotnet-runtime-6.0.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/aaab1000-2966-4318-9f86-8e8fa477ba59/bcaa668377efa18ca2acf1eba59cf5c5/dotnet-runtime-6.0.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6add78f3-d0af-45d3-914d-f7652af94f76/e5837b6913591ca973fe9674c74e69d6/dotnet-runtime-6.0.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d597d35c-9c80-4419-862e-5fa5c2b9af47/8b64cd5651b15c3bdaafe8efb98f15c6/dotnet-runtime-6.0.2-win-x86.zip

[//]: # ( WindowsDesktop 6.0.2)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1ab1a9fa-5aab-4487-9048-0daaf74c90f8/e23a567db4880fce75c467d3e9f72b92/windowsdesktop-runtime-6.0.2-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/efa32b7a-6eec-4d97-9cdc-c7336a29a749/3df4296170397cf60884dae1be3d103b/windowsdesktop-runtime-6.0.2-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/72ebbe8e-5175-41da-9046-1890732e0d5a/675ce08d0c1740142305d35692a8685b/windowsdesktop-runtime-6.0.2-win-x86.exe

[//]: # ( ASP 6.0.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93874c40-bd2d-4a7d-bbb5-716b161594c0/f698334222759b065f5da4e8915ae982/aspnetcore-runtime-6.0.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d30e9e2e-10a5-46c6-9b81-1a6a965d6739/6f56a3893b16fa841c8cb34ec9b3768d/aspnetcore-runtime-6.0.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93e36917-22d8-49a2-8cf3-a5b8f0f8c31e/5b288b6551f81c5941cd6499e60d380f/aspnetcore-runtime-6.0.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33d70e2d-0f10-4d10-bed1-42a9e1269909/2d89b3621cd1997f007041f113360a43/aspnetcore-runtime-6.0.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f4a8b7d-290b-4d23-b8bb-2d88d24804ae/859f1334b58fb1316cca9e3b48abbef0/aspnetcore-runtime-6.0.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2611908d-446f-45ec-be23-57feaf859d7e/90bb871b0097b874c6de0b1a1b629c31/aspnetcore-runtime-6.0.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a08d7f17-8bd1-4de7-939a-8c1b6481b404/4ffe5dc82e1ffc276d111bbda4862ab0/aspnetcore-runtime-6.0.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91564a6e-acab-4e4b-8e1e-1e3b69b84820/a266d8d92db6dcfb9597a0822b5834bc/aspnetcore-runtime-6.0.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1de37632-a8fb-4ad6-814c-64e94ab0cd1a/8d5ace0c1cc5d662da0a98aa0119d0d2/aspnetcore-runtime-6.0.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f9c340ac-df04-4690-a434-111f9558941c/568ed66a3e32b22e3645a99e100008fe/aspnetcore-runtime-6.0.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/66c9a22a-9a6d-483c-bda6-9c63d960661c/6f0f400650f24b70404cde0c60079303/aspnetcore-runtime-6.0.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3fbcf485-c48e-49a3-87da-62114c084ede/6b8d31d2fc68e9d30889a17ef8da875b/aspnetcore-runtime-6.0.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c2d62404-5e1d-46ab-ba6a-b9f583c9e4e7/915d47950157a6f53c42114d2e22dd4e/aspnetcore-runtime-6.0.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/bff26878-9597-4390-a4ef-5bd818ba41a0/a7a8114362771690ec52e6fd09236ab8/dotnet-hosting-6.0.2-win.exe

[//]: # ( SDK 6.0.200)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4cfcfa53-f421-4257-8cd2-d4078f9ffe90/008804a5475fa0d46b9e8f03cb78bfcd/dotnet-sdk-6.0.200-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad60a07c-d4f0-4225-9154-c3a2ec0f34cf/a588cd2b94db2214f6e5dcd02c4aa37a/dotnet-sdk-6.0.200-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3215059-1ab0-4a63-9a2d-be03507e4404/b100a8983e180b498beaea4ba0789242/dotnet-sdk-6.0.200-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20a01abf-79fd-48a2-86c7-12f29e406184/8376d18bc9a3f93712ce88af4fe9066a/dotnet-sdk-6.0.200-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b45778ca-3f41-4d94-b111-0e6298f064cc/c211315989b13b44b4619ee686e56b87/dotnet-sdk-6.0.200-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/807f9d72-4940-4b1a-aa4a-8dbb0f73f5d7/cb666c22a87bf9413f29615e0ba94500/dotnet-sdk-6.0.200-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ba037891-7f55-4f23-9997-92c1b642117b/a643faacd4700bb4565eb83fb11b3293/dotnet-sdk-6.0.200-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6deb083b-8fd4-4e8a-a0b3-54dba024c54b/b34dbaf7464b62d809e2d1ad6303bc15/dotnet-sdk-6.0.200-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0f1f23eb-004f-41a2-a4ef-e1a9b533a794/f2d47f0ed6a7be2027166ea1132cc806/dotnet-sdk-6.0.200-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d49659e-636e-4b16-8906-329dd47ba5f5/996a40a6eb3d2644770627a15d2a0492/dotnet-sdk-6.0.200-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/68529d3d-cd30-4f79-a967-d4aec65fcd03/0ef16719cff7016bbd464bfbad4455fd/dotnet-sdk-6.0.200-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8563e4a9-cc8d-4fc1-a81f-49358b0fa94d/c0fbf99f7bf54117d1b997c3a1f028e6/dotnet-sdk-6.0.200-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/89f0ba2a-5879-417b-ba1d-debbb2bde208/b22a9e9e4d513e4d409d2222315d536b/dotnet-sdk-6.0.200-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0cb33e31-4c3e-470f-bd40-ca582f583229/15c909eb3a9d20421771cab233af8cc1/dotnet-sdk-6.0.200-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a3e3a0a4-1eca-442b-8745-f6f6e1ace489/a2e866259154c9f094e4b3779ac15fc4/dotnet-sdk-6.0.200-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/09cd5210-c171-417f-b932-63cb47cb75b5/a93c8d2ca444a68bc50bfa5ad6df694d/dotnet-sdk-6.0.200-win-x86.zip
