# .NET 6.0.5 - May 10, 2022

The .NET 6.0.5, .NET 6.0.203 SDK, [.NET SDK 6.0.105](6.0.105.md) and [.NET SDK 6.0.300](6.0.300.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.203
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Windows SDK Updates

.NET SDK versions 6.0.105, 6.0.203, and 6.0.300 include performance improvements and bug fixes to the Windows SDK packages that provide access to Windows Runtime APIs. For more details see the [C#/WinRT 1.6.3 release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.6.3.220428.1).

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Notable Changes
.NET 6.0.5 release carries security fixes.

# Microsoft Security Advisory CVE-2022-29117 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can manipulate cookies and cause a Denial of Service.

# Microsoft Security Advisory CVE-2022-29145 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can cause a denial of service when HTML forms are parsed.

# Microsoft Security Advisory CVE-2022-23267 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can cause a Denial of Service via excess memory allocations through HttpClient.

In .NET 6.0.4 the existing ASP.NET Core targeting pack RPM filename was updated:
* Old: aspnetcore-targeting-pack-[version].rpm 
* New: aspnetcore-targeting-pack-[version]-x64.rpm

### Additional fixes in this release

* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.5+is%3Aclosed+label%3AServicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.5+is%3Aclosed+label%3Aservicing-approved+)
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A6.0.5+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7447](https://github.com/dotnet/core/issues/7447) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.5/6.0.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.5-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/may-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.5.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.5.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.5.nupkg
Microsoft.WindowsDesktop.App.Ref| 6.0.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 6.0.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Host.win-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.5.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.5.nupkg
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.5.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.5.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.5.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.arm64| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
System.Text.Json| 6.0.4.nupkg
System.IO.Pipelines| 6.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Host.linux-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Host.win-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Ref| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
Microsoft.NETCore.App.Host.win-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.5.nupkg
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.5.nupkg
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
Microsoft.NETCore.App.Host.osx-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Host.linux-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.5.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Host.win-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.5.nupkg
Microsoft.NETCore.App.Composite| 6.0.5.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.5.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.5.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.5.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.5.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x86| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200| 6.0.5.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.5.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.5.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.5.nupkg
System.Security.Cryptography.Pkcs| 6.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.5.nupkg
Microsoft.NETCore.App.Host.osx-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.5.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.5.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.5.nupkg
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.5.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.5.nupkg
Microsoft.AspNetCore.SignalR.Client| 6.0.5.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.5.nupkg
Microsoft.AspNetCore.App.Ref| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.5.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.5.nupkg
AspNetCoreRuntime.6.0.x64| 6.0.5.nupkg
Microsoft.AspNetCore.SpaProxy| 6.0.5.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.5.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 6.0.5.nupkg
Microsoft.AspNetCore.Components.Web| 6.0.5.nupkg
Microsoft.AspNetCore.Components.WebAssembly| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.Google| 6.0.5.nupkg
Microsoft.AspNetCore.Components.Analyzers| 6.0.5.nupkg
Microsoft.AspNetCore.Authorization| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.5.nupkg
Microsoft.JSInterop| 6.0.5.nupkg
Microsoft.Extensions.Localization.Abstractions| 6.0.5.nupkg
Microsoft.Extensions.Localization| 6.0.5.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 6.0.5.nupkg
Microsoft.Extensions.FileProviders.Embedded| 6.0.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.5.nupkg
Microsoft.AspNetCore.Mvc.Testing| 6.0.5.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 6.0.5.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.5.nupkg
Microsoft.AspNetCore.HeaderPropagation| 6.0.5.nupkg
Microsoft.Extensions.Caching.SqlServer| 6.0.5.nupkg
Microsoft.Extensions.ApiDescription.Client| 6.0.5.nupkg
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.5.nupkg
Microsoft.AspNetCore.TestHost| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.5.nupkg
Microsoft.AspNetCore.Components.Forms| 6.0.5.nupkg
Microsoft.AspNetCore.Components.Authorization| 6.0.5.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.5.nupkg
Microsoft.AspNetCore.Components| 6.0.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.5.nupkg
Microsoft.Extensions.ObjectPool| 6.0.5.nupkg
Microsoft.Extensions.Identity.Stores| 6.0.5.nupkg
Microsoft.Extensions.Features| 6.0.5.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.5.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.5.nupkg
Microsoft.AspNetCore.JsonPatch| 6.0.5.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.5.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.5.nupkg
Microsoft.AspNetCore.Razor.Language| 6.0.5.nupkg
Microsoft.Extensions.ApiDescription.Server| 6.0.5.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates| 6.0| 6.0.5.nupkg
Microsoft.CodeAnalysis.Razor| 6.0.5.nupkg
Microsoft.Authentication.WebAssembly.Msal| 6.0.5.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.5.nupkg
AspNetCoreRuntime| 6.0.x86| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.5.nupkg
dotnet-sql-cache| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.5.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 6.0.5.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.5.nupkg
Microsoft.AspNetCore.Components.WebView| 6.0.5.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 6.0.5.nupkg
Microsoft.Extensions.Http.Polly| 6.0.5.nupkg
Microsoft.JSInterop.WebAssembly| 6.0.5.nupkg
Microsoft.AspNetCore.Owin| 6.0.5.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.5.nupkg
Microsoft.AspNetCore.Identity.UI| 6.0.5.nupkg
Microsoft.AspNetCore.Metadata| 6.0.5.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.5.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 6.0.5.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.5.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.5.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.5.nupkg
Microsoft.dotnet-openapi| 6.0.5.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.5.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.5.nupkg
Microsoft.AspNetCore.DataProtection| 6.0.5.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.5.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 6.0.5.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.5.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.5.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.5.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.5.nupkg
Microsoft.AspNetCore.SignalR.Common| 6.0.5.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.5.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.5.nupkg
Microsoft.Extensions.WebEncoders| 6.0.5.nupkg
Microsoft.Extensions.Identity.Core| 6.0.5.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.105.nupkg
Microsoft.TemplateEngine.Utils| 6.0.105.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.105.nupkg
Microsoft.TemplateEngine.Core| 6.0.105.nupkg
Microsoft.TemplateEngine.Edge| 6.0.105.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.105.nupkg
Microsoft.TemplateEngine.IDE| 6.0.105.nupkg
Microsoft.TemplateSearch.Common| 6.0.105.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.105.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.105.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.105.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.105.nupkg
Microsoft.DotNet.Compatibility| 1.0.0-servicing.22221.11.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.5.nupkg
Microsoft.Data.Sqlite| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Relational| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.InMemory| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Tools| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Design| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Proxies| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 6.0.5.nupkg
Microsoft.EntityFrameworkCore| 6.0.5.nupkg
dotnet-ef| 6.0.5.nupkg
Microsoft.Data.Sqlite.Core| 6.0.5.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 6.0.5.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.203.nupkg
Microsoft.TemplateEngine.Utils| 6.0.203.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.203.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.203.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.203.nupkg
Microsoft.TemplateEngine.Core| 6.0.203.nupkg
Microsoft.TemplateEngine.Edge| 6.0.203.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.203.nupkg
Microsoft.TemplateEngine.IDE| 6.0.203.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.203.nupkg
Microsoft.TemplateSearch.Common| 6.0.203.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.203.nupkg
Microsoft.DotNet.Compatibility| 1.0.0-servicing.22221.10.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2| 6.0.300.nupkg
Microsoft.TemplateEngine.Edge| 6.0.300.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.300.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.300.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.300.nupkg
Microsoft.TemplateEngine.IDE| 6.0.300.nupkg
Microsoft.TemplateSearch.Common| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0| 6.0.300.nupkg
Microsoft.TemplateEngine.Core| 6.0.300.nupkg
Microsoft.TemplateEngine.Utils| 6.0.300.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.300.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0| 6.0.300.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.300.nupkg
Microsoft.TemplateSearch.Common| 6.0.300.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0| 6.0.300.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.300.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.300.nupkg
Microsoft.TemplateEngine.Core| 6.0.300.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.300.nupkg
Microsoft.TemplateEngine.Edge| 6.0.300.nupkg
Microsoft.TemplateEngine.IDE| 6.0.300.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.300.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.300.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.300.nupkg
Microsoft.TemplateEngine.Utils| 6.0.300.nupkg
FSharp.Compiler.Service| 41.0.4.nupkg
Microsoft.DotNet.Compatibility| 1.1.0.nupkg
FSharp.Core| 6.0.4.nupkg



[//]: # ( Runtime 6.0.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36a5510d-e454-4f46-aeaa-ed2c9521e12e/1d60cf7759fd938f2e6c9730d0792b9d/dotnet-runtime-6.0.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b7bfeef6-3df9-46a1-8cc9-5b2a3121a1d7/44287ecada25d3f0bd8610550e08246d/dotnet-runtime-6.0.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7c59902-a377-4e8a-a3d7-fc761983b491/e5b3b83ca4f215e6b7d458c6f03e409a/dotnet-runtime-6.0.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f9cb36e-28b1-429c-a578-934a7e1d2e91/cfecd1f693ce07469d903b7a24e782a9/dotnet-runtime-6.0.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec95dac6-c393-4294-87dc-3c62748345a6/a3f9e53cab6a59db36ebe03d51d69024/dotnet-runtime-6.0.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56d9250f-97df-4786-b33e-a8e34b349e86/dcf054ca00899a70a80aa1a7d3072b52/dotnet-runtime-6.0.5-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7102a180-c397-40b4-b4e7-887d5473d4c4/6a280e559749a9f55216f7571753a70a/dotnet-runtime-6.0.5-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f9e7817-fe7f-4f68-ada2-171d4907190b/a579270395021e1d42c79761000c64d1/dotnet-runtime-6.0.5-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7c76eb47-a0a0-4fe8-b60d-bb0c01fcd595/604061381c1f121f016d37b9a1e80435/dotnet-runtime-6.0.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8796f054-9724-4783-838d-90fec5a178d5/9ee66f0b62f19d765a1332c03823c490/dotnet-runtime-6.0.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3568ed88-3d4f-47d0-a753-c0cc1b872642/f5f84e3e2d43497ef36c8209e8d82b7e/dotnet-runtime-6.0.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0e63f631-e300-4d7a-99bd-0cdc0a791fb2/52fc81d72a2984fdcb8b30eaa2c77006/dotnet-runtime-6.0.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b395fa18-c53b-4f7f-bf91-6b2d3c43fedb/d83a318111da9e15f5ecebfd2d190e89/dotnet-runtime-6.0.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/50c64d87-3ca7-451b-9bf9-7cbc8578d1a7/18577a0122d43a650f31188a097878f5/dotnet-runtime-6.0.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/205afc96-c1cf-499e-a02b-5222f0806f9b/c97f9ee3ce58cae4ffe746732fa99784/dotnet-runtime-6.0.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/54fcf294-d31d-4e1d-a365-ff16aef1c33e/da869b444d32f364ce2b81a5a6176510/dotnet-runtime-6.0.5-win-x86.zip

[//]: # ( WindowsDesktop 6.0.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/aa74da73-02cb-49fd-93ad-ce93edccb8bc/4ac67827aff545ead4032a940c9094ff/windowsdesktop-runtime-6.0.5-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ed41d9fd-ba56-4835-b538-c8e68beb1392/efaf8918a13968b658567ad72d9aabd9/windowsdesktop-runtime-6.0.5-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5681bdf9-0a48-45ac-b7bf-21b7b61657aa/bbdc43bc7bf0d15b97c1a98ae2e82ec0/windowsdesktop-runtime-6.0.5-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a2f810c9-a93e-4e93-95c4-7e23d837f635/cecc305a9c1f74337f449bc39f069f62/windowsdesktop-runtime-6.0.5-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/68b75eff-3cee-41e0-b993-88a3e063eaee/3aa76cd11da04e2126a3fb7a6ee16e23/windowsdesktop-runtime-6.0.5-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/eb1109eb-c27e-4291-9217-e7075997e3fd/96459341887684411f1c6acae5e98880/windowsdesktop-runtime-6.0.5-win-x86.zip

[//]: # ( ASP 6.0.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eda01ff6-fb9f-49ce-bdc1-67c688f9f1fa/75b195f97f4b219fccbac4432a6afaf0/aspnetcore-runtime-6.0.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ba7087e-4513-41e5-8359-a4bcd2a3661f/e6828f0d8cf1ecc63074c9ff57685e27/aspnetcore-runtime-6.0.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e79d3c7d-0565-4964-bbbd-1744ce353f7d/3223e3848f5d3dc2d5b66e564f41f70f/aspnetcore-runtime-6.0.5-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1512315-fa95-46b3-b891-7081a9f827a1/5b23b506cd30696f955fdfe4fe2526e3/aspnetcore-runtime-6.0.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb45509f-641c-4e25-a4e0-530fc10144fb/d343f4c912f1fd4a6cffed75d60496f9/aspnetcore-runtime-6.0.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a0e9ceb8-04eb-4510-876c-795a6a123dda/6141e57558eddc2d4629c7c14c2c6fa1/aspnetcore-runtime-6.0.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc366dc7-c30a-4c75-868d-9d7dad64f7db/05ee16d359acd131b4c8ef41bb62ebaf/aspnetcore-runtime-6.0.5-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec3ae29d-ea2a-44ec-8ef4-a114a0efc818/401eca540c50187f8da95c430099ea2e/aspnetcore-runtime-6.0.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d0d98bc6-11aa-48f8-b99e-5669d579fd4f/46f70fd399e5d1a850fde20854306e56/aspnetcore-runtime-6.0.5-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/042e2559-fe53-4793-b385-665b7c1ca6d5/308ffacc925383207a8f1a27a1df8bdc/aspnetcore-runtime-6.0.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c0c10b6a-7f97-4853-afb5-44617d7cbbc4/5275bb79c31cc80cee795bb168d1f1a9/aspnetcore-runtime-6.0.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6d6093d9-1547-410f-91e5-cd1c84cd29cc/ade04a37ae559ec060b331146fefed0e/aspnetcore-runtime-6.0.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8e54982e-c0a7-47d0-85a4-be75ca6ee35c/2f3f6dcdc034eaad4d5b8529117b2fbb/aspnetcore-runtime-6.0.5-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/ae1014c7-a005-4a0e-9062-b6f3056ded09/da5d731f5ead9e385427a77412b88fb0/dotnet-hosting-6.0.5-win.exe

[//]: # ( SDK 6.0.203)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88fefcd9-70aa-4bca-80f8-4a78d6b8b53c/7ee6202e44cea4fa104f5f788425fcaf/dotnet-sdk-6.0.203-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7d9ebd1-16cd-44d5-b406-177ad676c630/1a46912f74a71117bee6077ad3b832df/dotnet-sdk-6.0.203-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/824718b2-dfee-4a5f-ac48-1e8b63377378/defb62a2ad925cb19390a343526c1a7e/dotnet-sdk-6.0.203-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9549b1c6-aed9-44e8-a455-01707951ed5f/6f1ca9a1aa740078b7fecad8d2c2d694/dotnet-sdk-6.0.203-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e744257-9ba1-4575-9334-db762c32462b/4c857a7eac212668ae0b2096546d9abe/dotnet-sdk-6.0.203-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e075dadf-22a9-482b-9387-bf8341a4f837/ab20e3e34c2c8be290d9938590f208ed/dotnet-sdk-6.0.203-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/39c2aad2-1f58-437e-9c57-0503bc29c19b/96ff2e9f9a9380661bb6ca1def5ff97f/dotnet-sdk-6.0.203-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5bb286c5-8c12-4eb0-91b3-0d673675f569/f925842decf6c320e0db41397e7636e7/dotnet-sdk-6.0.203-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2d0694a8-92ea-4c6b-bbfd-dae82cac49d5/f1c31bbe3272cf258417ad29f9f51b99/dotnet-sdk-6.0.203-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82aef4a2-e57f-4795-af33-e21840bc0413/2df621abe3e88ce9a0fa0b1a69943b01/dotnet-sdk-6.0.203-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a14fa3db-cfd2-4a7f-83ff-b04a8b0dd85c/dff84429395fd36183feac70dfe993db/dotnet-sdk-6.0.203-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/eef29a59-02fe-471c-8071-f9f8ea564093/f215dab02beb59eb1706d990dcb0c0a2/dotnet-sdk-6.0.203-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4de68d7-15fb-418a-ac11-fb51212cd16d/029648aa5eec8aed3800883620ec5d9e/dotnet-sdk-6.0.203-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c92e73c1-ea97-4649-9a95-7068bebdc983/216180cb4d47f959eea969bf15cd9d66/dotnet-sdk-6.0.203-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d869f1ef-f319-469f-9732-098df1fba850/07acdded4409f55159d69a757c326388/dotnet-sdk-6.0.203-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/859f16db-eb0d-40bf-8c98-ca37b0c50f4a/9649d029eb4fdc0323118f8919c1a390/dotnet-sdk-6.0.203-win-x86.zip

