# .NET 6.0.8 - August 09, 2022

The .NET 6.0.8, .NET SDK 6.0.303, [.NET SDK 6.0.108](6.0.108.md), and [.NET SDK 6.0.400](6.0.400.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.400
```

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Notable Changes
.NET 6.0.8 release carries security fixes.

# Microsoft Security Advisory CVE-2022-34716 | .NET Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An information disclosure vulnerability exists in .NET 6.0 and .NET Core 3.1 that could lead to unauthorized access of privileged information.

### Additional fixes in this release

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.8+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.2](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7682](https://github.com/dotnet/core/issues/7682) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.8/6.0.8.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.8-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.8-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/august-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.8
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.8
Microsoft.WindowsDesktop.App.Ref| 6.0.8
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.8
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.8
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.8
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.8
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.8
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.8
Microsoft.NETCore.App.Host.osx-x64| 6.0.8
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.8
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.8
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 6.0.8
Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.8
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.8
Microsoft.NETCore.App.Host.linux-arm| 6.0.8
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.8
Microsoft.NETCore.App.Host.win-arm| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 6.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 6.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200| 6.0.8
Microsoft.NETCore.App.Composite| 6.0.8
Microsoft.NETCore.App.Host.win-arm64| 6.0.8
Microsoft.NETCore.App.Host.win-x64| 6.0.8
Microsoft.NETCore.App.Ref| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.8
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.8
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.8
Microsoft.NETCore.App.Host.win-x86| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.8
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.8
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.8
Microsoft.NETCore.App.Host.osx-arm64| 6.0.8
Microsoft.NETCore.App.Host.linux-arm64| 6.0.8
Microsoft.NETCore.App.Host.linux-x64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.8
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 6.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.8
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.win-arm| 6.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.8
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.win-x64| 6.0.8
Microsoft.NETCore.App.Runtime.win-x86| 6.0.8
Microsoft.NETCore.DotNetHost| 6.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.8
System.Security.Cryptography.Xml.6.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.8
Microsoft.NETCore.DotNetHostResolver| 6.0.8
Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.8
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.8
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.8
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x86| 6.0.8
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.8
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.8
Microsoft.AspNetCore.Components.Web| 6.0.8
Microsoft.AspNetCore.Connections.Abstractions| 6.0.8
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.8
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.8
Microsoft.AspNetCore.JsonPatch| 6.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.8
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.8
Microsoft.AspNetCore.Razor.Language| 6.0.8
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.8
Microsoft.AspNetCore.SignalR.Common| 6.0.8
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.8
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.8
Microsoft.dotnet-openapi| 6.0.8
Microsoft.CodeAnalysis.Razor| 6.0.8
Microsoft.JSInterop| 6.0.8
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.8
Microsoft.AspNetCore.Components.Authorization| 6.0.8
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.8
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.8
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.8
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.8
Microsoft.Extensions.Features| 6.0.8
Microsoft.Extensions.FileProviders.Embedded| 6.0.8
Microsoft.Extensions.Identity.Core| 6.0.8
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.8
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.8
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.8
Microsoft.AspNetCore.Authentication.Google| 6.0.8
Microsoft.AspNetCore.Authentication.Facebook| 6.0.8
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.8
Microsoft.AspNetCore.Authentication.Twitter| 6.0.8
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.8
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.8
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.8
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.8
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.8
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.8
Microsoft.AspNetCore.SpaProxy| 6.0.8
Microsoft.AspNetCore.TestHost| 6.0.8
Microsoft.Authentication.WebAssembly.Msal| 6.0.8
Microsoft.Extensions.ApiDescription.Server| 6.0.8
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.8
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.8
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.8
Microsoft.Extensions.Http.Polly| 6.0.8
Microsoft.Extensions.Localization| 6.0.8
Microsoft.Extensions.Localization.Abstractions| 6.0.8
Microsoft.Extensions.Logging.AzureAppServices| 6.0.8
Microsoft.Extensions.ObjectPool| 6.0.8
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.8
AspNetCoreRuntime.6.0.x64| 6.0.8
AspNetCoreRuntime.6.0.x86| 6.0.8
dotnet-sql-cache| 6.0.8
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.8
Microsoft.AspNetCore.App.Ref| 6.0.8
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.8
Microsoft.AspNetCore.Authorization| 6.0.8
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.8
Microsoft.AspNetCore.Components.WebAssembly| 6.0.8
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.8
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.8
Microsoft.Extensions.Caching.SqlServer| 6.0.8
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.8
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.8
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.8
Microsoft.Extensions.Identity.Stores| 6.0.8
Microsoft.Extensions.WebEncoders| 6.0.8
Microsoft.JSInterop.WebAssembly| 6.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.8
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.8
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.8
Microsoft.AspNetCore.SignalR.Client| 6.0.8
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.8
Microsoft.Extensions.ApiDescription.Client| 6.0.8
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.8
Microsoft.AspNetCore.Authentication.Certificate| 6.0.8
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.8
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.8
Microsoft.AspNetCore.Components| 6.0.8
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.8
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.8
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.8
Microsoft.AspNetCore.Cryptography.Internal| 6.0.8
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.8
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.8
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.8
Microsoft.AspNetCore.HeaderPropagation| 6.0.8
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.8
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.8
Microsoft.AspNetCore.Mvc.Testing| 6.0.8
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.8
Microsoft.AspNetCore.Components.Analyzers| 6.0.8
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.8
Microsoft.AspNetCore.Components.Forms| 6.0.8
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.8
Microsoft.AspNetCore.Components.WebView| 6.0.8
Microsoft.AspNetCore.DataProtection| 6.0.8
Microsoft.AspNetCore.Http.Connections.Client| 6.0.8
Microsoft.AspNetCore.Identity.UI| 6.0.8
Microsoft.AspNetCore.Http.Connections.Common| 6.0.8
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.8
Microsoft.AspNetCore.Metadata| 6.0.8
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.8
Microsoft.AspNetCore.Owin| 6.0.8
Microsoft.DotNet.Common.ProjectTemplates.6.0.| 6.0.108
Microsoft.TemplateEngine.Core.| 6.0.108
Microsoft.TemplateEngine.Edge.| 6.0.108
Microsoft.TemplateEngine.Utils.| 6.0.108
Microsoft.TemplateEngine.Core.Contracts.| 6.0.108
Microsoft.TemplateEngine.IDE.| 6.0.108
Microsoft.TemplateEngine.TemplateLocalizer.Core.| 6.0.108
Microsoft.TemplateEngine.TemplateLocalizer.| 6.0.108
Microsoft.TemplateEngine.Orchestrator.RunnableProjects.| 6.0.108
Microsoft.TemplateSearch.Common.| 6.0.108
Microsoft.DotNet.Common.ItemTemplates.| 6.0.108
Microsoft.TemplateEngine.Abstractions.| 6.0.108
Microsoft.DotNet.Compatibility| 1.0.0-servicing.22368.19
Microsoft.EntityFrameworkCore.Design| 6.0.8
Microsoft.EntityFrameworkCore.InMemory| 6.0.8
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.8
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.8
Microsoft.EntityFrameworkCore.SqlServer| 6.0.8
Microsoft.Data.Sqlite| 6.0.8
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.8
Microsoft.EntityFrameworkCore.Relational| 6.0.8
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.8
Microsoft.EntityFrameworkCore| 6.0.8
Microsoft.EntityFrameworkCore.Analyzers| 6.0.8
Microsoft.EntityFrameworkCore.Proxies| 6.0.8
Microsoft.EntityFrameworkCore.Tools| 6.0.8
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.8
dotnet-ef| 6.0.8
Microsoft.Data.Sqlite.Core| 6.0.8
Microsoft.EntityFrameworkCore.Abstractions| 6.0.8
Microsoft.EntityFrameworkCore.Cosmos| 6.0.8
Microsoft.EntityFrameworkCore.Sqlite| 6.0.8
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.8
Microsoft.TemplateEngine.Core.Contracts| 6.0.303
Microsoft.TemplateEngine.Edge| 6.0.303
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.303
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.303
Microsoft.TemplateEngine.Utils| 6.0.303
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.303
Microsoft.DotNet.Common.ItemTemplates| 6.0.303
Microsoft.TemplateEngine.Abstractions| 6.0.303
Microsoft.TemplateSearch.Common| 6.0.303
Microsoft.DotNet.Common.ProjectTemplates| 6.0.303
Microsoft.TemplateEngine.Core| 6.0.303
Microsoft.TemplateEngine.IDE| 6.0.303
Microsoft.DotNet.Common.ProjectTemplates.1.x.| 6.0.400
Microsoft.DotNet.Common.ProjectTemplates.2.1.| 6.0.400
Microsoft.DotNet.Common.ProjectTemplates.6.0.| 6.0.400
Microsoft.TemplateEngine.Core.| 6.0.400
Microsoft.TemplateEngine.Edge.| 6.0.400
Microsoft.DotNet.Common.ItemTemplates.| 6.0.400
Microsoft.TemplateEngine.Core.Contracts.| 6.0.400
Microsoft.DotNet.Common.ProjectTemplates.2.0.| 6.0.400
Microsoft.DotNet.Common.ProjectTemplates.3.0.| 6.0.400
Microsoft.TemplateSearch.Common.| 6.0.400
Microsoft.TemplateEngine.Orchestrator.RunnableProjects.| 6.0.400
Microsoft.TemplateEngine.TemplateLocalizer.| 6.0.400
Microsoft.DotNet.Common.ProjectTemplates.2.2.| 6.0.400
Microsoft.DotNet.Common.ProjectTemplates.5.0.| 6.0.400
Microsoft.DotNet.Common.ProjectTemplates.3.1.| 6.0.400
Microsoft.TemplateEngine.Abstractions.| 6.0.400
Microsoft.TemplateEngine.IDE.| 6.0.400
Microsoft.TemplateEngine.TemplateLocalizer.Core.| 6.0.400
Microsoft.TemplateEngine.Utils.| 6.0.400


[//]: # ( Runtime 6.0.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3bdc231e-36c3-4bc9-85d0-c1889b17b1af/ec691544aec785d52417173ba7c17359/dotnet-runtime-6.0.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/866ce4df-8aaa-417d-ad81-26131a2b8734/7ba8391188bc194156ee7d82f494ee00/dotnet-runtime-6.0.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/40e056f3-abc7-4dcc-9874-832414a693e8/ec85ac59284584ef26db73392d115345/dotnet-runtime-6.0.8-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc35e31b-c65c-45f4-abd1-2d982bcd438f/f97483afcfa752c83c81645e3e082410/dotnet-runtime-6.0.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ad9838d-9f2e-40d3-bbff-a3c13390e719/79efd5ce752fb2348e46e0598311f399/dotnet-runtime-6.0.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5596ef6f-a174-4fba-aef1-99173e3f3c67/77edd755d605688885ca7114bc4f9ae9/dotnet-runtime-6.0.8-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9beccd15-f764-41af-babc-e88839269b89/fe9ee487d0d52feb9a9213da780f19d8/dotnet-runtime-6.0.8-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b8a7b71-8f77-439b-a4d8-b4fd863466d3/7a852ca4536bdef2e63d9f5e98731777/dotnet-runtime-6.0.8-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5cda9364-6621-40a0-9519-c460a37571c6/a73481f3abf7bd0325420d2ce740bfed/dotnet-runtime-6.0.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1c11dcab-2b1b-4f89-88a8-32665c56a131/c1654a9f3d01805033b7fd8d505050e8/dotnet-runtime-6.0.8-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/cbef9889-7cf4-461b-aa60-5c5f309a551c/131274bd29f18e75642bb8b0e5425893/dotnet-runtime-6.0.8-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/94c448eb-9709-4137-9fa9-6cc546916352/b9291cb0654181fdb865a09dc0e9c5f4/dotnet-runtime-6.0.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5af3de9d-1e5f-48ff-bfb7-f93c0957ffae/e8dd664b0439f4725f8c968e7aae7dd1/dotnet-runtime-6.0.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e810aa7e-9251-4e0b-a9fa-0122c4256c05/67d268682bee8a6fb1d47e4fca9c9e6a/dotnet-runtime-6.0.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/db70cd1d-4f33-4dc4-8293-57bb362175c7/5c27048a0fc814e58bc196666a9b0c61/dotnet-runtime-6.0.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a152bb73-b340-450b-9e56-ddff92d39fa1/cb94c72c10dbd2dec7187f3ac209778c/dotnet-runtime-6.0.8-win-x86.zip

[//]: # ( WindowsDesktop 6.0.8)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/17737b16-dbb0-45f8-9684-16cce46f0835/14475e8380422840249513d58c70d8da/windowsdesktop-runtime-6.0.8-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b15670c-ff25-438d-a543-97a87a1b5b8f/ede2a46496f014da82daa44ff8d50048/windowsdesktop-runtime-6.0.8-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b4a17a47-2fe8-498d-b817-30ad2e23f413/00020402af25ba40990c6cc3db5cb270/windowsdesktop-runtime-6.0.8-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8e5bc0ac-1909-496f-84f9-3584a4b1408e/7868adc1397f5e5c5c00adc2057894c4/windowsdesktop-runtime-6.0.8-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/61747fc6-7236-4d5e-85e5-a5df5f480f3a/02203594bf1331f0875aa6491419ffa1/windowsdesktop-runtime-6.0.8-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cac6c954-8a0d-4269-886c-617c66a3f957/28442e76157352c225518e7ed20c8da0/windowsdesktop-runtime-6.0.8-win-x86.zip

[//]: # ( ASP 6.0.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf567026-a29a-41aa-bc3a-e4e1ad0df480/0925d411e8e09e31ba7a39a3eb0e29af/aspnetcore-runtime-6.0.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/83695c9b-c954-459e-b9bf-2f1ac269e34e/1316ff4a6fe4c6916e7ecb3623d67cee/aspnetcore-runtime-6.0.8-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/54c24488-c52d-48da-931c-db07178b202f/9b0af9fa349af63ae49a35a73f322605/aspnetcore-runtime-6.0.8-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d8061f5b-ff9d-4784-8232-9c0c940e35ee/37081197496b70a636a7f70234fdf31c/aspnetcore-runtime-6.0.8-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20e844ad-6fa4-4bdc-9613-5f47cdfb9b5e/a7a152e058f6591082cc36674d89eb09/aspnetcore-runtime-6.0.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5cc06c3a-4d8a-4fb2-8f7a-ecd23cd8c4e0/dd386c0e3a41ea54f459907c834acedf/aspnetcore-runtime-6.0.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7859a31f-74c9-4756-a9ab-f040550666ac/3c4ad4317e732436f8c092eb9cdb4168/aspnetcore-runtime-6.0.8-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0601cae2-aa41-4318-a996-36633cd641f3/ffc290161ae37b28894ff7465dd50c17/aspnetcore-runtime-6.0.8-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b69abba3-d3ab-48e0-bb4a-3982a2d6301f/d634a4ee361cd86045937446e7535788/aspnetcore-runtime-6.0.8-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f5ef50c0-4dd1-4301-857f-768834d5a006/852c6470e4e5f602eee280c1e4e4e4c3/aspnetcore-runtime-6.0.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0bb8a653-dde7-4cc2-8484-c2cc864ad30b/cb482677b7532d35f647fc0204140d94/aspnetcore-runtime-6.0.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/26dd0df5-f2ef-4b47-8651-84a2496dd017/158f3a45dd0718fc3ceda10b56b22721/aspnetcore-runtime-6.0.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e305d157-41ff-4537-98dc-cc745c19e8f6/2c761c9d6a33acbeefdeec1b36e0be4c/aspnetcore-runtime-6.0.8-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c5e0609f-1db5-4741-add0-a37e8371a714/1ad9c59b8a92aeb5d09782e686264537/dotnet-hosting-6.0.8-win.exe

[//]: # ( SDK 6.0.303)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89e0bd36-57eb-41e4-95c9-4e35569e0f6b/1e7b6862caa6488465ab74d7c44bf130/dotnet-sdk-6.0.303-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/625d6cbb-7d21-41ab-a474-3ba603770d1d/7016fc39dc1eb5c8c7c5e2cc36440212/dotnet-sdk-6.0.303-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65774159-80ad-4b5b-8379-819377bce37f/0aaec8471b4f1d88cdef72a088d9b8b9/dotnet-sdk-6.0.303-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cdd4919a-6547-41f3-8a78-bb3d5a2ff450/f7254df14266f63b49a8909b942f2a26/dotnet-sdk-6.0.303-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d582c32-0982-4e1b-8c18-2c94bb00e660/24d19dae88983c24385b3b700df79b74/dotnet-sdk-6.0.303-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dce68d71-9fd9-47d6-9d66-4fc9f517a41d/3e3e67f5e16f9ca2607a46abfa8750d7/dotnet-sdk-6.0.303-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9a3d1b63-6fe8-49ca-91a9-77cb157e61b6/c5ea1853ea40dcfe228cf4ebe32db0d2/dotnet-sdk-6.0.303-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cfb4203a-0c0a-4e9c-99f3-315f1e06f197/0fe3ee6df42b35c8cdc9c1cfc91bab4b/dotnet-sdk-6.0.303-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c0d44160-dce6-40e3-b55b-1dd4d96dc8be/9e3f268f52015ff49358820bee445c92/dotnet-sdk-6.0.303-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/283d6ec3-03c6-4ca9-aaea-a69417fc5ad7/30326aa813cf448e827b697940539d43/dotnet-sdk-6.0.303-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/ef3953e8-89fa-4322-9348-e5ea66b78bc0/be67a4e9fa0853ad4a1a9c6e6d083f04/dotnet-sdk-6.0.303-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a00a145e-d618-4a4d-aa3e-49ca581c187f/dd1ad877b1f2c419b72a1a8492955443/dotnet-sdk-6.0.303-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e2c830af-580d-4f92-b6d6-6e3965c46938/db99338b755fb145d32962c90b8ec2f2/dotnet-sdk-6.0.303-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/926b3941-c355-4d9e-abb7-496ec8994b81/792d0120c6a078e060a06179a75cb5f5/dotnet-sdk-6.0.303-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2474e62d-0fa3-486b-8613-99d7379d93c2/2b87457489a4ac2218c78037c0439e68/dotnet-sdk-6.0.303-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e968002c-d82b-476e-b015-3fb8988c6d3e/e36ca01af2b69a8a7070fbeda11019a3/dotnet-sdk-6.0.303-win-x86.zip

