# System.Threading

``` diff
 namespace System.Threading {
-    public struct AsyncFlowControl : IDisposable
+    public struct AsyncFlowControl : IDisposable, IEquatable<AsyncFlowControl>
     public readonly struct CancellationToken {
+        public CancellationTokenRegistration Register(Action<object, CancellationToken> callback, object state);
+        public CancellationTokenRegistration UnsafeRegister(Action<object, CancellationToken> callback, object state);
     }
     public class CancellationTokenSource : IDisposable {
+        public bool TryReset();
     }
+    public sealed class PeriodicTimer : IDisposable {
+        public PeriodicTimer(TimeSpan period);
+        public void Dispose();
+        public ValueTask<bool> WaitForNextTickAsync(CancellationToken cancellationToken = default(CancellationToken));
+    }
     public sealed class PreAllocatedOverlapped : IDisposable {
+        public static PreAllocatedOverlapped UnsafeCreate(IOCompletionCallback callback, object state, object pinData);
     }
     public sealed class Thread : CriticalFinalizerObject {
+        public void UnsafeStart();
+        public void UnsafeStart(object parameter);
     }
     public sealed class ThreadPoolBoundHandle : IDisposable {
+        public unsafe NativeOverlapped* UnsafeAllocateNativeOverlapped(IOCompletionCallback callback, object state, object pinData);
     }
 }
```

