# Microsoft.AspNetCore.Authentication.Cookies

``` diff
 namespace Microsoft.AspNetCore.Authentication.Cookies {
     public class CookieAuthenticationEvents {
+        public Func<CookieSlidingExpirationContext, Task> OnCheckSlidingExpiration { get; set; }
     }
+    public class CookieSlidingExpirationContext : PrincipalContext<CookieAuthenticationOptions> {
+        public CookieSlidingExpirationContext(HttpContext context, AuthenticationScheme scheme, CookieAuthenticationOptions options, AuthenticationTicket ticket, TimeSpan elapsedTime, TimeSpan remainingTime);
+        public TimeSpan ElapsedTime { get; }
+        public TimeSpan RemainingTime { get; }
+        public bool ShouldRenew { get; set; }
+    }
     public interface ITicketStore {
+        Task RemoveAsync(string key, CancellationToken cancellationToken);
+        Task RenewAsync(string key, AuthenticationTicket ticket, CancellationToken cancellationToken);
+        Task<AuthenticationTicket> RetrieveAsync(string key, CancellationToken cancellationToken);
+        Task<string> StoreAsync(AuthenticationTicket ticket, CancellationToken cancellationToken);
     }
 }
```

