# Microsoft.AspNetCore.Components.Web

``` diff
 namespace Microsoft.AspNetCore.Components.Web {
+    public class ErrorBoundary : ErrorBoundaryBase {
+        public ErrorBoundary();
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected override Task OnErrorAsync(Exception exception);
+    }
+    public sealed class HeadContent : ComponentBase {
+        public HeadContent();
+        public RenderFragment ChildContent { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+    }
+    public sealed class HeadOutlet : ComponentBase {
+        public HeadOutlet();
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected override Task OnAfterRenderAsync(bool firstRender);
+    }
+    public interface IErrorBoundaryLogger {
+        ValueTask LogErrorAsync(Exception exception);
+    }
+    public interface IJSComponentConfiguration {
+        JSComponentConfigurationStore JSComponents { get; }
+    }
+    public static class JSComponentConfigurationExtensions {
+        public static void RegisterForJavaScript(this IJSComponentConfiguration configuration, Type componentType, string identifier);
+        public static void RegisterForJavaScript(this IJSComponentConfiguration configuration, Type componentType, string identifier, string javaScriptInitializer);
+        public static void RegisterForJavaScript<TComponent>(this IJSComponentConfiguration configuration, string identifier) where TComponent : IComponent;
+        public static void RegisterForJavaScript<TComponent>(this IJSComponentConfiguration configuration, string identifier, string javaScriptInitializer) where TComponent : IComponent;
+    }
+    public sealed class JSComponentConfigurationStore {
+        public JSComponentConfigurationStore();
+    }
     public class MouseEventArgs : EventArgs {
+        public double PageX { get; set; }
+        public double PageY { get; set; }
     }
+    public sealed class PageTitle : ComponentBase {
+        public PageTitle();
+        public RenderFragment ChildContent { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+    }
 }
```

