# Microsoft.AspNetCore.HttpLogging

``` diff
+namespace Microsoft.AspNetCore.HttpLogging {
+    public enum HttpLoggingFields : long {
+        All = (long)3325,
+        None = (long)0,
+        Request = (long)1117,
+        RequestBody = (long)1024,
+        RequestHeaders = (long)64,
+        RequestMethod = (long)8,
+        RequestPath = (long)1,
+        RequestProperties = (long)29,
+        RequestPropertiesAndHeaders = (long)93,
+        RequestProtocol = (long)4,
+        RequestQuery = (long)2,
+        RequestScheme = (long)16,
+        RequestTrailers = (long)256,
+        Response = (long)2208,
+        ResponseBody = (long)2048,
+        ResponseHeaders = (long)128,
+        ResponsePropertiesAndHeaders = (long)160,
+        ResponseStatusCode = (long)32,
+        ResponseTrailers = (long)512,
+    }
+    public sealed class HttpLoggingOptions {
+        public HttpLoggingOptions();
+        public HttpLoggingFields LoggingFields { get; set; }
+        public MediaTypeOptions MediaTypeOptions { get; }
+        public int RequestBodyLogLimit { get; set; }
+        public ISet<string> RequestHeaders { get; }
+        public int ResponseBodyLogLimit { get; set; }
+        public ISet<string> ResponseHeaders { get; }
+    }
+    public sealed class MediaTypeOptions {
+        public void AddBinary(MediaTypeHeaderValue mediaType);
+        public void AddBinary(string contentType);
+        public void AddText(string contentType);
+        public void AddText(string contentType, Encoding encoding);
+        public void Clear();
+    }
+    public sealed class W3CLoggerOptions {
+        public W3CLoggerOptions();
+        public string FileName { get; set; }
+        public int? FileSizeLimit { get; set; }
+        public TimeSpan FlushInterval { get; set; }
+        public string LogDirectory { get; set; }
+        public W3CLoggingFields LoggingFields { get; set; }
+        public int? RetainedFileCountLimit { get; set; }
+    }
+    public enum W3CLoggingFields : long {
+        All = (long)131071,
+        ClientIpAddress = (long)4,
+        ConnectionInfoFields = (long)100,
+        Cookie = (long)32768,
+        Date = (long)1,
+        Host = (long)8192,
+        Method = (long)128,
+        None = (long)0,
+        ProtocolStatus = (long)1024,
+        ProtocolVersion = (long)4096,
+        Referer = (long)65536,
+        Request = (long)95104,
+        RequestHeaders = (long)90112,
+        ServerIpAddress = (long)32,
+        ServerName = (long)16,
+        ServerPort = (long)64,
+        Time = (long)2,
+        TimeTaken = (long)2048,
+        UriQuery = (long)512,
+        UriStem = (long)256,
+        UserAgent = (long)16384,
+        UserName = (long)8,
+    }
+}
```

