# System.Text.Json.Serialization.Metadata

``` diff
 namespace System.Text.Json.Serialization.Metadata {
     public static class JsonMetadataServices {
+        public static JsonConverter<JsonElement> JsonElementConverter { get; }
+        public static JsonConverter<TimeSpan> TimeSpanConverter { get; }
+        public static JsonTypeInfo<TCollection> CreateConcurrentQueueInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : ConcurrentQueue<TElement>;
+        public static JsonTypeInfo<TCollection> CreateConcurrentStackInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : ConcurrentStack<TElement>;
+        public static JsonTypeInfo<TCollection> CreateICollectionInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : ICollection<TElement>;
+        public static JsonTypeInfo<TCollection> CreateIDictionaryInfo<TCollection, TKey, TValue>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo keyInfo, JsonTypeInfo valueInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : IDictionary<TKey, TValue>;
+        public static JsonTypeInfo<TCollection> CreateIDictionaryInfo<TCollection>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo stringInfo, JsonTypeInfo objectInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : IDictionary;
+        public static JsonTypeInfo<TCollection> CreateIEnumerableInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : IEnumerable<TElement>;
+        public static JsonTypeInfo<TCollection> CreateIEnumerableInfo<TCollection>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : IEnumerable;
+        public static JsonTypeInfo<TCollection> CreateIListInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : IList<TElement>;
+        public static JsonTypeInfo<TCollection> CreateIListInfo<TCollection>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo objectInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : IList;
+        public static JsonTypeInfo<TCollection> CreateImmutableDictionaryInfo<TCollection, TKey, TValue>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo keyInfo, JsonTypeInfo valueInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc, Func<IEnumerable<KeyValuePair<TKey, TValue>>, TCollection> createRangeFunc) where TCollection : IReadOnlyDictionary<TKey, TValue>;
+        public static JsonTypeInfo<TCollection> CreateImmutableEnumerableInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc, Func<IEnumerable<TElement>, TCollection> createRangeFunc) where TCollection : IEnumerable<TElement>;
+        public static JsonTypeInfo<TCollection> CreateIReadOnlyDictionaryInfo<TCollection, TKey, TValue>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo keyInfo, JsonTypeInfo valueInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : IReadOnlyDictionary<TKey, TValue>;
+        public static JsonTypeInfo<TCollection> CreateISetInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : ISet<TElement>;
+        public static JsonPropertyInfo CreatePropertyInfo<T>(JsonSerializerOptions options, bool isProperty, bool isPublic, bool isVirtual, Type declaringType, JsonTypeInfo propertyTypeInfo, JsonConverter<T> converter, Func<object, T> getter, Action<object, T> setter, JsonIgnoreCondition? ignoreCondition, bool hasJsonInclude, JsonNumberHandling? numberHandling, string propertyName, string jsonPropertyName);
-        public static JsonPropertyInfo CreatePropertyInfo<T>(JsonSerializerOptions options, bool isProperty, Type declaringType, JsonTypeInfo propertyTypeInfo, JsonConverter<T> converter, Func<object, T> getter, Action<object, T> setter, JsonIgnoreCondition ignoreCondition, JsonNumberHandling numberHandling, string propertyName, string jsonPropertyName);

+        public static JsonTypeInfo<TCollection> CreateQueueInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : Queue<TElement>;
+        public static JsonTypeInfo<TCollection> CreateStackInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc) where TCollection : Stack<TElement>;
+        public static JsonTypeInfo<TCollection> CreateStackOrQueueInfo<TCollection>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling, Action<Utf8JsonWriter, TCollection> serializeFunc, Action<TCollection, object> addFunc) where TCollection : IEnumerable;
     }
 }
```

