# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    public class HttpValidationProblemDetails : ProblemDetails {
+        public HttpValidationProblemDetails();
+        public HttpValidationProblemDetails(IDictionary<string, string[]> errors);
+        public IDictionary<string, string[]> Errors { get; }
+    }
+    public interface IResultExtensions
+    public static class OpenApiEndpointConventionBuilderExtensions {
+        public static DelegateEndpointConventionBuilder Accepts(this DelegateEndpointConventionBuilder builder, Type requestType, string contentType, params string[] additionalContentTypes);
+        public static DelegateEndpointConventionBuilder Accepts<TRequest>(this DelegateEndpointConventionBuilder builder, string contentType, params string[] additionalContentTypes);
+        public static DelegateEndpointConventionBuilder ExcludeFromDescription(this DelegateEndpointConventionBuilder builder);
+        public static DelegateEndpointConventionBuilder Produces(this DelegateEndpointConventionBuilder builder, int statusCode, Type responseType = null, string contentType = null, params string[] additionalContentTypes);
+        public static DelegateEndpointConventionBuilder Produces<TResponse>(this DelegateEndpointConventionBuilder builder, int statusCode = 200, string contentType = null, params string[] additionalContentTypes);
+        public static DelegateEndpointConventionBuilder ProducesProblem(this DelegateEndpointConventionBuilder builder, int statusCode, string contentType = null);
+        public static DelegateEndpointConventionBuilder ProducesValidationProblem(this DelegateEndpointConventionBuilder builder, int statusCode = 400, string contentType = null);
+    }
     public static class RequestDelegateFactory {
-        public static RequestDelegate Create(Delegate action, RequestDelegateFactoryOptions options = null);

+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions options = null);
-        public static RequestDelegate Create(MethodInfo methodInfo, Func<HttpContext, object> targetFactory = null, RequestDelegateFactoryOptions options = null);

+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object> targetFactory = null, RequestDelegateFactoryOptions options = null);
     }
+    public sealed class RequestDelegateResult {
+        public RequestDelegateResult(RequestDelegate requestDelegate, IReadOnlyList<object> metadata);
+        public IReadOnlyList<object> EndpointMetadata { get; }
+        public RequestDelegate RequestDelegate { get; }
+    }
     public static class Results {
+        public static IResultExtensions Extensions { get; }
     }
 }
```

