# .NET 7.0.0 Preview 1 - February 17, 2022

The .NET 7.0.0 Preview 1 and .NET SDK 7.0.100-preview.1.22110.4 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7 Preview 1

.NET 7 is the next major release of .NET following .NET 6.0. You can see some of the new features available with .NET 7 Preview 1 at [dotnet/core #7106](https://github.com/dotnet/core/issues/7106).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 1.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.100-preview.1.22110.4
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.2 latest preview](https://visualstudio.microsoft.com) to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7203](https://github.com/dotnet/core/issues/7203) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/7.0/preview/7.0.0-preview.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.1-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-7-preview-1/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-7-preview-1
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-7-preview-1
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview1+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview1+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx
[linux-packages]: 7.0.0-preview.1-install-instructions.md



[//]: # ( Runtime 7.0.0-preview.1.22076.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a86e36ca-d95d-47f2-abd4-e10727e90b90/a5d07b7d3d004d346102e1e132592fdb/dotnet-runtime-7.0.0-preview.1.22076.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/015091ae-2f55-48fc-927f-85b7dc4d56d1/8cfe43cc8798e769dd19bdd4a9683930/dotnet-runtime-7.0.0-preview.1.22076.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5cc92560-b5eb-4652-b565-4c5e53c25e99/b6d650cae6a231000d2bb92447f6caa8/dotnet-runtime-7.0.0-preview.1.22076.8-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89447f9c-0f9d-49de-94d0-892f26df6869/52a744a959ade5144e46297e3b5b24ae/dotnet-runtime-7.0.0-preview.1.22076.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37085522-cd16-4a7d-865f-b17dbdfcdb2d/1f3d08eeb4862cb61bd4475c176f1db1/dotnet-runtime-7.0.0-preview.1.22076.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c488969d-4127-4037-b03d-ac27cd643c3d/44f19a07ddb90790c42e52acf8090ceb/dotnet-runtime-7.0.0-preview.1.22076.8-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/17b7ed90-2cac-4a18-9d04-787fb76a0175/52773df7c2c4982728cc153111c8a0aa/dotnet-runtime-7.0.0-preview.1.22076.8-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b29d582-87bb-4210-a9b3-1948d08569c8/ca05672a3b251e5542ad07a8aa633cf1/dotnet-runtime-7.0.0-preview.1.22076.8-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/db7f0e7c-1565-4b19-ac46-28e6e2bc8d45/3dc432a183bb535ac690af8abd2b45f7/dotnet-runtime-7.0.0-preview.1.22076.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b84fb8f-a519-485c-bacc-b4aab67e61ee/8a07dec7e0df35cc260b5665b3d8ed72/dotnet-runtime-7.0.0-preview.1.22076.8-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1383b843-81a9-4dda-b6ce-48562ae42c40/89621de02fd9d4848dc4821905e08d8f/dotnet-runtime-7.0.0-preview.1.22076.8-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/309271ac-0170-4f95-adea-9b6406aecf46/f39891d49c7c3cac62dd2a8b90a95822/dotnet-runtime-7.0.0-preview.1.22076.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ab315bbe-2573-45f7-a726-d56e01a7d45d/6ef8e71abc73bfac84f72f7391f6d789/dotnet-runtime-7.0.0-preview.1.22076.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3b2f08ce-da51-4885-b880-7a1fca389bfc/b3bf86b208a2891c0c29d8c80871ff8e/dotnet-runtime-7.0.0-preview.1.22076.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/45012d3c-c6f1-4ff0-84f7-0062e1fbd2f2/61fea09f1d1d810850516ae52eda7147/dotnet-runtime-7.0.0-preview.1.22076.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1faf7825-e46d-4c29-85ac-41b56112e311/5d4570bfdcf16c4de7746f297375339b/dotnet-runtime-7.0.0-preview.1.22076.8-win-x86.zip

[//]: # ( WindowsDesktop 7.0.0-preview.1.22077.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/97ffba53-e483-4838-9a37-92966f98862f/6abac94644d5cbda16bcce7105dad09c/windowsdesktop-runtime-7.0.0-preview.1.22077.5-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/33df2534-5f57-4283-a7d8-76fcf21a6ce9/b6c31de7050795e0b3e1f8e1656d6fad/windowsdesktop-runtime-7.0.0-preview.1.22077.5-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/96abfe29-d667-4e45-b32a-5f02e83c11fb/8cebcc9ed8cb8f770aa70e1c979be404/windowsdesktop-runtime-7.0.0-preview.1.22077.5-win-x86.exe

[//]: # ( ASP 7.0.0-preview.1.22109.13)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/777bfc12-db88-4803-8cff-74eae5d9835f/a790d8276636439617ed47f5c721b5d0/aspnetcore-runtime-7.0.0-preview.1.22109.13-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0eed2507-e7b2-41b8-897d-88db71dd1671/bc95540655d5be26ea361f5f259fc984/aspnetcore-runtime-7.0.0-preview.1.22109.13-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f53cd316-a2b5-4f99-ab79-8128787bf92a/76ac3cdbd02ae82d6157b98e59f5d476/aspnetcore-runtime-7.0.0-preview.1.22109.13-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7558ac6d-3d5b-4094-bdf7-5ad5558be03f/fe82be2f5e9846b2a84eabe7d400e2f4/aspnetcore-runtime-7.0.0-preview.1.22109.13-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/112bf923-880c-43e0-bfde-5064fe67835c/adfc978a09876ecc1bfcf92893822d5a/aspnetcore-runtime-7.0.0-preview.1.22109.13-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c49ea5ad-41ee-41fa-9eab-47dfcc7e23ad/39907ed7d3caddc44fbf52f88baf6401/aspnetcore-runtime-7.0.0-preview.1.22109.13-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/92343a77-c35f-495e-a1f2-44afffdfb01b/c4960e532c24274e1b3d3cc5539b1fe7/aspnetcore-runtime-7.0.0-preview.1.22109.13-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44202dd0-d880-4730-9af0-d80da65738b6/61398785478b24f9275e3233c94b4838/aspnetcore-runtime-7.0.0-preview.1.22109.13-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/dc97a5fc-d10a-4590-bc20-96ad68586815/87d3c5ae4d7aca683b4919485c64df75/aspnetcore-runtime-7.0.0-preview.1.22109.13-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/78e7f4c0-8d3c-4a8a-83d7-4d85399c083f/225adf84fe2ea8ce6091d587f8a7d3fb/aspnetcore-runtime-7.0.0-preview.1.22109.13-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0a98b821-d06c-4ef2-ae94-39577e8c85ed/7ff1720d148ed9f2dadd2b1d9d152cbd/aspnetcore-runtime-7.0.0-preview.1.22109.13-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b6d3d70d-aef5-456b-8c49-57003c9b4ef4/e2151d928ed24809d548388c5a2d6b04/aspnetcore-runtime-7.0.0-preview.1.22109.13-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/25a686cf-4b03-4112-9336-991058a870ed/3c902b62b628b7fb072c16d2c73ee821/aspnetcore-runtime-7.0.0-preview.1.22109.13-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/8dcc6633-1029-4023-ae74-58eaf1265f6f/25857773ed0a2da3faabfce0d6968b5d/dotnet-hosting-7.0.0-preview.1.22109.13-win.exe

[//]: # ( SDK 7.0.100-preview.1.22110.4)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ee818c9-79bb-4b89-8c60-cb97cd878d43/6a59e8751a1b6f3620af51994a351f6c/dotnet-sdk-7.0.100-preview.1.22110.4-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86f77277-df30-4e8f-a9c1-48fa40a117ff/a33b77e9a6bc932d3623d83ec4fe528f/dotnet-sdk-7.0.100-preview.1.22110.4-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b353281a-47b6-4298-bd94-28cb1612a84d/24051b3c2d890f14990bbd9676e66f79/dotnet-sdk-7.0.100-preview.1.22110.4-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3674b6b4-a1a5-48db-b1b8-1ed3b3b17b97/29f58adb7c90933fa53cb485ce2663d8/dotnet-sdk-7.0.100-preview.1.22110.4-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9f15fa5-faa9-446a-8c74-ab0bf6ca130c/46594a3c4ca54201f207a447d5d2b86d/dotnet-sdk-7.0.100-preview.1.22110.4-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1af9d3c3-a20e-400c-abe5-3d80dec7b63b/803f8dc5cf21fb28245aba71a7fdbc05/dotnet-sdk-7.0.100-preview.1.22110.4-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8a5292b1-3f04-4766-8551-690c87688734/3928534aafadd1b556a1526d45d0dc8c/dotnet-sdk-7.0.100-preview.1.22110.4-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae06e407-ba53-4a2b-834c-184bf4ae76d7/2246f5ef1881027f2d76d9562c3b6b80/dotnet-sdk-7.0.100-preview.1.22110.4-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d6b45e3f-1395-441d-a5ec-06b0fa380de6/5486b8caad6778dce9f2d292aa3fd3e1/dotnet-sdk-7.0.100-preview.1.22110.4-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39330fd9-ffa9-45f1-bb8f-1788f9477c26/06e55d3f9012f4c30b490b1f0d2cf41d/dotnet-sdk-7.0.100-preview.1.22110.4-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a0547b83-aebc-49a5-8bfb-a7170b1b0b01/fc7eef031bf6cbb6300b3aed0428d2a2/dotnet-sdk-7.0.100-preview.1.22110.4-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/17dcb3b9-99bd-4d7f-bb27-ef0cdd3db552/7cd893766c7d7be236a5436dad8623ba/dotnet-sdk-7.0.100-preview.1.22110.4-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b9655c4b-1dcc-43dd-b5c6-63341995f584/9aa8c600352e6f3058a948f93bad5ddb/dotnet-sdk-7.0.100-preview.1.22110.4-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9765ed67-8c55-41ad-aeef-21be6d599ce7/4092e82ed77053c5621cfe19ce1d9329/dotnet-sdk-7.0.100-preview.1.22110.4-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/de7bcaa5-ce24-4bce-bb2c-7a7c0e411ca2/74409acb3c403251242d91ff8c5fe1a4/dotnet-sdk-7.0.100-preview.1.22110.4-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c4360551-7f37-47b9-b34c-9914b7dcb642/f9d8e4e4b8b8348135b5fb7a3a44353e/dotnet-sdk-7.0.100-preview.1.22110.4-win-x86.zip


[//]: # ( Symbols )
