# .NET 7.0.0 Preview 7  - August 9, 2022

The .NET 7.0.0 Preview 7 and .NET SDK 7.0.100-preview.7.22377.5 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7 Preview 7

.NET 7 is the next major release of .NET following .NET 6.0. You can see some of the new features available with .NET 7 Preview 7 at [dotnet/core #7455](https://github.com/dotnet/core/issues/7455).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 7.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.100-preview.7.22377.5
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.4 latest preview](https://visualstudio.microsoft.com) to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7683](https://github.com/dotnet/core/issues/7683) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/7.0/preview/7.0.0-preview.7.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.7-sha.txt

[linux-install]: https://github.com/dotnet/core/blob/main/release-notes/7.0/install-linux.md
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-7-preview-7/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-preview-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7-preview7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview7+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview7+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview7+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview7+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md


[//]: # ( Runtime 7.0.0-preview.7.22375.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a03dc944-4c4d-4357-ae34-a97e59020f99/9951f440936e6967a3a62961119a7274/dotnet-runtime-7.0.0-preview.7.22375.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c09945b9-bc4b-4f81-adf8-01daecbe65fb/7992ad0a8673a56f63261eb6f14e6b1c/dotnet-runtime-7.0.0-preview.7.22375.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4240849f-1081-4d35-a4cc-6722b5c0522b/cd681e9359e9ce16ff9c3f5390967100/dotnet-runtime-7.0.0-preview.7.22375.6-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a764dcf7-37c6-478b-a411-f912aa15e47a/014d13c3384061dde13d728171d3bd64/dotnet-runtime-7.0.0-preview.7.22375.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dfcc36cc-aba2-46d9-9c0f-b6ed897b2c24/d4f83f872767f38a13e1cd4379a2ea80/dotnet-runtime-7.0.0-preview.7.22375.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57191b50-7af9-40d1-86a6-73dac33795fb/51ccaf67389abbd80249ddeebe7bc3cd/dotnet-runtime-7.0.0-preview.7.22375.6-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b84c6db5-5c65-4d26-b705-0c3f5320d2fa/48b49ac04cc7929e05db6a76cd7cd621/dotnet-runtime-7.0.0-preview.7.22375.6-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/be63ba3f-9707-448e-8b41-b2b19c7a61ae/b762ab7c0947ab72ea8438809cd95e6c/dotnet-runtime-7.0.0-preview.7.22375.6-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b3d72f3f-cbb6-40cf-8f19-2df35554ad35/3f247901e4f567fdf5defcda474ce080/dotnet-runtime-7.0.0-preview.7.22375.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7bd38473-15b6-4c6e-8bb0-891dbbbd3a45/37442e606ac06e70a2fa477a18995a62/dotnet-runtime-7.0.0-preview.7.22375.6-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/af6f381a-56cd-4bd6-bf64-23932530313a/132691fa06f33577e36ab0d36f872da6/dotnet-runtime-7.0.0-preview.7.22375.6-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7220ed15-b418-4b78-b5fd-196138a84e24/9ed0d9141ccbebfc77daade3a138581b/dotnet-runtime-7.0.0-preview.7.22375.6-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/988cb0b1-28f3-42cc-a2db-15353c215f20/af3c7dbb6599176de06720cf62755ab5/dotnet-runtime-7.0.0-preview.7.22375.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f27d0c63-1046-425b-a776-fd48d2a97339/657ea2aa9f400c8a2e7b18442f75307d/dotnet-runtime-7.0.0-preview.7.22375.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/42d0f5ae-07fe-4e00-9063-621d02502bb0/6460b0bfdf68338252f957a7d602094d/dotnet-runtime-7.0.0-preview.7.22375.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/36476c0d-5a53-445e-b882-7c42307e28d9/8918cf364a8ce5d64f8619c0a171d6a0/dotnet-runtime-7.0.0-preview.7.22375.6-win-x86.zip

[//]: # ( WindowsDesktop 7.0.0-preview.7.22377.1)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/044900a2-daf6-47b2-9daa-23237201f6b1/b846901d63ac175b30d483818b4dbda4/windowsdesktop-runtime-7.0.0-preview.7.22377.1-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/082715a3-03d4-4e8e-92e2-b1b0b3af9f7d/09881075bfdc2579c8016df7a11f6987/windowsdesktop-runtime-7.0.0-preview.7.22377.1-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/54966bf6-7a05-4b40-86fc-bf3d73804412/e0ba9f6ff2b4b2f6d1a04ad34661b9f3/windowsdesktop-runtime-7.0.0-preview.7.22377.1-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/67b8d0c8-511e-4284-a741-d4d62451721d/3c37e14e352c7d30e5101cf90b2151be/windowsdesktop-runtime-7.0.0-preview.7.22377.1-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/09263440-7abc-4da1-9c0a-faa6f4d25c2c/91fd583d7c20bcec5a6dcae7bce21340/windowsdesktop-runtime-7.0.0-preview.7.22377.1-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/73e88a42-b10f-4d17-b87b-e89c7b779e6a/d96be9b459f4493836025c4e8c54812c/windowsdesktop-runtime-7.0.0-preview.7.22377.1-win-x86.zip

[//]: # ( ASP 7.0.0-preview.7.22376.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c3ae0d2-d013-46c3-8892-cb7267a7ff41/e165e668d0e1ca4308d416688e6658af/aspnetcore-runtime-7.0.0-preview.7.22376.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6db9068-b8bf-4148-8c46-b5ee6b5a1a8e/eebc3347e69547e59145094b76efa1f5/aspnetcore-runtime-7.0.0-preview.7.22376.6-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/534528b7-fa63-4a30-a955-ce7b38b49836/d3a4ee5dcc2e64d595826818a6b09054/aspnetcore-runtime-7.0.0-preview.7.22376.6-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5fa7246-5fb0-4147-befb-6621a28bb3fd/9910804fa539f52f89cec2968c6b43bb/aspnetcore-runtime-7.0.0-preview.7.22376.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee3df51e-b96c-419b-871f-1b23bd2ec462/777531cd6ae40b65b5329ff397f02b4b/aspnetcore-runtime-7.0.0-preview.7.22376.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0dcd6772-e520-4827-92e4-ad840230fe1b/fc025ae94601620a7133f8479e8458ec/aspnetcore-runtime-7.0.0-preview.7.22376.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8041c215-8bb1-41f1-b550-ca5298ae49c0/4bf353f81b4b4e0d36146794e0121bde/aspnetcore-runtime-7.0.0-preview.7.22376.6-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a2b2985-e061-44e4-9f9d-915179671a7a/1e4005f1d349063642beb40ee5ac8bf5/aspnetcore-runtime-7.0.0-preview.7.22376.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/11c72c67-d04c-467f-8888-287933dab529/932554eab2f95d9ced409c0bdaeee675/aspnetcore-runtime-7.0.0-preview.7.22376.6-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ea777e69-ab31-4098-961d-94c58f95bdec/b3565a4921faa7505c8846334d9bc182/aspnetcore-runtime-7.0.0-preview.7.22376.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1e840cc8-76b6-4a84-a77d-6fd90706dd6b/172fc9d6307ecc6fbdbbd966c0685bd2/aspnetcore-runtime-7.0.0-preview.7.22376.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/064c9f16-79ab-4544-9d5b-6a8fb8be9606/33df708c6cf4b8e05b37f9e068664d2d/aspnetcore-runtime-7.0.0-preview.7.22376.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0441e297-ed0a-40e2-92b8-8423f6533ce1/627e3a9ab90d5c4477d336aa51de6915/aspnetcore-runtime-7.0.0-preview.7.22376.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/631153b8-471e-4d87-b10b-0189effbb9b6/c2ee977331b586868aeabbeaa85a76b7/dotnet-hosting-7.0.0-preview.7.22376.6-win.exe

[//]: # ( SDK 7.0.100-preview.7.22377.5)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eff0d8e7-a354-486b-b440-261808ebc68f/5271723f2663e5ebd561f733b7088c2f/dotnet-sdk-7.0.100-preview.7.22377.5-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/261a4c75-3058-4319-98b7-050c1c12f8e8/46d3da56919fb74ef4e1eccdfa24e4e8/dotnet-sdk-7.0.100-preview.7.22377.5-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d5ae509-d9c5-4954-a75d-ad0313e0db57/5d7071191a810fd29166583d8aeac8f5/dotnet-sdk-7.0.100-preview.7.22377.5-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f96b33e-f7a5-44e2-a14b-93817c767a96/d5f6b05bd0db4c4adb9d9391f48fb563/dotnet-sdk-7.0.100-preview.7.22377.5-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8f31ca33-f007-4ecd-b6f3-f2edc8f26c24/43b6e9f770f7194b04094848650dcc23/dotnet-sdk-7.0.100-preview.7.22377.5-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aabf15d3-f201-4a6c-9a7e-def050d054af/0a8eba2d8abcf1c28605744f3a48252f/dotnet-sdk-7.0.100-preview.7.22377.5-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/064356b7-bf90-4c32-bfa9-f5acad1b24fb/dafa5b5f0b7c57d851f5af4d78db2f61/dotnet-sdk-7.0.100-preview.7.22377.5-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3b49061-1894-4454-9976-5ee9f310e3e9/36ad0ad134881d00d4e10144ede8cc36/dotnet-sdk-7.0.100-preview.7.22377.5-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c4688e7c-6076-4e7c-bc8d-99ff138f91ce/059f21d41a3e06aeba8ef02d465887ab/dotnet-sdk-7.0.100-preview.7.22377.5-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7936e760-5156-45ec-aee6-ab8cdd988a32/5b3b9cc8a843a60fec8e3ac54b4f830e/dotnet-sdk-7.0.100-preview.7.22377.5-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/07d775fb-749b-4195-aeba-d4430c1d47a6/7ee1a729533cab0610b922fad2b1e553/dotnet-sdk-7.0.100-preview.7.22377.5-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/905442ac-7fe5-4923-95da-04d9e6c75cc6/b0f1e201750bde1eabe8af14926b2971/dotnet-sdk-7.0.100-preview.7.22377.5-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/de09adf7-98ac-4007-8f18-a6f002e4f512/a84f209bc2257378eef88b7f7a9877c3/dotnet-sdk-7.0.100-preview.7.22377.5-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6cab7ce9-f869-4234-afdf-7e0656f2464a/ea6241b4526dc04c97b4c3c64bf54c67/dotnet-sdk-7.0.100-preview.7.22377.5-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/23a80e8a-35ed-43bc-a381-ae9f1f35d410/2bce5097dd493fcb7a3d323b79cc4f5a/dotnet-sdk-7.0.100-preview.7.22377.5-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7667115b-b92a-41e8-8df3-9331f78a5b41/8123f1568794215b8cb93f7608e34109/dotnet-sdk-7.0.100-preview.7.22377.5-win-x86.zip
