# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
     public class Socket : IDisposable {
+        public Task<int> ReceiveAsync(ArraySegment<byte> buffer);
+        public Task<int> ReceiveAsync(IList<ArraySegment<byte>> buffers);
+        public ValueTask<int> ReceiveAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<SocketReceiveFromResult> ReceiveFromAsync(ArraySegment<byte> buffer, EndPoint remoteEndPoint);
+        public ValueTask<SocketReceiveFromResult> ReceiveFromAsync(Memory<byte> buffer, EndPoint remoteEndPoint, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<SocketReceiveMessageFromResult> ReceiveMessageFromAsync(ArraySegment<byte> buffer, EndPoint remoteEndPoint);
+        public ValueTask<SocketReceiveMessageFromResult> ReceiveMessageFromAsync(Memory<byte> buffer, EndPoint remoteEndPoint, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<int> SendAsync(ArraySegment<byte> buffer);
+        public Task<int> SendAsync(IList<ArraySegment<byte>> buffers);
+        public ValueTask<int> SendAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<int> SendToAsync(ArraySegment<byte> buffer, EndPoint remoteEP);
+        public ValueTask<int> SendToAsync(ReadOnlyMemory<byte> buffer, EndPoint remoteEP, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

