# System.Collections.Immutable

``` diff
 namespace System.Collections.Immutable {
     public static class ImmutableArray {
+        public static ImmutableArray<T> Create<T>(ReadOnlySpan<T> items);
+        public static ImmutableArray<T> Create<T>(Span<T> items);
+        public static ImmutableArray<T> ToImmutableArray<T>(this ReadOnlySpan<T> items);
+        public static ImmutableArray<T> ToImmutableArray<T>(this Span<T> items);
     }
     public readonly struct ImmutableArray<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IEquatable<ImmutableArray<T>>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IStructuralComparable, IStructuralEquatable {
+        public ImmutableArray<T> AddRange(ReadOnlySpan<T> items);
+        public ImmutableArray<T> AddRange(params T[] items);
+        public ReadOnlySpan<T> AsSpan(int start, int length);
+        public ReadOnlySpan<T> AsSpan(Range range);
+        public void CopyTo(Span<T> destination);
+        public ImmutableArray<T> InsertRange(int index, ReadOnlySpan<T> items);
+        public ImmutableArray<T> InsertRange(int index, T[] items);
+        public ImmutableArray<T> RemoveRange(ReadOnlySpan<T> items, IEqualityComparer<T>? equalityComparer = null);
+        public ImmutableArray<T> RemoveRange(T[] items, IEqualityComparer<T>? equalityComparer = null);
+        public ImmutableArray<T> Slice(int start, int length);
         public sealed class Builder : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+            public void AddRange(ReadOnlySpan<T> items);
+            public void AddRange<TDerived>(ReadOnlySpan<TDerived> items) where TDerived : T;
+            public void CopyTo(Span<T> destination);
         }
     }
 }
```

