# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
+    public class JsonDerivedTypeAttribute : JsonAttribute {
+        public JsonDerivedTypeAttribute(Type derivedType);
+        public JsonDerivedTypeAttribute(Type derivedType, string typeDiscriminatorId);
+        public Type DerivedType { get; }
+        public string? TypeDiscriminatorId { get; }
+    }
+    public sealed class JsonPolymorphicAttribute : JsonAttribute {
+        public JsonPolymorphicAttribute();
+        public string CustomTypeDiscriminatorPropertyName { get; set; }
+        public bool IgnoreUnrecognizedTypeDiscriminators { get; set; }
+        public JsonUnknownDerivedTypeHandling UnknownDerivedTypeHandling { get; set; }
+    }
+    public class JsonPolymorphicTypeConfiguration : ICollection<(Type, string?)>, IEnumerable, IEnumerable<(Type, string?)> {
+        public JsonPolymorphicTypeConfiguration(Type baseType);
+        public Type BaseType { get; }
+        public string? CustomTypeDiscriminatorPropertyName { get; set; }
+        public bool IgnoreUnrecognizedTypeDiscriminators { get; set; }
+        int ICollection<(Type, string?)>.Count { get; }
+        bool ICollection<(Type, string?)>.IsReadOnly { get; }
+        public JsonUnknownDerivedTypeHandling UnknownDerivedTypeHandling { get; set; }
+        void ICollection<(Type, string?)>.Add((Type DerivedType, string TypeDiscriminatorId) item);
+        void ICollection<(Type, string?)>.Clear();
+        bool ICollection<(Type, string?)>.Contains((Type DerivedType, string TypeDiscriminatorId) item);
+        void ICollection<(Type, string?)>.CopyTo((Type DerivedType, string TypeDiscriminatorId)[] array, int arrayIndex);
+        bool ICollection<(Type, string?)>.Remove((Type DerivedType, string TypeDiscriminatorId) item);
+        IEnumerator<(Type DerivedType, string TypeDiscriminatorId)> IEnumerable<(Type, string?)>.GetEnumerator();
+        IEnumerator IEnumerable.GetEnumerator();
+        public JsonPolymorphicTypeConfiguration WithDerivedType(Type derivedType, string? typeDiscriminatorId = null);
+    }
+    public class JsonPolymorphicTypeConfiguration<TBaseType> : JsonPolymorphicTypeConfiguration where TBaseType : class {
+        public JsonPolymorphicTypeConfiguration();
+        public JsonPolymorphicTypeConfiguration<TBaseType> WithDerivedType<TDerivedType>(string? typeDiscriminatorId = null) where TDerivedType : TBaseType;
+    }
+    public enum JsonUnknownDerivedTypeHandling {
+        FailSerialization = 0,
+        FallbackToBaseType = 1,
+        FallbackToNearestAncestor = 2,
+    }
 }
```

