# System.Collections.Immutable

``` diff
 namespace System.Collections.Immutable {
     public readonly struct ImmutableArray<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IEquatable<ImmutableArray<T>>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IStructuralComparable, IStructuralEquatable {
+        public ImmutableArray<T> AddRange(ImmutableArray<T> items, int length);
+        public ImmutableArray<T> AddRange(T[] items, int length);
+        public ImmutableArray<T> AddRange<TDerived>(ImmutableArray<TDerived> items) where TDerived : T;
+        public ImmutableArray<T> AddRange<TDerived>(TDerived[] items) where TDerived : T;
         public sealed class Builder : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+            public void CopyTo(int sourceIndex, T[] destination, int destinationIndex, int length);
+            public void CopyTo(T[] destination);
+            public int IndexOf(T item, int startIndex, IEqualityComparer<T>? equalityComparer);
+            public void InsertRange(int index, IEnumerable<T> items);
+            public void InsertRange(int index, ImmutableArray<T> items);
+            public bool Remove(T element, IEqualityComparer<T>? equalityComparer);
+            public void RemoveAll(Predicate<T> match);
+            public void RemoveRange(IEnumerable<T> items);
+            public void RemoveRange(IEnumerable<T> items, IEqualityComparer<T>? equalityComparer);
+            public void RemoveRange(int index, int length);
+            public void Replace(T oldValue, T newValue);
+            public void Replace(T oldValue, T newValue, IEqualityComparer<T>? equalityComparer);
         }
     }
     public sealed class ImmutableList<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
         public sealed class Builder : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+            public bool Remove(T item, IEqualityComparer<T>? equalityComparer);
+            public void RemoveRange(IEnumerable<T> items);
+            public void RemoveRange(IEnumerable<T> items, IEqualityComparer<T>? equalityComparer);
+            public void RemoveRange(int index, int count);
+            public void Replace(T oldValue, T newValue);
+            public void Replace(T oldValue, T newValue, IEqualityComparer<T>? equalityComparer);
         }
     }
     public sealed class ImmutableSortedSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableSet<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IReadOnlySet<T>, ISet<T> {
         public sealed class Builder : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISet<T> {
+            public int IndexOf(T item);
         }
     }
 }
```

