# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
-    public ref struct AnsiStringMarshaller {
-        public AnsiStringMarshaller(string? str);
-        public AnsiStringMarshaller(string? str, Span<byte> buffer);
-        public void FreeNative();
-        public unsafe void FromNativeValue(byte* value);
-        public string? ToManaged();
-        public unsafe byte* ToNativeValue();
-    }
-    public ref struct ArrayMarshaller<T> {
-        public ArrayMarshaller(int sizeOfNativeElement);
-        public ArrayMarshaller(T[]? array, int sizeOfNativeElement);
-        public ArrayMarshaller(T[]? array, Span<byte> buffer, int sizeOfNativeElement);
-        public void FreeNative();
-        public unsafe void FromNativeValue(byte* value);
-        public Span<T> GetManagedValuesDestination(int length);
-        public ReadOnlySpan<T> GetManagedValuesSource();
-        public Span<byte> GetNativeValuesDestination();
-        public ReadOnlySpan<byte> GetNativeValuesSource(int length);
-        public ref byte GetPinnableReference();
-        public T[]? ToManaged();
-        public unsafe byte* ToNativeValue();
-    }
-    public sealed class CustomTypeMarshallerAttribute : Attribute {
-        public CustomTypeMarshallerAttribute(Type managedType, CustomTypeMarshallerKind marshallerKind = CustomTypeMarshallerKind.Value);
-        public int BufferSize { get; set; }
-        public CustomTypeMarshallerDirection Direction { get; set; }
-        public CustomTypeMarshallerFeatures Features { get; set; }
-        public Type ManagedType { get; }
-        public CustomTypeMarshallerKind MarshallerKind { get; }
-        public struct GenericPlaceholder
-    }
-    public enum CustomTypeMarshallerDirection {
-        In = 1,
-        None = 0,
-        Out = 2,
-        Ref = 3,
-    }
-    public enum CustomTypeMarshallerFeatures {
-        CallerAllocatedBuffer = 2,
-        None = 0,
-        TwoStageMarshalling = 4,
-        UnmanagedResources = 1,
-    }
-    public enum CustomTypeMarshallerKind {
-        LinearCollection = 1,
-        Value = 0,
-    }
-    public sealed class MarshalUsingAttribute : Attribute {
-        public const string ReturnsCountValue = "return-value";
-        public MarshalUsingAttribute();
-        public MarshalUsingAttribute(Type nativeType);
-        public int ConstantElementCount { get; set; }
-        public string CountElementName { get; set; }
-        public int ElementIndirectionDepth { get; set; }
-        public Type? NativeType { get; }
-    }
-    public sealed class NativeMarshallingAttribute : Attribute {
-        public NativeMarshallingAttribute(Type nativeType);
-        public Type NativeType { get; }
-    }
     public static class NativeMemory {
+        public unsafe static void ZeroMemory(void* ptr, UIntPtr byteCount);
     }
     public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat> {
+        static int System.Numerics.INumberBase<System.Runtime.InteropServices.NFloat>.Radix { get; }
-        public static NFloat CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static NFloat CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static NFloat CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static NFloat Exp10(NFloat x);
+        public static NFloat Exp10M1(NFloat x);
+        public static NFloat Exp2(NFloat x);
+        public static NFloat Exp2M1(NFloat x);
+        public static NFloat ExpM1(NFloat x);
+        public static bool IsEvenInteger(NFloat value);
+        public static bool IsInteger(NFloat value);
+        public static bool IsOddInteger(NFloat value);
+        public static bool IsPositive(NFloat value);
+        public static bool IsRealNumber(NFloat value);
+        public static NFloat Log10P1(NFloat x);
+        public static NFloat Log2P1(NFloat x);
+        public static NFloat LogP1(NFloat x);
+        public static NFloat MaxMagnitudeNumber(NFloat x, NFloat y);
+        public static NFloat MaxNumber(NFloat x, NFloat y);
+        public static NFloat MinMagnitudeNumber(NFloat x, NFloat y);
+        public static NFloat MinNumber(NFloat x, NFloat y);
+        public static explicit operator checked byte (NFloat value);
+        public static explicit operator checked char (NFloat value);
+        public static explicit operator checked short (NFloat value);
+        public static explicit operator checked int (NFloat value);
+        public static explicit operator checked long (NFloat value);
+        public static explicit operator checked Int128 (NFloat value);
+        public static explicit operator checked IntPtr (NFloat value);
+        public static explicit operator checked sbyte (NFloat value);
+        public static explicit operator checked ushort (NFloat value);
+        public static explicit operator checked uint (NFloat value);
+        public static explicit operator checked ulong (NFloat value);
+        public static explicit operator checked UInt128 (NFloat value);
+        public static explicit operator checked UIntPtr (NFloat value);
+        public static explicit operator NFloat (Int128 value);
+        public static explicit operator Half (NFloat value);
+        public static explicit operator Int128 (NFloat value);
+        public static explicit operator UInt128 (NFloat value);
+        public static explicit operator NFloat (UInt128 value);
+        public static implicit operator NFloat (Half value);
-        long IFloatingPoint<NFloat>.GetExponentShortestBitLength();
+        int IFloatingPoint<NFloat>.GetExponentShortestBitLength();
-        long IFloatingPoint<NFloat>.GetSignificandBitLength();
+        int IFloatingPoint<NFloat>.GetSignificandBitLength();
+        bool IFloatingPoint<NFloat>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<NFloat>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        static bool INumberBase<NFloat>.IsCanonical(NFloat value);
+        static bool INumberBase<NFloat>.IsComplexNumber(NFloat value);
+        static bool INumberBase<NFloat>.IsImaginaryNumber(NFloat value);
+        static bool INumberBase<NFloat>.IsZero(NFloat value);
+        static bool INumberBase<NFloat>.TryConvertFromChecked<TOther>(TOther value, out NFloat result);
+        static bool INumberBase<NFloat>.TryConvertFromSaturating<TOther>(TOther value, out NFloat result);
+        static bool INumberBase<NFloat>.TryConvertFromTruncating<TOther>(TOther value, out NFloat result);
+        static bool INumberBase<NFloat>.TryConvertToChecked<TOther>(NFloat value, out TOther result);
+        static bool INumberBase<NFloat>.TryConvertToSaturating<TOther>(NFloat value, out TOther result);
+        static bool INumberBase<NFloat>.TryConvertToTruncating<TOther>(NFloat value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out NFloat result) where TOther : INumber<TOther>;
     }
-    public ref struct PointerArrayMarshaller<T> where T : struct {
-        public PointerArrayMarshaller(int sizeOfNativeElement);
-        public PointerArrayMarshaller(T*[]? array, int sizeOfNativeElement);
-        public PointerArrayMarshaller(T*[]? array, Span<byte> buffer, int sizeOfNativeElement);
-        public void FreeNative();
-        public unsafe void FromNativeValue(byte* value);
-        public Span<IntPtr> GetManagedValuesDestination(int length);
-        public ReadOnlySpan<IntPtr> GetManagedValuesSource();
-        public Span<byte> GetNativeValuesDestination();
-        public ReadOnlySpan<byte> GetNativeValuesSource(int length);
-        public ref byte GetPinnableReference();
-        public T*[]? ToManaged();
-        public unsafe byte* ToNativeValue();
-    }
-    public ref struct Utf16StringMarshaller {
-        public Utf16StringMarshaller(string? str);
-        public Utf16StringMarshaller(string? str, Span<ushort> buffer);
-        public void FreeNative();
-        public unsafe void FromNativeValue(ushort* value);
-        public ref ushort GetPinnableReference();
-        public string? ToManaged();
-        public unsafe ushort* ToNativeValue();
-    }
-    public ref struct Utf8StringMarshaller {
-        public Utf8StringMarshaller(string? str);
-        public Utf8StringMarshaller(string? str, Span<byte> buffer);
-        public void FreeNative();
-        public unsafe void FromNativeValue(byte* value);
-        public string? ToManaged();
-        public unsafe byte* ToNativeValue();
-    }
 }
```

