# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class DefaultEndpointFilterInvocationContext : EndpointFilterInvocationContext {
+        public DefaultEndpointFilterInvocationContext(HttpContext httpContext, params object[] arguments);
+        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
+        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
+        public override IList<object?> Arguments { [CompilerGeneratedAttribute] get; }
+        public override HttpContext HttpContext { [CompilerGeneratedAttribute] get; }
+        public override T GetArgument<T>(int index);
+    }
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    public sealed class DefaultRouteHandlerInvocationContext : RouteHandlerInvocationContext {
-        public DefaultRouteHandlerInvocationContext(HttpContext httpContext, params object[] arguments);
-        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
-        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
-        public override IList<object?> Arguments { [CompilerGeneratedAttribute] get; }
-        public override HttpContext HttpContext { [CompilerGeneratedAttribute] get; }
-        public override T GetArgument<T>(int index);
-    }
+    public delegate ValueTask<object?> EndpointFilterDelegate(EndpointFilterInvocationContext context);
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public static class EndpointFilterExtensions {
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddEndpointFilter<TBuilder, TFilterType>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder where TFilterType : IEndpointFilter;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, IEndpointFilter filter) where TBuilder : IEndpointConventionBuilder;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate> filterFactory) where TBuilder : IEndpointConventionBuilder;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, [NullableAttribute(new byte[]{ (byte)1, (byte)1, (byte)1, (byte)0, (byte)2})] Func<EndpointFilterInvocationContext, EndpointFilterDelegate, ValueTask<object?>> routeHandlerFilter) where TBuilder : IEndpointConventionBuilder;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder AddEndpointFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IEndpointFilter;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteGroupBuilder AddEndpointFilter<TFilterType>(this RouteGroupBuilder builder) where TFilterType : IEndpointFilter;
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class EndpointFilterFactoryContext {
+        public EndpointFilterFactoryContext(MethodInfo methodInfo, IList<object> endpointMetadata, IServiceProvider applicationServices);
+        public IServiceProvider ApplicationServices { [CompilerGeneratedAttribute] get; }
+        public IList<object> EndpointMetadata { [CompilerGeneratedAttribute] get; }
+        public MethodInfo MethodInfo { [CompilerGeneratedAttribute] get; }
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public abstract class EndpointFilterInvocationContext {
+        protected EndpointFilterInvocationContext();
+        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
+        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
+        public abstract IList<object?> Arguments { get; }
+        public abstract HttpContext HttpContext { get; }
+        public abstract T GetArgument<T>(int index);
+    }
+    [NullableContextAttribute((byte)2)]
+    public interface IContentTypeHttpResult {
+        string ContentType { get; }
+    }
+    [NullableContextAttribute((byte)1)]
+    public interface IEndpointFilter {
+        [return: NullableAttribute(new byte[]{ (byte)0, (byte)2})]
+        ValueTask<object?> InvokeAsync(EndpointFilterInvocationContext context, EndpointFilterDelegate next);
+    }
+    [NullableContextAttribute((byte)2)]
+    public interface IFileHttpResult {
+        string ContentType { get; }
+        string FileDownloadName { get; }
+    }
+    [NullableContextAttribute((byte)1)]
+    public interface INestedHttpResult {
+        IResult Result { get; }
+    }
+    [NullableContextAttribute((byte)1)]
+    public interface IProblemDetailsService {
+        ValueTask WriteAsync(ProblemDetailsContext context);
+    }
+    [NullableContextAttribute((byte)1)]
+    public interface IProblemDetailsWriter {
+        bool CanWrite(ProblemDetailsContext context);
+        ValueTask WriteAsync(ProblemDetailsContext context);
+    }
-    [NullableContextAttribute((byte)1)]
-    public interface IRouteHandlerFilter {
-        [return: NullableAttribute(new byte[]{ (byte)0, (byte)2})]
-        ValueTask<object?> InvokeAsync(RouteHandlerInvocationContext context, RouteHandlerFilterDelegate next);
-    }
+    public interface IStatusCodeHttpResult {
+        int? StatusCode { get; }
+    }
+    [NullableContextAttribute((byte)2)]
+    public interface IValueHttpResult {
+        object Value { get; }
+    }
+    [NullableContextAttribute((byte)2)]
+    public interface IValueHttpResult<out TValue> {
+        TValue Value { get; }
+    }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class ProblemDetailsContext {
+        public ProblemDetailsContext();
+        [NullableAttribute((byte)2)]
+        public EndpointMetadataCollection? AdditionalMetadata { [CompilerGeneratedAttribute, NullableContextAttribute((byte)2)] get; [CompilerGeneratedAttribute, NullableContextAttribute((byte)2)] set; }
+        public required HttpContext HttpContext { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        public ProblemDetails ProblemDetails { get; set; }
+    }
+    public class ProblemDetailsOptions {
+        public ProblemDetailsOptions();
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        public Action<ProblemDetailsContext>? CustomizeProblemDetails { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+    }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)2)]
     public sealed class RequestDelegateFactoryOptions {
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1, (byte)1, (byte)1, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1, (byte)1, (byte)1, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1, (byte)1, (byte)1, (byte)1})]
+        public IReadOnlyList<Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate>>? EndpointFilterFactories { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
-        [NullableAttribute(new byte[]{ (byte)2, (byte)1, (byte)1, (byte)1, (byte)1})]
-        [NullableAttribute(new byte[]{ (byte)2, (byte)1, (byte)1, (byte)1, (byte)1})]
-        [NullableAttribute(new byte[]{ (byte)2, (byte)1, (byte)1, (byte)1, (byte)1})]
-        public IReadOnlyList<Func<RouteHandlerContext, RouteHandlerFilterDelegate, RouteHandlerFilterDelegate>>? RouteHandlerFilterFactories { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)2)]
     public static class Results {
+        [NullableContextAttribute((byte)0)]
+        [return: NullableAttribute((byte)1)]
+        public static IResult Text(ReadOnlySpan<byte> utf8Content, [NullableAttribute((byte)2)] string? contentType = null, int? statusCode = default(int?));
     }
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    public sealed class RouteHandlerContext {
-        public RouteHandlerContext(MethodInfo methodInfo, IList<object> endpointMetadata, IServiceProvider applicationServices);
-        public IServiceProvider ApplicationServices { [CompilerGeneratedAttribute] get; }
-        public IList<object> EndpointMetadata { [CompilerGeneratedAttribute] get; }
-        public MethodInfo MethodInfo { [CompilerGeneratedAttribute] get; }
-    }
-    public delegate ValueTask<object?> RouteHandlerFilterDelegate(RouteHandlerInvocationContext context);
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    public static class RouteHandlerFilterExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddRouteHandlerFilter<TBuilder, TFilterType>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder where TFilterType : IRouteHandlerFilter;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddRouteHandlerFilter<TBuilder>(this TBuilder builder, IRouteHandlerFilter filter) where TBuilder : IEndpointConventionBuilder;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddRouteHandlerFilter<TBuilder>(this TBuilder builder, Func<RouteHandlerContext, RouteHandlerFilterDelegate, RouteHandlerFilterDelegate> filterFactory) where TBuilder : IEndpointConventionBuilder;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddRouteHandlerFilter<TBuilder>(this TBuilder builder, [NullableAttribute(new byte[]{ (byte)1, (byte)1, (byte)1, (byte)0, (byte)2})] Func<RouteHandlerInvocationContext, RouteHandlerFilterDelegate, ValueTask<object?>> routeHandlerFilter) where TBuilder : IEndpointConventionBuilder;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder AddRouteHandlerFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IRouteHandlerFilter;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteGroupBuilder AddRouteHandlerFilter<TFilterType>(this RouteGroupBuilder builder) where TFilterType : IRouteHandlerFilter;
-    }
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    public abstract class RouteHandlerInvocationContext {
-        protected RouteHandlerInvocationContext();
-        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
-        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
-        public abstract IList<object?> Arguments { get; }
-        public abstract HttpContext HttpContext { get; }
-        public abstract T GetArgument<T>(int index);
-    }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)2)]
     public static class TypedResults {
+        [NullableContextAttribute((byte)0)]
+        [return: NullableAttribute((byte)1)]
+        public static Utf8ContentHttpResult Text(ReadOnlySpan<byte> utf8Content, [NullableAttribute((byte)2)] string? contentType = null, int? statusCode = default(int?));
     }
 }
```

